/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.tribble.Feature;
import java.io.IOException;
import java.util.Iterator;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.track.FeatureSource;

class FeatureTrackUtils {
    static int binSize = 1000;

    FeatureTrackUtils() {
    }

    public static Feature nextFeature(FeatureSource source, String chr, int initStart, int initEnd, boolean forward) throws IOException {
        Feature f = null;
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (forward) {
            int nextStart = initEnd;
            String nextChr = chr;
            while (nextChr != null) {
                int chrLength = genome.getChromosome(nextChr).getLength();
                while (nextStart < chrLength) {
                    int nextEnd = binSize > 0 ? nextStart + binSize : chrLength;
                    Iterator iter = source.getFeatures(nextChr, nextStart, nextEnd);
                    if (iter != null) {
                        while (iter.hasNext()) {
                            Feature feat = (Feature)iter.next();
                            if (feat.getStart() <= nextStart) continue;
                            return feat;
                        }
                    }
                    nextStart = nextEnd;
                }
                nextChr = genome.getNextChrName(nextChr);
                nextStart = 0;
            }
        } else {
            int nextEnd = initStart;
            String nextChr = chr;
            while (nextChr != null) {
                while (nextEnd > 0) {
                    int nextStart = binSize > 0 ? Math.max(0, nextEnd - binSize) : 0;
                    Iterator iter = source.getFeatures(nextChr, nextStart, nextEnd);
                    if (iter != null && iter.hasNext()) {
                        Feature prevFeature = null;
                        while (iter.hasNext()) {
                            Feature feat = (Feature)iter.next();
                            if (feat.getStart() >= nextEnd) continue;
                            prevFeature = feat;
                        }
                        if (prevFeature != null) {
                            return prevFeature;
                        }
                    }
                    nextEnd = nextStart;
                }
                if ((nextChr = genome.getPrevChrName(nextChr)) == null) continue;
                nextEnd = genome.getChromosome(nextChr).getLength();
            }
        }
        return f;
    }
}

