/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.gwas.GWASFeature;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class GWASParser {
    private static final Logger log = LogManager.getLogger(GWASParser.class);
    private ResourceLocator locator;
    Genome genome;
    private GWASColumns columns;

    public static boolean isGWASFile(String typeString) {
        return typeString.endsWith("logistic") || typeString.endsWith("linear") || typeString.endsWith("assoc") || typeString.endsWith("qassoc") || typeString.endsWith("gwas");
    }

    public GWASParser(ResourceLocator locator, Genome genome) {
        this.locator = locator;
        this.genome = genome;
        this.columns = new GWASColumns();
    }

    public String[] getColumnHeaders() {
        return this.columns.columnHeaders;
    }

    public Map<String, List<GWASFeature>> parse() throws IOException {
        BufferedReader reader = null;
        String nextLine = null;
        int rowCounter = 0;
        HashMap<String, ArrayList<GWASFeature>> features = new HashMap<String, ArrayList<GWASFeature>>();
        try {
            reader = ParsingUtils.openBufferedReader(this.locator);
            String headerLine = reader.readLine();
            if (!this.columns.parseHeader(headerLine)) {
                throw new ParserException("Error while parsing header line.", 0L, nextLine);
            }
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                nextLine = nextLine.trim();
                GWASFeature f = null;
                f = this.parseLine(nextLine, ++rowCounter);
                List<GWASFeature> featureList = (List)features.get(f.chr);
                if (featureList == null) {
                    featureList = new ArrayList<GWASFeature>();
                    features.put(f.chr, (ArrayList<GWASFeature>)featureList);
                }
                featureList.add(f);
            }
            for (List<GWASFeature> featureList : features.values()) {
                featureList.sort(Comparator.comparingInt(o -> o.position));
            }
            HashMap<String, ArrayList<GWASFeature>> hashMap = features;
            return hashMap;
        }
        catch (Exception e) {
            if (nextLine != null && rowCounter != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, rowCounter, nextLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private GWASFeature parseLine(String nextLine, long lineNumber) {
        String[] tokens = nextLine.split("\\t|( +)");
        if (tokens.length >= 3) {
            int position;
            String chr = tokens[this.columns.chrCol].trim();
            if (this.genome != null) {
                chr = this.genome.getCanonicalChrName(chr);
            }
            try {
                position = Integer.parseInt(tokens[this.columns.locationCol].trim());
            }
            catch (NumberFormatException e) {
                throw new ParserException("Column " + this.columns.locationCol + " must be a numeric value.", lineNumber, nextLine);
            }
            if (!tokens[this.columns.pCol].trim().equalsIgnoreCase("NA")) {
                double p;
                try {
                    p = Double.parseDouble(tokens[this.columns.pCol]);
                    if (p <= 0.0) {
                        throw new NumberFormatException();
                    }
                    p = -Math.log10(p);
                }
                catch (NumberFormatException e) {
                    throw new ParserException("Column " + this.columns.pCol + " must be a positive numeric value. Found " + tokens[this.columns.pCol], lineNumber, nextLine);
                }
                return new GWASFeature(chr, position, p, nextLine);
            }
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        GWASParser parser = new GWASParser(new ResourceLocator("test/data/gwas/smallp.gwas"), null);
        Map<String, List<GWASFeature>> data = parser.parse();
        for (List<GWASFeature> features : data.values()) {
            for (GWASFeature f : features) {
                double val = f.value;
                System.out.println(val);
            }
        }
    }

    public static class GWASColumns {
        public int locationCol = 2;
        public int chrCol = 1;
        public int pCol = 3;
        public int SNPCol = 0;
        private String[] columnHeaders;

        public boolean hasAllFields() {
            return this.locationCol >= 0 || this.chrCol >= 0 || this.pCol >= 0 || this.SNPCol >= 0;
        }

        public boolean parseHeader(String headerString) {
            Pattern whitespacePattern = Pattern.compile("\\s+");
            try {
                headerString = headerString.trim();
                String[] headers = headerString.split("\\t|( +)");
                this.columnHeaders = headers;
                int headersSize = headers.length;
                if (headersSize < 4) {
                    return false;
                }
                for (int colCounter = 0; colCounter < headersSize; ++colCounter) {
                    String header = headers[colCounter];
                    if ((header = header.toLowerCase()).equals("chr") || header.equals("chromosome")) {
                        this.chrCol = colCounter;
                    }
                    if (header.equals("bp") || header.equals("pos") || header.equals("position")) {
                        this.locationCol = colCounter;
                    }
                    if (header.equals("p") || header.equals("pval") || header.equals("p-value") || header.equals("pvalue") || header.equals("p.value")) {
                        this.pCol = colCounter;
                    }
                    if (!header.equals("snp") && !header.equals("rs") && !header.equals("rsid") && !header.equals("rsnum") && !header.equals("id") && !header.equals("marker") && !header.equals("markername")) continue;
                    this.SNPCol = colCounter;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.hasAllFields();
        }
    }
}

