/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CompletableFutureExample {
    private static final ExecutorService threadExecutor = Executors.newFixedThreadPool(5);

    public static void main(String[] args) {
        CompletableFutureExample.go();
    }

    private static void go() {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        int i = 0;
        while (i < 5) {
            int finalI = i++;
            futures.add(CompletableFuture.runAsync(() -> new Task(finalI).doit(), threadExecutor));
        }
        CompletableFuture[] futureArray = futures.toArray(new CompletableFuture[futures.size()]);
        try {
            CompletableFuture.allOf(futureArray).get();
            System.out.println("Done");
            System.exit(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    static class Task {
        int n;

        public Task(int n) {
            this.n = n;
        }

        void doit() {
            System.out.println("Start " + this.n);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("End " + this.n);
        }
    }
}

