/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.LittleEndianInputStream;

public class BBFileHeader {
    private static Logger log = LogManager.getLogger(BBFileHeader.class);
    public static final int BBFILE_HEADER_SIZE = 64;
    public static final int BIGWIG_MAGIC_LTH = -2003829722;
    public static final int BIGWIG_MAGIC_HTL = 654085990;
    public static final int BIGBED_MAGIC_LTH = -2021002517;
    public static final int BIGBED_MAGIC_HTL = -336426617;
    private String path;
    private SeekableStream fis;
    private long fileHeaderOffset;
    private boolean isHeaderOK;
    private boolean isLowToHigh;
    private boolean isBigBed;
    private boolean isBigWig;
    private int magic;
    private int version;
    private int nZoomLevels;
    private long chromTreeOffset;
    private long fullDataOffset;
    private long fullIndexOffset;
    private int fieldCount;
    private int definedFieldCount;
    private long autoSqlOffset;
    private long totalSummaryOffset;
    private int uncompressBuffSize;
    private long reserved;

    public BBFileHeader(String path, SeekableStream fis, long fileOffset) {
        this.path = path;
        this.fis = fis;
        this.fileHeaderOffset = fileOffset;
        this.isHeaderOK = this.readBBFileHeader(this.fileHeaderOffset);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isHeaderOK() {
        return this.isHeaderOK;
    }

    public boolean isLowToHigh() {
        return this.isLowToHigh;
    }

    public boolean isBigBed() {
        return this.isBigBed;
    }

    public boolean isBigWig() {
        return this.isBigWig;
    }

    public int getFileHeaderSize() {
        return 64;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getVersion() {
        return this.version;
    }

    public int getZoomLevels() {
        return this.nZoomLevels;
    }

    public long getChromosomeTreeOffset() {
        return this.chromTreeOffset;
    }

    public long getFullDataOffset() {
        return this.fullDataOffset;
    }

    public long getFullIndexOffset() {
        return this.fullIndexOffset;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int getDefinedFieldCount() {
        return this.definedFieldCount;
    }

    public long getAutoSqlOffset() {
        return this.autoSqlOffset;
    }

    public long getTotalSummaryOffset() {
        return this.totalSummaryOffset;
    }

    public int getUncompressBuffSize() {
        return this.uncompressBuffSize;
    }

    public void print() {
        if (this.isHeaderOK) {
            if (this.isBigWig()) {
                System.out.println("BigWig file " + this.path + ", file header at location " + this.fileHeaderOffset);
            } else if (this.isBigBed()) {
                System.out.println("BigBed file " + this.path + ", file header at location " + this.fileHeaderOffset);
            }
        } else {
            System.out.println("BBFile " + this.path + "  with bad magic = " + this.magic + " from file header location " + this.fileHeaderOffset);
            return;
        }
        System.out.println("BBFile header magic = " + this.magic);
        System.out.println("Version = " + this.version);
        System.out.println("Zoom Levels = " + this.nZoomLevels);
        System.out.println("Chromosome Info B+ tree offset = " + this.chromTreeOffset);
        System.out.println("Data Block offset = " + this.fullDataOffset);
        System.out.println("Chromosome Data R+ tree offset = " + this.fullIndexOffset);
        System.out.println("Bed fields count = " + this.fieldCount);
        System.out.println("Bed defined fields count = " + this.definedFieldCount);
        System.out.println("AutoSql Offset = " + this.autoSqlOffset);
        System.out.println("Total Summary offset = " + this.totalSummaryOffset);
        System.out.println("Maximum uncompressed buffer size = " + this.uncompressBuffSize);
        System.out.println("m_reserved = " + this.reserved);
    }

    private boolean readBBFileHeader(long fileOffset) {
        Object bbHeader = null;
        LittleEndianInputStream lbdis = null;
        DataInputStream bdis = null;
        byte[] buffer = new byte[64];
        try {
            this.fis.seek(fileOffset);
            this.fis.readFully(buffer);
            this.isLowToHigh = true;
            lbdis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
            this.magic = lbdis.readInt();
            if (this.magic == -2003829722) {
                this.isBigWig = true;
            } else if (this.magic == -2021002517) {
                this.isBigBed = true;
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(buffer));
                this.magic = bdis.readInt();
                if (this.magic == 654085990) {
                    this.isBigWig = true;
                } else if (this.magic == -336426617) {
                    this.isBigBed = true;
                } else {
                    return false;
                }
                this.isLowToHigh = false;
            }
            if (this.isLowToHigh) {
                this.version = lbdis.readUShort();
                this.nZoomLevels = lbdis.readUShort();
                this.chromTreeOffset = lbdis.readLong();
                this.fullDataOffset = lbdis.readLong();
                this.fullIndexOffset = lbdis.readLong();
                this.fieldCount = lbdis.readUShort();
                this.definedFieldCount = lbdis.readUShort();
                this.autoSqlOffset = lbdis.readLong();
                this.totalSummaryOffset = lbdis.readLong();
                this.uncompressBuffSize = lbdis.readInt();
                this.reserved = lbdis.readLong();
            } else {
                this.version = (short)bdis.readUnsignedShort();
                this.nZoomLevels = (short)bdis.readUnsignedShort();
                this.chromTreeOffset = bdis.readLong();
                this.fullDataOffset = bdis.readLong();
                this.fullIndexOffset = bdis.readLong();
                this.fieldCount = (short)bdis.readUnsignedShort();
                this.definedFieldCount = (short)bdis.readUnsignedShort();
                this.autoSqlOffset = bdis.readLong();
                this.totalSummaryOffset = bdis.readLong();
                this.uncompressBuffSize = bdis.readInt();
                this.reserved = bdis.readLong();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading file header for " + this.path, ex);
        }
        return true;
    }
}

