/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.LineIteratorImpl;
import htsjdk.tribble.readers.LineReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.Mutation;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.collections.MultiMap;

public class MUTCodec
extends AsciiFeatureCodec<Mutation> {
    private static Logger log = LogManager.getLogger(MUTCodec.class);
    private String path;
    private boolean isMAF;
    private String[] headers;
    private String[] samples;
    private Genome genome;
    private int chrColumn;
    private int startColumn;
    private int endColumn;
    private int sampleColumn = -1;
    private int typeColumn = -1;
    private int refAlleleColumn = -1;
    private int tumorAllele1Column = -1;
    private int tumorAllele2Column = -1;
    private int errorCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MUTCodec(String path, Genome genome) {
        super(Mutation.class);
        this.path = path;
        this.genome = genome;
        InputStream is = null;
        try {
            is = ParsingUtils.openInputStream(path);
            LineIteratorImpl reader = new LineIteratorImpl((LineReader)new AsciiLineReader(is));
            this.readActualHeader((LineIterator)reader);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Void readActualHeader(LineIterator reader) {
        String nextLine = null;
        while (reader.hasNext()) {
            String[] tokens;
            nextLine = reader.peek();
            if (nextLine.startsWith("#")) {
                if (nextLine.startsWith("#samples")) {
                    tokens = Globals.whitespacePattern.split(nextLine, 2);
                    if (tokens.length < 2) {
                        log.error("Error parsing sample header in mutation file: " + this.path);
                    } else {
                        this.samples = Globals.commaPattern.split(tokens[1]);
                        for (int i = 0; i < this.samples.length; ++i) {
                            this.samples[i] = this.samples[i].trim();
                        }
                    }
                }
                reader.next();
                continue;
            }
            tokens = Globals.tabPattern.split(nextLine);
            if (tokens.length >= 5) {
                reader.next();
                this.headers = tokens;
                this.isMAF = this.headers[0].trim().equalsIgnoreCase("Hugo_Symbol") || MUTCodec.isMafLiteFile(this.headers);
                this.setColumns(this.isMAF, tokens);
                return null;
            }
            throw new RuntimeException(String.format("Not enough columns in header line found in %s: %s", this.path, nextLine));
        }
        throw new RuntimeException("Unexpected end-of-file (no header line): " + this.path);
    }

    public String[] getSamples() {
        return this.samples;
    }

    public int getChrColumn() {
        return this.chrColumn;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public Mutation decode(String line) {
        int end;
        int start;
        if (line.startsWith("#") || line.startsWith("Hugo_Symbol")) {
            return null;
        }
        String[] tokens = Globals.tabPattern.split(line);
        String chr = this.genome == null ? tokens[this.chrColumn].trim() : this.genome.getCanonicalChrName(tokens[this.chrColumn].trim());
        try {
            start = Integer.parseInt(tokens[this.startColumn].trim());
        }
        catch (NumberFormatException e) {
            ++this.errorCount;
            if (this.errorCount > 100) {
                throw new DataLoadException("Column " + (this.startColumn + 1) + " must be a numeric value.", this.path);
            }
            log.error("Error parsing line: " + line);
            return null;
        }
        try {
            end = Integer.parseInt(tokens[this.endColumn].trim());
        }
        catch (NumberFormatException e) {
            ++this.errorCount;
            if (this.errorCount > 100) {
                throw new DataLoadException("Column " + (this.endColumn + 1) + " must be a numeric value.", this.path);
            }
            log.warn("Error parsing line: " + line);
            return null;
        }
        if (this.isMAF || start == end) {
            --start;
        }
        String sampleId = "Unknown";
        if (this.sampleColumn >= 0) {
            sampleId = tokens[this.sampleColumn].trim();
        }
        String type = "Unknown";
        if (this.typeColumn >= 0) {
            type = tokens[this.typeColumn].trim();
        }
        MultiMap<String, String> attributes = new MultiMap<String, String>();
        int n = Math.min(this.headers.length, tokens.length);
        for (int i = 0; i < n; ++i) {
            String key = this.headers[i];
            String value = tokens[i];
            if (value.length() <= 0) continue;
            attributes.put(key, value);
        }
        Mutation mut = new Mutation(sampleId, chr, start, end, type);
        mut.setAttributes(attributes);
        if (this.refAlleleColumn > 0) {
            mut.setRefAllele(tokens[this.refAlleleColumn].trim());
        }
        if (this.tumorAllele1Column > 0) {
            mut.setAltAllele1(tokens[this.tumorAllele1Column].trim());
        }
        if (this.tumorAllele2Column > 0) {
            mut.setAltAllele2(tokens[this.tumorAllele2Column].trim());
        }
        return mut;
    }

    private void setColumns(boolean isMAF, String[] tokens) {
        this.isMAF = isMAF;
        if (isMAF) {
            block26: for (int i = 0; i < tokens.length; ++i) {
                switch (tokens[i].toLowerCase()) {
                    case "chromosome": 
                    case "chr": {
                        this.chrColumn = i;
                        continue block26;
                    }
                    case "start_position": 
                    case "start": {
                        this.startColumn = i;
                        continue block26;
                    }
                    case "end_position": 
                    case "end": {
                        this.endColumn = i;
                        continue block26;
                    }
                    case "tumor_sample_barcode": 
                    case "tumor_barcode": {
                        this.sampleColumn = i;
                        continue block26;
                    }
                    case "variant_classification": {
                        this.typeColumn = i;
                        continue block26;
                    }
                    case "reference_allele": 
                    case "ref_allele": {
                        this.refAlleleColumn = i;
                        continue block26;
                    }
                    case "tumor_seq_allele1": 
                    case "alt_allele": {
                        this.tumorAllele1Column = i;
                        continue block26;
                    }
                    case "tumor_seq_allele2": {
                        this.tumorAllele2Column = i;
                    }
                }
            }
        } else {
            this.chrColumn = 0;
            this.startColumn = 1;
            this.endColumn = 2;
            this.sampleColumn = 3;
            this.typeColumn = 4;
            this.refAlleleColumn = -1;
            this.tumorAllele1Column = -1;
            this.tumorAllele2Column = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMutationAnnotationFile(ResourceLocator locator) {
        String ext = locator.getFormat();
        if (ext.equals("mut")) {
            return true;
        }
        BufferedReader reader = null;
        String path = locator.getPath();
        if (path == null) {
            return false;
        }
        try {
            String nextLine;
            reader = ParsingUtils.openBufferedReader(path);
            if (reader == null) {
                boolean bl = false;
                return bl;
            }
            while ((nextLine = reader.readLine()) != null && nextLine.startsWith("#")) {
                if (!nextLine.startsWith("#")) continue;
            }
            String[] tokens = Globals.tabPattern.split(nextLine);
            if (tokens.length > 5 && tokens[0].equalsIgnoreCase("Hugo_Symbol")) {
                boolean bl = true;
                return bl;
            }
            if (MUTCodec.isMafLiteFile(tokens)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("Error closing: " + path, e);
                }
            }
        }
    }

    public static boolean isMafLiteFile(String[] tokens) {
        String[] requiredFields;
        HashSet<String> tokenSet = new HashSet<String>(Arrays.asList(tokens));
        for (String f : requiredFields = new String[]{"build", "chr", "start", "end", "ref_allele", "alt_allele"}) {
            if (tokenSet.contains(f)) continue;
            return false;
        }
        return true;
    }

    public boolean canDecode(String path) {
        return MUTCodec.isMutationAnnotationFile(new ResourceLocator(path));
    }
}

