/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.ClearRegionsMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;

public class ExportTrackNamesMenuAction
extends MenuAction {
    static Logger log = LogManager.getLogger(ClearRegionsMenuAction.class);
    IGV igv;

    public ExportTrackNamesMenuAction(String label, IGV mainFrame) {
        super(label, null);
        this.igv = mainFrame;
        this.setToolTipText("Save all defined regions to a file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        ExportTrackNamesMenuAction exportTrackNamesMenuAction = this;
        FileDialog fd = new FileDialog(exportTrackNamesMenuAction.igv.getMainFrame());
        fd.setModal(true);
        fd.setMode(1);
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname == null) {
            return;
        }
        File outputFile = new File(fd.getDirectory(), fname);
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new FileWriter(outputFile));
            List<ReferenceFrame> referenceFrames = FrameManager.getFrames();
            if (referenceFrames.size() > 1) {
                pw.print("Sample");
                for (ReferenceFrame frame : referenceFrames) {
                    pw.print("\t" + frame.getName());
                }
                pw.println();
            }
            for (Track t : this.igv.getAllTracks()) {
                if (t.getTrackType() != TrackType.COPY_NUMBER && t.getTrackType() != TrackType.CNV) continue;
                pw.print(t.getName());
                for (ReferenceFrame frame : referenceFrames) {
                    String chr = frame.getChrName();
                    int start = (int)frame.getOrigin();
                    int end = (int)frame.getEnd();
                    float score = t.getRegionScore(chr, start, end, frame.getZoom(), RegionScoreType.SCORE, frame.getName());
                    pw.print("\t" + score);
                }
                pw.println();
            }
        }
    }
}

