/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.swing.JMenuItem;
import org.broad.igv.event.DataLoadedEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.PSLRecord;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.blat.BlatClient;
import org.broad.igv.util.blat.BlatQueryWindow;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BlatTrack
extends FeatureTrack {
    private static Logger log = LogManager.getLogger(BlatTrack.class);
    private static Random rand = new Random();
    String sequence;
    String db;
    List<PSLRecord> features;

    public BlatTrack() {
        this.setDisplayMode(Track.DisplayMode.SQUISHED);
        this.setColor(Color.DARK_GRAY);
    }

    public BlatTrack(String db, String sequence, List<PSLRecord> features, String trackLabel) {
        super(null, BlatTrack.guid(), trackLabel);
        this.setDisplayMode(Track.DisplayMode.SQUISHED);
        this.setColor(Color.DARK_GRAY);
        this.db = db;
        this.sequence = sequence;
        this.features = features;
        this.init();
    }

    private void init() {
        this.setUseScore(true);
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        this.source = new FeatureCollectionSource(this.features, genome);
        this.renderer = new IGVFeatureRenderer();
        IGVEventBus.getInstance().subscribe(DataLoadedEvent.class, this);
    }

    private void openTableView() {
        BlatQueryWindow win = new BlatQueryWindow(IGV.getMainFrame(), this.sequence, this.features);
        win.setVisible(true);
    }

    public List<PSLRecord> getFeatures() {
        return this.features;
    }

    @Override
    protected boolean isShowFeatures(ReferenceFrame frame) {
        return true;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = TrackMenuUtils.getPopupMenu(Arrays.asList(this), "Menu", te);
        JMenuItem item = new JMenuItem("Open table view");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlatTrack.this.openTableView();
            }
        });
        menu.addSeparator();
        menu.add(item);
        return menu;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        element.setAttribute("db", this.db);
        element.setAttribute("sequence", this.sequence);
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        if (element.hasAttribute("sequence")) {
            String db;
            String sequence = element.getAttribute("sequence");
            if (sequence == null || sequence.length() == 0) {
                sequence = element.getAttribute("id");
            }
            if ((db = element.getAttribute("db")) == null || db.length() == 0) {
                db = GenomeManager.getInstance().getCurrentGenome().getBlatDB();
            }
            try {
                this.features = BlatClient.blat(db, sequence);
            }
            catch (Exception e) {
                MessageUtils.showMessage("Error restoring blat track: " + e.getMessage());
                log.error("Error restoring blat track", e);
            }
        } else {
            String tmp = element.getAttribute("tokensList");
            List<String> tokensList = Arrays.asList(tmp.split("\n"));
            Genome genome = GenomeManager.getInstance().getCurrentGenome();
            PSLCodec codec = new PSLCodec(genome, true);
            this.features = new ArrayList<PSLRecord>(tokensList.size());
            for (String tokens : tokensList) {
                PSLRecord f = codec.decode(tokens);
                if (f == null) continue;
                this.features.add(f);
            }
        }
        this.init();
    }

    private static String guid() {
        return "" + rand.nextInt();
    }
}

