/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.fastq;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.fastq.FastqEncoder;
import htsjdk.samtools.fastq.FastqRecord;
import htsjdk.samtools.fastq.FastqWriter;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.Flushable;
import java.io.OutputStream;
import java.io.PrintStream;

public class BasicFastqWriter
implements FastqWriter,
Flushable {
    private final String path;
    private final PrintStream writer;

    public BasicFastqWriter(File file) {
        this(file, false);
    }

    public BasicFastqWriter(File file, boolean createMd5) {
        this(file, new PrintStream(IOUtil.maybeBufferOutputStream(BasicFastqWriter.maybeMd5Wrap(file, createMd5))));
    }

    private BasicFastqWriter(File file, PrintStream writer) {
        this.path = file != null ? file.getAbsolutePath() : "";
        this.writer = writer;
    }

    public BasicFastqWriter(PrintStream writer) {
        this(null, writer);
    }

    @Override
    public void write(FastqRecord rec) {
        FastqEncoder.write(this.writer, rec);
        this.writer.println();
    }

    private void checkError() {
        if (this.writer.checkError()) {
            throw new SAMException("Error in writing fastq file " + this.path);
        }
    }

    @Override
    public void flush() {
        this.checkError();
        this.writer.flush();
    }

    @Override
    public void close() {
        this.flush();
        this.writer.close();
    }

    private static OutputStream maybeMd5Wrap(File file, boolean createMd5) {
        if (createMd5) {
            return IOUtil.openFileForMd5CalculatingWriting(file);
        }
        return IOUtil.openFileForWriting(file);
    }
}

