/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.fastutil.objects.AbstractObject2ObjectFunction;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunction;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Intervals;
import it.unimi.dsi.util.PrefixMap;
import java.io.Serializable;

public abstract class AbstractPrefixMap
extends AbstractObject2LongFunction<CharSequence>
implements PrefixMap<MutableString>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Object2ObjectFunction<CharSequence, Interval> rangeMap;
    protected Object2ObjectFunction<Interval, MutableString> prefixMap;
    protected ObjectList<MutableString> list;

    public AbstractPrefixMap() {
        this.defaultReturnValue(-1L);
    }

    protected abstract Interval getInterval(CharSequence var1);

    protected abstract MutableString getTerm(int var1, MutableString var2);

    @Override
    public Object2ObjectFunction<CharSequence, Interval> rangeMap() {
        if (this.rangeMap == null) {
            this.rangeMap = new AbstractObject2ObjectFunction<CharSequence, Interval>(){
                private static final long serialVersionUID = 1L;

                public boolean containsKey(Object o) {
                    return this.get(o) != Intervals.EMPTY_INTERVAL;
                }

                public int size() {
                    return -1;
                }

                public Interval get(Object o) {
                    return AbstractPrefixMap.this.getInterval((CharSequence)o);
                }
            };
        }
        return this.rangeMap;
    }

    @Override
    public Object2ObjectFunction<Interval, MutableString> prefixMap() {
        if (this.prefixMap == null) {
            this.prefixMap = new AbstractObject2ObjectFunction<Interval, MutableString>(){
                private static final long serialVersionUID = 1L;

                public MutableString get(Object o) {
                    int i;
                    Interval interval = (Interval)o;
                    MutableString prefix = new MutableString();
                    if (interval == Intervals.EMPTY_INTERVAL || interval.left < 0 || interval.right < 0) {
                        throw new IllegalArgumentException();
                    }
                    AbstractPrefixMap.this.getTerm(interval.left, prefix);
                    if (interval.length() == 1) {
                        return prefix;
                    }
                    MutableString s = AbstractPrefixMap.this.getTerm(interval.right, new MutableString());
                    int l = Math.min(prefix.length(), s.length());
                    for (i = 0; i < l && s.charAt(i) == prefix.charAt(i); ++i) {
                    }
                    return prefix.length(i);
                }

                public boolean containsKey(Object o) {
                    Interval interval = (Interval)o;
                    return interval != Intervals.EMPTY_INTERVAL && interval.left >= 0 && interval.right < AbstractPrefixMap.this.size();
                }

                public int size() {
                    return -1;
                }
            };
        }
        return this.prefixMap;
    }

    @Override
    public ObjectList<MutableString> list() {
        if (this.list == null) {
            this.list = new AbstractObjectList<MutableString>(){

                public int size() {
                    return AbstractPrefixMap.this.size();
                }

                public MutableString get(int index) {
                    return AbstractPrefixMap.this.getTerm(index, new MutableString());
                }
            };
        }
        return this.list;
    }
}

