/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.motiffinder;

import com.google.common.collect.Iterators;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.tribble.Feature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.session.Persistable;
import org.broad.igv.track.FeatureSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MotifFinderSource
implements FeatureSource<Feature>,
Persistable {
    private static Logger log = LogManager.getLogger(MotifFinderSource.class);
    private String pattern;
    private Genome genome;
    private int featureWindowSize = 10000000;
    private Strand strand;

    public MotifFinderSource() {
        this.genome = GenomeManager.getInstance().getCurrentGenome();
    }

    public MotifFinderSource(String pattern, Strand strand, Genome genome) {
        this.pattern = pattern;
        assert (strand == Strand.POSITIVE || strand == Strand.NEGATIVE);
        this.strand = strand;
        this.genome = genome;
    }

    static Iterator<Feature> searchSingleStrand(String pattern, Strand strand, String chr, int posStart, byte[] sequence) {
        Matcher matcher = MotifFinderSource.getMatcher(pattern, strand, sequence);
        return new MatchFeatureIterator(chr, strand, posStart, sequence.length, matcher);
    }

    static Matcher getMatcher(String pattern, Strand strand, byte[] sequence) {
        byte[] seq = sequence;
        if (strand == Strand.NEGATIVE) {
            SequenceUtil.reverseComplement((byte[])seq);
        }
        Pattern regex = Pattern.compile(pattern, 2);
        String stringSeq = new String(seq);
        return regex.matcher(stringSeq);
    }

    public static Iterator<Feature> search(String pattern, Strand strand, String chr, int posStart, byte[] sequence) {
        switch (strand) {
            case POSITIVE: {
                return MotifFinderSource.searchSingleStrand(pattern, strand, chr, posStart, sequence);
            }
            case NEGATIVE: {
                Iterator<Feature> negIter = MotifFinderSource.searchSingleStrand(pattern, Strand.NEGATIVE, chr, posStart, sequence);
                ArrayList negStrandFeatures = new ArrayList();
                Iterators.addAll(negStrandFeatures, negIter);
                Collections.reverse(negStrandFeatures);
                return negStrandFeatures.iterator();
            }
        }
        throw new IllegalArgumentException("Strand must be either POSITIVE or NEGATIVE");
    }

    @Override
    public Iterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
        byte[] seq = this.genome.getSequence(chr, start, end);
        if (seq == null) {
            Collections.emptyList().iterator();
        }
        return MotifFinderSource.search(this.pattern, this.strand, chr, start, seq);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureWindowSize;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        element.setAttribute("pattern", this.pattern);
        element.setAttribute("strand", this.strand.toString());
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        this.pattern = element.getAttribute("pattern");
        this.strand = Strand.valueOf(element.getAttribute("strand"));
    }

    private static class MatchFeatureIterator
    implements Iterator<Feature> {
        private final int sequenceLength;
        private String chr;
        private int posOffset;
        private Strand strand;
        private int lastMatchStart = -1;
        private Matcher matcher;
        private IGVFeature nextFeat;

        private MatchFeatureIterator(String chr, Strand strand, int posOffset, int sequenceLength, Matcher matcher) {
            this.chr = chr;
            this.strand = strand;
            this.posOffset = posOffset;
            this.matcher = matcher;
            if (this.strand == Strand.NEGATIVE) {
                this.posOffset += sequenceLength;
            }
            this.sequenceLength = sequenceLength;
            this.findNext();
        }

        private void findNext() {
            try {
                if (this.matcher.find(this.lastMatchStart + 1)) {
                    int end;
                    int start;
                    this.lastMatchStart = this.matcher.start();
                    if (this.strand == Strand.POSITIVE) {
                        start = this.posOffset + this.lastMatchStart;
                        end = this.posOffset + this.matcher.end();
                    } else {
                        start = this.posOffset - this.matcher.end();
                        end = this.posOffset - this.lastMatchStart;
                    }
                    this.nextFeat = new BasicFeature(this.chr, start, end, this.strand);
                } else {
                    this.nextFeat = null;
                }
            }
            catch (IndexOutOfBoundsException e) {
                log.error((Object)e);
                this.nextFeat = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextFeat != null;
        }

        @Override
        public IGVFeature next() {
            IGVFeature nF = this.nextFeat;
            this.findNext();
            return nF;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Cannot remove from this iterator");
        }
    }
}

