/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.BaseModification;

public class ModifiedBaseCounts {
    LinkedHashSet<String> allModifications = new LinkedHashSet();
    Map<String, Map<Integer, Integer>> counts = new HashMap<String, Map<Integer, Integer>>();

    public void incrementCounts(Alignment alignment) {
        if (alignment.getAlignmentBlocks() == null) {
            return;
        }
        Map<Integer, BaseModification> baseModifications = alignment.getBaseModificationMap();
        if (baseModifications != null) {
            for (AlignmentBlock block : alignment.getAlignmentBlocks()) {
                for (int i = block.getBases().startOffset; i < block.getBases().startOffset + block.getBases().length; ++i) {
                    if (!baseModifications.containsKey(i)) continue;
                    BaseModification mod = baseModifications.get(i);
                    double threshold = 256.0f * PreferencesManager.getPreferences().getAsFloat("SAM.BASEMOD_THRESHOLD");
                    int l = Byte.toUnsignedInt(mod.likelihood);
                    if ((double)l < threshold) continue;
                    int blockIdx = i - block.getBases().startOffset;
                    int position = block.getStart() + blockIdx;
                    Map<Integer, Integer> modCounts = this.counts.get(mod.modification);
                    if (modCounts == null) {
                        modCounts = new HashMap<Integer, Integer>();
                        this.counts.put(mod.modification, modCounts);
                    }
                    int c = modCounts.containsKey(position) ? modCounts.get(position) + 1 : 1;
                    modCounts.put(position, c);
                    this.allModifications.add(mod.modification);
                }
            }
        }
    }

    public int getCount(int position, String modification) {
        Map<Integer, Integer> modCounts = this.counts.get(modification);
        if (modCounts != null && modCounts.containsKey(position)) {
            return modCounts.get(position);
        }
        return 0;
    }

    public Collection<String> getAllModifications() {
        return this.allModifications;
    }

    public String getValueString(int position) {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, Map<Integer, Integer>> entry : this.counts.entrySet()) {
            String modification = entry.getKey();
            Map<Integer, Integer> modCounts = entry.getValue();
            if (!modCounts.containsKey(position)) continue;
            buffer.append("Modification: " + modification + " (" + modCounts.get(position) + ")<br>");
        }
        return buffer.toString();
    }

    public void dump() {
        for (Map.Entry<String, Map<Integer, Integer>> entry : this.counts.entrySet()) {
            String modification = entry.getKey();
            Map<Integer, Integer> modCounts = entry.getValue();
            System.out.println("Modification: " + modification);
            for (Map.Entry<Integer, Integer> modKey : modCounts.entrySet()) {
                System.out.println(modKey.getKey() + "  " + modKey.getValue());
            }
        }
    }
}

