/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.bbfile.BPTreeChildNodeItem;
import org.broad.igv.bbfile.BPTreeNode;
import org.broad.igv.bbfile.BPTreeNodeItem;

public class BPTreeChildNode
implements BPTreeNode {
    private static Logger log = LogManager.getLogger(BPTreeChildNode.class);
    private final boolean isLeafNode = false;
    private long nodeIndex;
    String lowestChromKey;
    String highestChromKey;
    int lowestChromID;
    int highestChromID;
    private ArrayList<BPTreeChildNodeItem> childItems;

    public BPTreeChildNode(long nodeIndex) {
        this.nodeIndex = nodeIndex;
        this.childItems = new ArrayList();
    }

    @Override
    public long getNodeIndex() {
        return this.nodeIndex;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean insertItem(BPTreeNodeItem item) {
        this.childItems.add((BPTreeChildNodeItem)item);
        BPTreeNode childNode = ((BPTreeChildNodeItem)item).getChildNode();
        if (this.childItems.size() == 1) {
            this.lowestChromKey = childNode.getLowestChromKey();
            this.lowestChromID = childNode.getLowestChromID();
        } else {
            this.highestChromKey = childNode.getHighestChromKey();
            this.highestChromID = childNode.getHighestChromID();
        }
        return true;
    }

    @Override
    public boolean deleteItem(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            return false;
        }
        this.childItems.remove(index);
        return true;
    }

    @Override
    public int getItemCount() {
        return this.childItems.size();
    }

    @Override
    public BPTreeNodeItem getItem(int index) {
        int itemCount = this.getItemCount();
        if (index >= itemCount) {
            return null;
        }
        return this.childItems.get(index);
    }

    @Override
    public String getLowestChromKey() {
        if (this.childItems.size() > 0) {
            return this.lowestChromKey;
        }
        return null;
    }

    @Override
    public String getHighestChromKey() {
        if (this.childItems.size() > 0) {
            return this.highestChromKey;
        }
        return null;
    }

    @Override
    public int getLowestChromID() {
        if (this.childItems.size() > 0) {
            return this.lowestChromID;
        }
        return -1;
    }

    @Override
    public int getHighestChromID() {
        if (this.childItems.size() > 0) {
            return this.highestChromID;
        }
        return -1;
    }

    @Override
    public void printItems() {
        int itemCount = this.getItemCount();
        log.debug("Child node " + this.nodeIndex + " contains " + itemCount + " child items:");
        for (int item = 0; item < itemCount; ++item) {
            this.childItems.get(item).print();
        }
    }

    public ArrayList<BPTreeChildNodeItem> getChildItems() {
        return this.childItems;
    }
}

