/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import com.jidesoft.swing.JideBoxLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.google.OAuthProvider;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.util.UIUtilities;

public class ApplicationStatusBar
extends JPanel
implements IGVEventObserver {
    static Logger log = LogManager.getLogger(ApplicationStatusBar.class);
    public JButton stopButton;
    private JLabel messageBox;
    private JLabel messageBox2;
    private JLabel messageBox3;
    private JLabel memoryStatus;
    Timer timer;

    public ApplicationStatusBar() {
        this.initialize();
    }

    private void initialize() {
        this.setBackground(new Color(240, 240, 240));
        Color messageBG = new Color(230, 230, 230);
        Font messageFont = FontManager.getFont(11);
        this.setMinimumSize(new Dimension(200, 20));
        this.setPreferredSize(new Dimension(800, 20));
        JideBoxLayout layout = new JideBoxLayout((Container)this, 0);
        layout.setGap(3);
        this.setLayout((LayoutManager)layout);
        this.messageBox = this.createMessageField(messageBG, messageFont);
        this.messageBox.setMinimumSize(new Dimension(135, 10));
        this.messageBox.setPreferredSize(new Dimension(135, 20));
        this.add((Component)this.messageBox, "fix");
        this.stopButton = new JButton();
        this.stopButton.setBorder(BorderFactory.createLineBorder(Color.black));
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Stop16.gif")));
        this.stopButton.setMaximumSize(new Dimension(16, 16));
        this.stopButton.setMinimumSize(new Dimension(16, 16));
        this.stopButton.setPreferredSize(new Dimension(16, 16));
        this.stopButton.setSize(new Dimension(16, 16));
        this.stopButton.setToolTipText("Cancel load");
        this.stopButton.setEnabled(false);
        this.add((Component)this.stopButton, "fix");
        this.messageBox2 = this.createMessageField(messageBG, messageFont);
        this.messageBox2.setMinimumSize(new Dimension(150, 10));
        this.messageBox2.setPreferredSize(new Dimension(150, 20));
        this.add((Component)this.messageBox2, "fix");
        this.messageBox3 = this.createMessageField(messageBG, messageFont);
        this.messageBox3.setMinimumSize(new Dimension(165, 10));
        this.messageBox3.setPreferredSize(new Dimension(165, 20));
        this.add((Component)this.messageBox3, "vary");
        this.memoryStatus = this.createMessageField(messageBG, messageFont);
        this.memoryStatus.setPreferredSize(new Dimension(100, 20));
        this.memoryStatus.setMinimumSize(new Dimension(100, 10));
        this.memoryStatus.setBackground(messageBG);
        this.add((Component)this.memoryStatus, "fix");
        MemoryUpdateTask updateTask = new MemoryUpdateTask(this.memoryStatus);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)updateTask, 0L, 1000L);
        IGVEventBus.getInstance().subscribe(OAuthProvider.AuthStateEvent.class, this);
    }

    public void setMessage(String message) {
        UIUtilities.invokeAndWaitOnEventThread(() -> {
            this.messageBox.setText(message);
            this.messageBox.validate();
            this.messageBox.paintImmediately(this.messageBox.getBounds());
        });
    }

    public void setMessage2(String message) {
        UIUtilities.invokeAndWaitOnEventThread(() -> {
            this.messageBox2.setText(message);
            this.messageBox.validate();
            this.messageBox2.paintImmediately(this.messageBox2.getBounds());
        });
    }

    public void setMessage3(String message) {
        UIUtilities.invokeAndWaitOnEventThread(() -> {
            this.messageBox3.setText(message);
            this.messageBox.validate();
            this.messageBox3.paintImmediately(this.messageBox2.getBounds());
        });
    }

    private JLabel createMessageField(Color bg, Font font) {
        JLabel messageField = new JLabel("");
        messageField.setBackground(bg);
        messageField.setFont(font);
        messageField.setBorder(BorderFactory.createLineBorder(Color.black));
        return messageField;
    }

    public void enableStopButton(boolean enable) {
        this.stopButton.setEnabled(enable);
    }

    @Override
    public void receiveEvent(Object event) {
        if (event instanceof OAuthProvider.AuthStateEvent) {
            boolean isAuthed = ((OAuthProvider.AuthStateEvent)event).isAuthenticated();
            String authProvider = ((OAuthProvider.AuthStateEvent)event).getAuthProvider();
            String userName = ((OAuthProvider.AuthStateEvent)event).getUserName();
            String email = ((OAuthProvider.AuthStateEvent)event).getEmail();
            if (isAuthed) {
                this.setMessage3("Logged in as: " + email + " via " + authProvider);
            } else {
                this.setMessage3("");
            }
        }
    }

    class MemoryUpdateTask
    extends TimerTask {
        JLabel textField;
        NumberFormat format;

        public MemoryUpdateTask(JLabel textField) {
            this.textField = textField;
            this.format = NumberFormat.getIntegerInstance();
        }

        @Override
        public void run() {
            Runtime runtime = Runtime.getRuntime();
            int freeMemory = (int)(runtime.freeMemory() / 1000000L);
            int totalMemory = (int)(runtime.totalMemory() / 1000000L);
            int usedMemory = totalMemory - freeMemory;
            String um = this.format.format(usedMemory);
            String tm = this.format.format(totalMemory);
            UIUtilities.invokeOnEventThread(() -> this.textField.setText(um + "M of " + tm + "M"));
        }
    }
}

