/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.goby.GobyAlignmentQueryReader;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.BAMReader;
import org.broad.igv.sam.reader.CGIAlignmentReader;
import org.broad.igv.sam.reader.GeraldReader;
import org.broad.igv.sam.reader.MergedAlignmentReader;
import org.broad.igv.sam.reader.SAMReader;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class AlignmentReaderFactory {
    private static Logger log = LogManager.getLogger(AlignmentReaderFactory.class);

    public static AlignmentReader getReader(String path, boolean requireIndex) throws IOException {
        return AlignmentReaderFactory.getReader(new ResourceLocator(path), requireIndex);
    }

    public static AlignmentReader getReader(ResourceLocator locator) throws IOException {
        return AlignmentReaderFactory.getReader(locator, true);
    }

    public static AlignmentReader getReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        log.debug("Getting alignment reader for " + locator);
        String pathLowerCase = locator.getPath().toLowerCase();
        AlignmentReader reader = null;
        String samFile = locator.getPath();
        String format = locator.getFormat();
        if ("alist".equals(format)) {
            reader = AlignmentReaderFactory.getMergedReader(locator.getPath(), true);
        } else if (pathLowerCase.startsWith("http") && pathLowerCase.contains("/query.cgi?")) {
            reader = new CGIAlignmentReader(samFile);
        } else if (format.equals("sam")) {
            reader = new SAMReader(samFile, requireIndex);
        } else if (format.equals("aligned") || format.equals("aligned.txt") || format.equals("bedz") || format.equals("bed") || format.equals("psl") || format.equals("pslx")) {
            reader = new GeraldReader(samFile, requireIndex);
        } else if (format.equals("bam") || format.equals("cram") || locator.isHtsget()) {
            try {
                reader = new BAMReader(locator, requireIndex);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new DataLoadException("Error loading BAM file: " + e.toString(), locator.getPath());
            }
        } else if (format.equals("bam.list") || pathLowerCase.equals("sam.list")) {
            reader = AlignmentReaderFactory.getBamListReader(locator.getPath(), requireIndex);
        } else if (GobyAlignmentQueryReader.supportsFileType(locator.getPath())) {
            try {
                reader = new GobyAlignmentQueryReader(locator.getPath());
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load Goby alignment " + locator.getPath(), e);
            }
        } else {
            throw new RuntimeException("Cannot determine file format: " + locator.getPath());
        }
        return reader;
    }

    static AlignmentReader getBamListReader(String listFile, boolean requireIndex) {
        AlignmentReader alignmentReader;
        ArrayList<AlignmentReader> readers = new ArrayList<AlignmentReader>();
        BufferedReader reader = null;
        try {
            reader = ParsingUtils.openBufferedReader(listFile);
            HashMap<String, String> replacements = new HashMap<String, String>();
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("#replace")) {
                    String[] kv;
                    String[] tokens = nextLine.split("\\s+");
                    if (tokens.length != 2 || (kv = tokens[1].split("=")).length != 2) continue;
                    replacements.put(kv[0], kv[1]);
                    continue;
                }
                String f = nextLine.trim();
                if (f.length() == 0) continue;
                for (Map.Entry entry : replacements.entrySet()) {
                    f = f.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                f = FileUtils.getAbsolutePath(f, listFile);
                readers.add(AlignmentReaderFactory.getReader(f, requireIndex));
            }
            if (readers.size() == 1) {
                alignmentReader = (AlignmentReader)readers.get(0);
                return alignmentReader;
            }
            alignmentReader = new MergedAlignmentReader(readers);
        }
        catch (IOException e) {
            log.error("Error parsing " + listFile, (Throwable)e);
            throw new RuntimeException("Error parsing: " + listFile + " (" + e.toString() + ")");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return alignmentReader;
    }

    public static AlignmentReader getMergedReader(String alignmentFileList, boolean requireIndex) {
        String aFile = null;
        try {
            String[] alignmentFiles = ParsingUtils.COMMA_PATTERN.split(alignmentFileList);
            ArrayList<AlignmentReader> readers = new ArrayList<AlignmentReader>(alignmentFiles.length);
            String[] stringArray = alignmentFiles;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String f;
                aFile = f = stringArray[i];
                readers.add(AlignmentReaderFactory.getReader(aFile, requireIndex));
            }
            if (readers.size() == 1) {
                return (AlignmentReader)readers.get(0);
            }
            return new MergedAlignmentReader(readers);
        }
        catch (IOException e) {
            log.error("Error instantiating reader for: " + aFile, (Throwable)e);
            throw new RuntimeException("Error instantiating reader for : " + aFile + " (" + e.toString() + ")");
        }
    }

    public static Set<String> getPlatforms(SAMFileHeader header) {
        List readGroups;
        HashSet<String> platforms = null;
        if (header != null && (readGroups = header.getReadGroups()) != null) {
            platforms = new HashSet<String>();
            for (SAMReadGroupRecord rg : readGroups) {
                String platform = rg.getPlatform();
                if (platform == null) continue;
                platforms.add(platform.toUpperCase());
            }
        }
        if (header.getProgramRecord("MAFtoSAM") != null) {
            platforms.add("MOLECULO");
        }
        return platforms;
    }

    static {
        SamReaderFactory.setDefaultValidationStringency((ValidationStringency)ValidationStringency.SILENT);
    }
}

