/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.bbfile.BPTreeChildNode;
import org.broad.igv.bbfile.BPTreeChildNodeItem;
import org.broad.igv.bbfile.BPTreeHeader;
import org.broad.igv.bbfile.BPTreeLeafNode;
import org.broad.igv.bbfile.BPTreeLeafNodeItem;
import org.broad.igv.bbfile.BPTreeNode;
import org.broad.igv.util.LittleEndianInputStream;

public class BPTree {
    private static Logger log = LogManager.getLogger(BPTree.class);
    public static final int BPTREE_NODE_FORMAT_SIZE = 4;
    public static final int BPTREE_NODE_ITEM_SIZE = 8;
    private SeekableStream fis;
    private long treeOffset;
    private BPTreeHeader treeHeader;
    private int blockSize;
    private int keySize;
    private int valueSize;
    private long itemCount;
    private BPTreeNode rootNode;
    private long nodeCount;
    private long leafCount;
    private Map<Integer, String> idChromMap;
    private Map<String, Integer> chromIdMap;
    Map<String, String> chromosomeKeyCache = new HashMap<String, String>();

    public BPTree(SeekableStream fis, long fileOffset, boolean isLowToHigh) {
        this.fis = fis;
        this.treeOffset = fileOffset;
        this.idChromMap = new HashMap<Integer, String>();
        this.chromIdMap = new HashMap<String, Integer>();
        this.treeHeader = new BPTreeHeader(this.fis, this.treeOffset, isLowToHigh);
        if (!this.treeHeader.isHeaderOK()) {
            int badMagic = this.treeHeader.getMagic();
            log.error("Error reading B+ tree header: bad magic = " + badMagic);
            throw new RuntimeException("Error reading B+ tree header: bad magic = " + badMagic);
        }
        this.blockSize = this.treeHeader.getBlockSize();
        this.keySize = this.treeHeader.getKeySize();
        this.valueSize = this.treeHeader.getValSize();
        this.itemCount = this.treeHeader.getItemCount();
        long nodeOffset = this.treeOffset + 32L;
        BPTreeNode parentNode = null;
        this.rootNode = this.readBPTreeNode(this.fis, nodeOffset, parentNode, isLowToHigh);
    }

    public SeekableStream getFis() {
        return this.fis;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public long getItemCount() {
        return this.itemCount;
    }

    public String getChromosomeKey(String chromosome) {
        String key = this.chromosomeKeyCache.get(chromosome);
        if (key == null) {
            key = chromosome.length() <= this.keySize ? chromosome : chromosome.substring(0, this.keySize);
            this.chromosomeKeyCache.put(chromosome, key);
        }
        return key;
    }

    public int getChromosomeID(String chromKey) {
        Integer chromId = this.chromIdMap.get(chromKey);
        return chromId == null ? -1 : chromId;
    }

    public String getChromosomeName(int chromID) {
        return this.idChromMap.get(chromID);
    }

    public ArrayList<String> getChromosomeNames() {
        return new ArrayList<String>(this.chromIdMap.keySet());
    }

    public Map<Integer, String> getChromosomeIDMap(int startChromID, int endChromID) {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        for (int i = startChromID; i <= endChromID; ++i) {
            String c = this.idChromMap.get(i);
            if (c == null) continue;
            m.put(i, c);
        }
        return m;
    }

    public void print() {
        if (!this.treeHeader.isHeaderOK()) {
            int badMagic = this.treeHeader.getMagic();
            log.error("Error reading B+ tree header: bad magic = " + badMagic);
            return;
        }
        this.treeHeader.print();
        if (this.rootNode != null) {
            this.rootNode.printItems();
        }
    }

    private BPTreeNode readBPTreeNode(SeekableStream fis, long fileOffset, BPTreeNode parent, boolean isLowToHigh) {
        LittleEndianInputStream lbdis = null;
        DataInputStream bdis = null;
        byte[] buffer = new byte[4];
        BPTreeNode thisNode = null;
        BPTreeNode childNode = null;
        try {
            int itemCount;
            byte bval;
            boolean isLeaf;
            fis.seek(fileOffset);
            fis.readFully(buffer);
            if (isLowToHigh) {
                lbdis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(buffer));
            }
            byte type = isLowToHigh ? lbdis.readByte() : bdis.readByte();
            if (type == 1) {
                isLeaf = true;
                thisNode = new BPTreeLeafNode(++this.nodeCount);
            } else {
                isLeaf = false;
                thisNode = new BPTreeChildNode(++this.nodeCount);
            }
            if (isLowToHigh) {
                bval = lbdis.readByte();
                itemCount = lbdis.readUShort();
            } else {
                bval = bdis.readByte();
                itemCount = bdis.readUnsignedShort();
            }
            int itemSize = 8 + this.keySize;
            int totalSize = itemSize * itemCount;
            byte[] itemBuffer = new byte[totalSize];
            fis.readFully(itemBuffer);
            if (isLowToHigh) {
                lbdis = new LittleEndianInputStream(new ByteArrayInputStream(itemBuffer));
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(itemBuffer));
            }
            for (int item = 0; item < itemCount; ++item) {
                char[] keychars = new char[this.keySize];
                for (int index = 0; index < this.keySize; ++index) {
                    bval = isLowToHigh ? lbdis.readByte() : bdis.readByte();
                    keychars[index] = (char)bval;
                }
                String key = new String(keychars).trim();
                if (isLeaf) {
                    int chromSize;
                    int chromID;
                    if (isLowToHigh) {
                        chromID = lbdis.readInt();
                        chromSize = lbdis.readInt();
                    } else {
                        chromID = bdis.readInt();
                        chromSize = bdis.readInt();
                    }
                    this.idChromMap.put(chromID, key);
                    this.chromIdMap.put(key, chromID);
                    BPTreeLeafNodeItem leafItem = new BPTreeLeafNodeItem(++this.leafCount, key, chromID, chromSize);
                    thisNode.insertItem(leafItem);
                } else {
                    long childOffset = isLowToHigh ? lbdis.readLong() : bdis.readLong();
                    childNode = this.readBPTreeNode(this.fis, childOffset, thisNode, isLowToHigh);
                    BPTreeChildNodeItem childItem = new BPTreeChildNodeItem(item, key, childNode);
                    thisNode.insertItem(childItem);
                }
                fileOffset += (long)itemSize;
            }
        }
        catch (IOException ex) {
            log.error("Error reading B+ tree node " + ex);
            throw new RuntimeException("Error reading B+ tree node \n ", ex);
        }
        return thisNode;
    }
}

