/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.tribble.Feature;
import java.awt.Color;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureType;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.collections.MultiMap;

public class IGVBEDCodec
extends UCSCCodec<BasicFeature> {
    private static final Logger log = LogManager.getLogger(IGVBEDCodec.class);
    static final Pattern BR_PATTERN = Pattern.compile("<br>");
    static final Pattern EQ_PATTERN = Pattern.compile("=");
    private Genome genome;
    private Pattern delimiter = null;
    private String[] tokens = new String[50];

    public IGVBEDCodec() {
        this((Genome)null);
    }

    public IGVBEDCodec(Genome genome) {
        this(genome, FeatureType.BED);
    }

    public IGVBEDCodec(Genome genome, FeatureType featureType) {
        super(BasicFeature.class, featureType);
        this.genome = genome;
    }

    public BasicFeature decode(String[] tokens) {
        String colorString;
        BasicFeature feature;
        int tokenCount = tokens.length;
        if (tokenCount < 2) {
            return null;
        }
        String c = tokens[0];
        String chr = this.genome == null ? c : this.genome.getCanonicalChrName(c);
        int start = Integer.parseInt(tokens[1]);
        int end = start + 1;
        if (tokenCount > 2) {
            end = Integer.parseInt(tokens[2]);
        }
        BasicFeature basicFeature = feature = this.featureType == FeatureType.SPLICE_JUNCTION ? new SpliceJunctionFeature(chr, start, end) : new BasicFeature(chr, start, end);
        if (tokenCount > 3) {
            if (this.isGffTags()) {
                String geneSymbols;
                MultiMap<String, String> atts = new MultiMap<String, String>();
                this.tagHelper.parseAttributes(tokens[3], atts);
                String name = this.tagHelper.getName(atts);
                feature.setName(name);
                String id = atts.get("ID");
                if (id != null) {
                    FeatureDB.addFeature(id, feature, this.genome);
                    feature.setIdentifier(id);
                } else {
                    feature.setIdentifier(name);
                }
                String alias = atts.get("Alias");
                if (alias != null) {
                    FeatureDB.addFeature(alias, feature, this.genome);
                }
                if ((geneSymbols = atts.get("Symbol")) != null) {
                    String[] symbols;
                    for (String sym : symbols = geneSymbols.split(",")) {
                        FeatureDB.addFeature(sym.trim(), feature, this.genome);
                    }
                }
                feature.setAttributes(atts);
            } else {
                String name = tokens[3].replaceAll("\"", "");
                if (name.equals(".")) {
                    name = "";
                }
                feature.setName(name);
                feature.setIdentifier(name);
            }
        }
        if (tokenCount > 4) {
            try {
                float score = tokens[4].equals(".") ? 1000.0f : Float.parseFloat(tokens[4]);
                feature.setScore(score);
                if (this.featureType == FeatureType.SPLICE_JUNCTION) {
                    ((SpliceJunctionFeature)feature).setJunctionDepth((int)score);
                }
            }
            catch (NumberFormatException numberFormatException) {
                feature.setScore(1000.0f);
            }
        }
        if (tokenCount > 5) {
            int strand;
            String strandString = tokens[5].trim();
            int n = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        if (tokenCount > 7) {
            try {
                int thickStart = Integer.parseInt(tokens[6]);
                int thickEnd = Integer.parseInt(tokens[7]);
                feature.setThickStart(Math.max(start, thickStart));
                feature.setThickEnd(Math.min(end, thickEnd));
            }
            catch (NumberFormatException e) {
                return feature;
            }
        }
        if (tokenCount > 8 && this.featureType != FeatureType.GAPPED_PEAK && (colorString = tokens[8]).trim().length() > 0 && !colorString.equals(".")) {
            feature.setColor(ColorUtilities.stringToColor(colorString));
        }
        if (tokenCount > 11) {
            this.createExons(start, tokens, feature, chr, feature.getStrand());
            if (this.featureType == FeatureType.SPLICE_JUNCTION) {
                SpliceJunctionFeature junctionFeature = (SpliceJunctionFeature)feature;
                List<Exon> exons = feature.getExons();
                junctionFeature.setJunctionStart(start + exons.get(0).getLength());
                junctionFeature.setJunctionEnd(end - exons.get(1).getLength());
            }
        }
        if (tokenCount > 14 && this.featureType == FeatureType.GAPPED_PEAK) {
            MultiMap<String, String> attributes = new MultiMap<String, String>();
            attributes.put("Signal Value", tokens[12]);
            attributes.put("pValue (-log10)", tokens[13]);
            attributes.put("qValue (-log10)", tokens[14]);
            feature.setAttributes(attributes);
        } else if (tokenCount > 13 && this.featureType == FeatureType.SPLICE_JUNCTION) {
            try {
                String[] startFlanking = tokens[12].split(",");
                int[] startFlankingDeptyArray = new int[startFlanking.length];
                for (int i = 0; i < startFlanking.length; ++i) {
                    startFlankingDeptyArray[i] = Integer.parseInt(startFlanking[i]);
                }
                String[] endFlanking = tokens[13].split(",");
                int[] endFlankingDeptyArray = new int[endFlanking.length];
                for (int i = 0; i < endFlanking.length; ++i) {
                    endFlankingDeptyArray[i] = Integer.parseInt(endFlanking[i]);
                }
                ((SpliceJunctionFeature)feature).setStartFlankingRegionDepthArray(startFlankingDeptyArray);
                ((SpliceJunctionFeature)feature).setEndFlankingRegionDepthArray(endFlankingDeptyArray);
            }
            catch (NumberFormatException e) {
                log.error("Error parsing flanking array", (Throwable)e);
            }
        }
        if (this.isCoding(feature)) {
            FeatureUtils.computeReadingFrames(feature);
        }
        return feature;
    }

    private boolean isCoding(BasicFeature feature) {
        return feature.hasExons() && feature.getThickStart() > feature.getStart() && feature.getThickEnd() < feature.getEnd() && feature.getStrand() != Strand.NONE;
    }

    public BasicFeature decode(String nextLine) {
        String trimLine = nextLine.trim();
        if (trimLine.length() == 0) {
            return null;
        }
        if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
            return null;
        }
        if (this.delimiter == null) {
            this.delimiter = trimLine.contains("\t") ? Globals.multiTabPattern : Globals.whitespacePattern;
        }
        this.tokens = this.delimiter.split(trimLine);
        BasicFeature feature = this.decode(this.tokens);
        feature.setRepresentation(nextLine);
        return feature;
    }

    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".bed") || path.toLowerCase().endsWith(".bed.gz");
    }

    private void createExons(int start, String[] tokens, BasicFeature gene, String chr, Strand strand) throws NumberFormatException {
        int exonNumber;
        int cdStart = Integer.parseInt(tokens[6]);
        int cdEnd = Integer.parseInt(tokens[7]);
        int exonCount = Integer.parseInt(tokens[9]);
        String[] exonSizes = Globals.commaPattern.split(tokens[10]);
        String[] startsBuffer = Globals.commaPattern.split(tokens[11]);
        int n = exonNumber = strand == Strand.NEGATIVE ? exonCount : 1;
        if (startsBuffer.length == exonSizes.length) {
            for (int i = 0; i < startsBuffer.length; ++i) {
                int exonStart = start + Integer.parseInt(startsBuffer[i]);
                int exonEnd = exonStart + Integer.parseInt(exonSizes[i]);
                Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                exon.setCodingStart(cdStart);
                exon.setCodingEnd(cdEnd);
                gene.addExon(exon);
                exon.setNumber(exonNumber);
                if (strand == Strand.NEGATIVE) {
                    --exonNumber;
                    continue;
                }
                ++exonNumber;
            }
        }
    }

    public String encode(Feature feature) {
        boolean more;
        boolean hasName;
        String rep;
        if (feature instanceof BasicFeature && (rep = ((BasicFeature)feature).getRepresentation()) != null) {
            return rep;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(feature.getChr());
        buffer.append("\t");
        int featureStart = feature.getStart();
        buffer.append(String.valueOf(featureStart));
        buffer.append("\t");
        buffer.append(String.valueOf(feature.getEnd()));
        BasicFeature basicFeature = null;
        if (!(feature instanceof BasicFeature)) {
            return buffer.toString();
        }
        basicFeature = (BasicFeature)feature;
        boolean bl = hasName = basicFeature.getName() != null && basicFeature.getName().length() > 0 || this.isGffTags() && basicFeature.getDescription() != null && basicFeature.getDescription().length() > 0;
        if (hasName) {
            buffer.append("\t");
            if (this.isGffTags() && basicFeature.getDescription() != null) {
                String[] attrs = BR_PATTERN.split(basicFeature.getDescription());
                buffer.append("\"");
                for (String att : attrs) {
                    String[] kv = EQ_PATTERN.split(att, 2);
                    if (kv.length <= 1) continue;
                    buffer.append(kv[0].trim());
                    buffer.append("=");
                    String value = kv[1].trim();
                    buffer.append(StringUtils.encodeURL(value));
                    buffer.append(";");
                }
                buffer.append("\"");
            } else {
                buffer.append(basicFeature.getName());
            }
        }
        boolean bl2 = more = !Float.isNaN(basicFeature.getScore()) || basicFeature.getStrand() != Strand.NONE || basicFeature.getColor() != null || basicFeature.getExonCount() > 0;
        if (more) {
            if (!hasName) {
                buffer.append("\t.");
            }
            buffer.append("\t");
            float score = basicFeature.getScore();
            if (Float.isNaN(score)) {
                buffer.append("1000");
            } else {
                boolean isInt = Math.floor(score) == (double)score;
                buffer.append(String.valueOf(isInt ? (float)((int)score) : score));
            }
            boolean bl3 = more = basicFeature.getStrand() != Strand.NONE || basicFeature.getColor() != null || basicFeature.getThickStart() != basicFeature.getStart() || basicFeature.getExonCount() > 0;
            if (more) {
                buffer.append("\t");
                Strand strand = basicFeature.getStrand();
                if (strand == Strand.NONE) {
                    buffer.append(" ");
                } else if (strand == Strand.POSITIVE) {
                    buffer.append("+");
                } else if (strand == Strand.NEGATIVE) {
                    buffer.append("-");
                }
                boolean bl4 = more = basicFeature.getColor() != null || basicFeature.getExonCount() > 0;
                if (more) {
                    List<Exon> exons = basicFeature.getExons();
                    if (basicFeature.getColor() != null || exons != null) {
                        int thickEnd;
                        int thickStart;
                        if (exons != null && exons.size() > 0) {
                            thickStart = basicFeature.getEnd();
                            for (Exon exon : exons) {
                                if (exon.isNonCoding()) continue;
                                thickStart = exon.getCdStart();
                                break;
                            }
                            thickEnd = basicFeature.getStart();
                            for (int i = exons.size() - 1; i >= 0; --i) {
                                Exon exon = exons.get(i);
                                if (exon.isNonCoding()) continue;
                                thickEnd = exon.getCdEnd();
                                break;
                            }
                        } else {
                            thickStart = ((BasicFeature)feature).getThickStart();
                            thickEnd = ((BasicFeature)feature).getThickEnd();
                        }
                        buffer.append("\t");
                        buffer.append(String.valueOf(thickStart));
                        buffer.append("\t");
                        buffer.append(String.valueOf(thickEnd));
                        buffer.append("\t");
                        Color c = basicFeature.getColor();
                        buffer.append(c == null ? "." : ColorUtilities.colorToString(c));
                        buffer.append("\t");
                        if (exons != null && exons.size() > 0) {
                            buffer.append(String.valueOf(exons.size()));
                            buffer.append("\t");
                            for (Exon exon : exons) {
                                buffer.append(String.valueOf(exon.getLength()));
                                buffer.append(",");
                            }
                            buffer.append("\t");
                            for (Exon exon : exons) {
                                int exonStart = exon.getStart() - featureStart;
                                buffer.append(String.valueOf(exonStart));
                                buffer.append(",");
                            }
                        }
                    }
                    if (basicFeature instanceof SpliceJunctionFeature) {
                        SpliceJunctionFeature spliceJunctionFeature = (SpliceJunctionFeature)basicFeature;
                        int[] nArray = spliceJunctionFeature.getStartFlankingRegionDepthArray();
                        int[] endFlanking = spliceJunctionFeature.getEndFlankingRegionDepthArray();
                        if (nArray != null && nArray.length > 0 && endFlanking != null && endFlanking.length > 0) {
                            int i;
                            buffer.append("\t" + nArray[0]);
                            for (i = 1; i < nArray.length; ++i) {
                                buffer.append("," + nArray[i]);
                            }
                            buffer.append("\t" + endFlanking[0]);
                            for (i = 1; i < endFlanking.length; ++i) {
                                buffer.append("," + endFlanking[i]);
                            }
                        }
                    }
                }
            }
        }
        return buffer.toString();
    }
}

