/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.event.GenomeChangeEvent;
import org.broad.igv.event.GenomeResetEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeImporter;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.load.GenomeDescriptor;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.feature.genome.load.JsonGenomeLoader;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.ui.util.download.Downloader;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;

public class GenomeManager {
    private static Logger log = Logger.getLogger(GenomeManager.class);
    private static GenomeManager theInstance;
    private static GenomeListManager genomeListManager;
    private Genome currentGenome;

    public static synchronized GenomeManager getInstance() {
        if (theInstance == null) {
            theInstance = new GenomeManager();
        }
        return theInstance;
    }

    private GenomeManager() {
        genomeListManager = GenomeListManager.getInstance();
        GenomeLoader.localSequenceMap = GenomeLoader.loadSequenceMap();
    }

    public static File getGenomeFile(String genomePath) throws MalformedURLException, UnsupportedEncodingException {
        File archiveFile;
        if (HttpUtils.isRemoteURL(genomePath.toLowerCase())) {
            URL genomeArchiveURL = HttpUtils.createURL(genomePath);
            String tmp = URLDecoder.decode(genomeArchiveURL.getFile(), "UTF-8");
            String cachedFilename = Utilities.getFileNameFromURL(tmp);
            if (!DirectoryManager.getGenomeCacheDirectory().exists()) {
                DirectoryManager.getGenomeCacheDirectory().mkdir();
            }
            archiveFile = new File(DirectoryManager.getGenomeCacheDirectory(), cachedFilename);
            Frame parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
            Downloader.download(genomeArchiveURL, archiveFile, parent);
        } else {
            archiveFile = new File(genomePath);
        }
        return archiveFile;
    }

    public void setCurrentGenome(Genome genome) {
        if (genome != null) {
            PreferencesManager.getPreferences().setLastGenome(genome.getId());
        }
        this.currentGenome = genome;
        if (genome != null && IGV.hasInstance()) {
            IGV.getInstance().getSession().clearHistory();
            FrameManager.getDefaultFrame().setChromosomeName(genome.getHomeChromosome(), true);
            IGVEventBus.getInstance().post(new GenomeChangeEvent(genome));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGenomeById(String genomeId) throws IOException {
        Genome currentGenome = this.getCurrentGenome();
        if (currentGenome != null && genomeId.equals(currentGenome.getId())) {
            return;
        }
        if (ParsingUtils.fileExists(genomeId)) {
            this.loadGenome(genomeId, null);
        } else {
            ProgressMonitor[] monitor = new ProgressMonitor[]{new ProgressMonitor()};
            ProgressBar.ProgressDialog[] progressDialog = new ProgressBar.ProgressDialog[1];
            UIUtilities.invokeAndWaitOnEventThread(() -> {
                progressDialog[0] = ProgressBar.showProgressDialog(IGV.getMainFrame(), "Loading Genome...", monitor[0], false);
            });
            try {
                GenomeListItem item = genomeListManager.getGenomeListItem(genomeId);
                if (item == null) {
                    MessageUtils.showMessage("Could not locate genome with ID: " + genomeId);
                } else {
                    this.loadGenome(item.getPath(), monitor[0]);
                }
            }
            finally {
                UIUtilities.invokeOnEventThread(() -> progressDialog[0].setVisible(false));
            }
        }
    }

    public Genome loadGenome(String genomePath, ProgressMonitor monitor) throws IOException {
        try {
            log.info((Object)("Loading genome: " + genomePath));
            if (monitor != null) {
                UIUtilities.invokeAndWaitOnEventThread(() -> monitor.fireProgress(25));
            }
            FeatureDB.clearFeatures();
            Genome newGenome = GenomeLoader.getLoader(genomePath).loadGenome();
            this.setCurrentGenome(newGenome);
            try {
                String aliasPath = new File(DirectoryManager.getGenomeCacheDirectory(), newGenome.getId() + "_alias.tab").getAbsolutePath();
                if (new File(aliasPath).exists()) {
                    newGenome.addChrAliases(GenomeLoader.loadChrAliases(aliasPath));
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to load user defined alias", (Throwable)e);
            }
            if (monitor != null) {
                monitor.fireProgress(25);
            }
            if (IGV.hasInstance()) {
                IGV.getInstance().resetSession(null);
            }
            GenomeListItem genomeListItem = new GenomeListItem(newGenome.getDisplayName(), genomePath, newGenome.getId());
            Set<String> serverGenomeIDs = genomeListManager.getServerGenomeIDs();
            boolean userDefined = !serverGenomeIDs.contains(newGenome.getId());
            genomeListManager.addGenomeItem(genomeListItem, userDefined);
            this.setCurrentGenome(newGenome);
            if (IGV.hasInstance()) {
                this.loadGenomeAnnotations(newGenome);
            }
            return this.currentGenome;
        }
        catch (SocketException e) {
            throw new RuntimeException("Server connection error", e);
        }
    }

    public void loadGenomeAnnotations(Genome newGenome) {
        ArrayList<ResourceLocator> resources;
        FeatureTrack geneFeatureTrack = newGenome.getGeneTrack();
        if (IGV.hasInstance()) {
            IGV.getInstance().setGenomeTracks(geneFeatureTrack);
        }
        if ((resources = newGenome.getAnnotationResources()) != null && IGV.hasInstance()) {
            IGV.getInstance().loadResources(resources);
            IGV.getInstance().repaint();
        }
    }

    public void clearGenomeCache() {
        File[] files;
        for (File file : files = DirectoryManager.getGenomeCacheDirectory().listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".genome")) continue;
            file.delete();
        }
    }

    public GenomeListItem defineGenome(File genomeFile, String cytobandFileName, String refFlatFileName, String fastaFileName, String chrAliasFileName, String genomeDisplayName, String genomeId, javax.swing.ProgressMonitor monitor) throws IOException {
        File refFlatFile = null;
        File cytobandFile = null;
        File chrAliasFile = null;
        if (genomeFile != null) {
            PreferencesManager.getPreferences().setLastGenomeImportDirectory(genomeFile.getParentFile());
        }
        if (cytobandFileName != null && cytobandFileName.trim().length() != 0) {
            cytobandFile = new File(cytobandFileName);
        }
        if (refFlatFileName != null && refFlatFileName.trim().length() != 0) {
            refFlatFile = new File(refFlatFileName);
        }
        if (chrAliasFileName != null && chrAliasFileName.trim().length() != 0) {
            chrAliasFile = new File(chrAliasFileName);
        }
        if (monitor != null) {
            monitor.setProgress(25);
        }
        new GenomeImporter().createGenomeArchive(genomeFile, genomeId, genomeDisplayName, fastaFileName, refFlatFile, cytobandFile, chrAliasFile);
        if (monitor != null) {
            monitor.setProgress(75);
        }
        GenomeListItem newItem = new GenomeListItem(genomeDisplayName, genomeFile.getAbsolutePath(), genomeId);
        genomeListManager.addGenomeItem(newItem, true);
        if (monitor != null) {
            monitor.setProgress(100);
        }
        return newItem;
    }

    private String convertToS3(String path) {
        if (path.startsWith("http://igvdata") || path.startsWith("https://igvdata")) {
            return path.replaceFirst("igvdata", "igv");
        }
        return path;
    }

    public String getGenomeId() {
        return this.currentGenome == null ? null : this.currentGenome.getId();
    }

    public Genome getCurrentGenome() {
        return this.currentGenome;
    }

    public void generateGenomeList(File inDir, String rootPath, String outPath) {
        PrintWriter writer;
        File[] genomeFiles = inDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name == null) {
                    return false;
                }
                return name.toLowerCase().endsWith(".genome");
            }
        });
        try {
            writer = new PrintWriter(outPath);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error opening " + outPath));
            e.printStackTrace();
            return;
        }
        for (File f : genomeFiles) {
            Object curLine = "";
            try {
                GenomeDescriptor descriptor = GenomeDescriptor.parseGenomeArchiveFile(f);
                curLine = (String)curLine + descriptor.getName();
                curLine = (String)curLine + "\t" + rootPath + "/" + f.getName();
                curLine = (String)curLine + "\t" + descriptor.getId();
            }
            catch (IOException e) {
                log.error((Object)("Error parsing genome file. Skipping " + f.getAbsolutePath()));
                log.error((Object)e);
                continue;
            }
            writer.println((String)curLine);
        }
        writer.close();
    }

    public boolean downloadGenome(GenomeListItem item, boolean downloadSequence) {
        boolean success;
        try {
            File genomeFile = GenomeManager.getGenomeFile(item.getPath());
            if (downloadSequence) {
                File localFile;
                String fastaPath = null;
                if (item.getPath().endsWith(".genome")) {
                    GenomeDescriptor genomeDescriptor = GenomeDescriptor.parseGenomeArchiveFile(genomeFile);
                    fastaPath = genomeDescriptor.getSequencePath();
                } else if (item.getPath().endsWith(".json")) {
                    JsonGenomeLoader.GenomeDescriptor desc = new JsonGenomeLoader(item.getPath()).loadDescriptor();
                    fastaPath = desc.getFastaURL();
                }
                if (fastaPath != null && FileUtils.isRemote(fastaPath) && (localFile = this.downloadFasta(fastaPath)) != null) {
                    GenomeManager.addLocalFasta(item.getId(), localFile);
                }
            }
            success = true;
        }
        catch (Exception e) {
            success = false;
            MessageUtils.showErrorMessage("Error downloading genome", e);
            log.error((Object)("Error downloading genome " + item.getDisplayableName()));
        }
        if (success) {
            genomeListManager.addGenomeItem(item, false);
            IGVEventBus.getInstance().post(new GenomeResetEvent());
        }
        return success;
    }

    File downloadFasta(String fastaPath) throws IOException {
        File defaultDir = DirectoryManager.getFastaCacheDirectory();
        File targetDir = defaultDir;
        if (targetDir == null) {
            targetDir = defaultDir;
        }
        String filename = Utilities.getFileNameFromURL(fastaPath);
        File localFile = new File(targetDir, filename);
        boolean downloaded = Downloader.download(HttpUtils.createURL(fastaPath), localFile, IGV.getMainFrame());
        if (downloaded) {
            URL indexUrl = HttpUtils.createURL(fastaPath + ".fai");
            File localIndexFile = new File(targetDir, filename + ".fai");
            downloaded = Downloader.download(indexUrl, localIndexFile, IGV.getMainFrame());
        }
        if (downloaded && fastaPath.endsWith(".gz")) {
            URL gziUrl = HttpUtils.createURL(fastaPath + ".gzi");
            File localGziPath = new File(targetDir, filename + ".gzi");
            downloaded = Downloader.download(gziUrl, localGziPath, IGV.getMainFrame());
        }
        return downloaded ? localFile : null;
    }

    public static File getLocalFasta(String id) {
        return GenomeLoader.localSequenceMap.get(id);
    }

    public static void removeLocalFasta(String id) {
        GenomeLoader.localSequenceMap.remove(id);
        GenomeManager.updateSequenceMapFile();
    }

    private static void addLocalFasta(String id, File localFile) {
        GenomeLoader.localSequenceMap.put(id, localFile);
        GenomeManager.updateSequenceMapFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSequenceMapFile() {
        try (PrintWriter pw = null;){
            File sequenceFile = new File(DirectoryManager.getGenomeCacheDirectory(), "sequenceMap.txt");
            pw = new PrintWriter(new BufferedWriter(new FileWriter(sequenceFile)));
            for (Map.Entry<String, File> entry : GenomeLoader.localSequenceMap.entrySet()) {
                pw.println(entry.getKey() + "\t" + entry.getValue());
            }
        }
    }
}

