/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.util.ConfirmDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;

public class GenomeListManager {
    private static Logger log = Logger.getLogger(GenomeManager.class);
    private static GenomeListManager theInstance;
    private static final String ACT_USER_DEFINED_GENOME_LIST_FILE = "user-defined-genomes.txt";
    public static final GenomeListItem DEFAULT_GENOME;
    private Map<String, GenomeListItem> genomeItemMap = new HashMap<String, GenomeListItem>();
    private Map<String, GenomeListItem> userDefinedGenomeMap;
    private Map<String, GenomeListItem> serverGenomeMap;
    private boolean serverGenomeListUnreachable = false;
    private static GenomeListSorter sorter;
    public static final String TEST_USER_DEFINED_GENOME_LIST_FILE;

    public static synchronized GenomeListManager getInstance() {
        if (theInstance == null) {
            theInstance = new GenomeListManager();
        }
        return theInstance;
    }

    private GenomeListManager() {
    }

    public Map<String, GenomeListItem> getGenomeItemMap() throws IOException {
        if (this.genomeItemMap.isEmpty()) {
            this.rebuildGenomeItemMap();
        }
        return this.genomeItemMap;
    }

    public void rebuildGenomeItemMap() throws IOException {
        this.serverGenomeMap = null;
        this.userDefinedGenomeMap = null;
        this.genomeItemMap.clear();
        this.genomeItemMap.putAll(this.getUserDefinedGenomeMap());
        this.genomeItemMap.putAll(GenomeListManager.getCachedGenomeList());
        if (this.genomeItemMap.isEmpty()) {
            this.genomeItemMap.put(DEFAULT_GENOME.getId(), DEFAULT_GENOME);
        }
    }

    public List<GenomeListItem> getGenomeListItems() {
        ArrayList<GenomeListItem> items = new ArrayList<GenomeListItem>(this.genomeItemMap.values());
        items.sort(sorter);
        return items;
    }

    public void addGenomeItem(GenomeListItem genomeListItem, boolean userDefined) {
        this.genomeItemMap.put(genomeListItem.getId(), genomeListItem);
        if (userDefined) {
            if (this.userDefinedGenomeMap == null) {
                this.userDefinedGenomeMap = new HashMap<String, GenomeListItem>();
            }
            this.userDefinedGenomeMap.put(genomeListItem.getId(), genomeListItem);
            this.exportUserDefinedGenomeList();
        }
    }

    public void addServerGenomeItem(GenomeListItem genomeListItem) {
        this.addGenomeItem(genomeListItem, false);
    }

    public GenomeListItem getLoadedGenomeListItemById(String genomeId) {
        return this.genomeItemMap.get(genomeId);
    }

    public GenomeListItem getGenomeListItem(String genomeId) {
        GenomeListItem matchingItem = this.genomeItemMap.get(genomeId);
        if (matchingItem == null) {
            matchingItem = this.getServerGenomeMap().get(genomeId);
            if (matchingItem != null) {
                return matchingItem;
            }
            try {
                this.rebuildGenomeItemMap();
            }
            catch (IOException e) {
                log.error((Object)"Error rebuilding genome item map", (Throwable)e);
            }
            matchingItem = this.genomeItemMap.get(genomeId);
        }
        return matchingItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, GenomeListItem> getCachedGenomeList() {
        File[] files;
        HashMap<String, GenomeListItem> cachedGenomes = new HashMap<String, GenomeListItem>();
        if (!DirectoryManager.getGenomeCacheDirectory().exists()) {
            return cachedGenomes;
        }
        for (File file : files = DirectoryManager.getGenomeCacheDirectory().listFiles()) {
            if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".genome")) continue;
            ZipFile zipFile = null;
            FileInputStream fis = null;
            ZipInputStream zipInputStream = null;
            try {
                zipFile = new ZipFile(file);
                fis = new FileInputStream(file);
                zipInputStream = new ZipInputStream(new BufferedInputStream(fis));
                ZipEntry zipEntry = zipFile.getEntry("property.txt");
                if (zipEntry == null) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Properties properties = new Properties();
                properties.load(inputStream);
                GenomeListItem item = new GenomeListItem(properties.getProperty("name"), file.getAbsolutePath(), properties.getProperty("id"));
                cachedGenomes.put(item.getId(), item);
            }
            catch (ZipException ex) {
                log.error((Object)"\nZip error unzipping cached genome.", (Throwable)ex);
                try {
                    file.delete();
                    zipInputStream.close();
                }
                catch (Exception inputStream) {
                    // empty catch block
                }
            }
            catch (IOException ex) {
                log.warn((Object)"\nIO error unzipping cached genome.", (Throwable)ex);
                try {
                    file.delete();
                }
                catch (Exception inputStream) {
                    // empty catch block
                }
            }
            finally {
                try {
                    if (zipInputStream != null) {
                        zipInputStream.close();
                    }
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    log.warn((Object)"Error closing genome zip stream", (Throwable)ex);
                }
            }
        }
        for (File file : files) {
            if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".json")) continue;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                JsonParser parser = new JsonParser();
                JsonElement rootElement = parser.parse((Reader)reader);
                if (!rootElement.isJsonObject()) continue;
                JsonObject json = rootElement.getAsJsonObject();
                JsonElement id = json.get("id");
                JsonElement name = json.get("name");
                JsonElement fastaURL = json.get("fastaURL");
                if (id == null || name == null || fastaURL == null) continue;
                if (cachedGenomes.containsKey(id.getAsString())) {
                    File prevFile = new File(((GenomeListItem)cachedGenomes.get(id.getAsString())).getPath());
                    prevFile.delete();
                }
                GenomeListItem item = new GenomeListItem(name.getAsString(), file.getAbsolutePath(), id.getAsString());
                cachedGenomes.put(item.getId(), item);
            }
            catch (Exception e) {
                log.error((Object)("Error parsing genome json: " + file.getAbsolutePath()), (Throwable)e);
            }
        }
        return cachedGenomes;
    }

    public Set<String> getServerGenomeIDs() {
        return this.getServerGenomeMap().keySet();
    }

    public Collection<String> getSelectableGenomeIDs() {
        return this.genomeItemMap.keySet();
    }

    public void removeAllItems(List<GenomeListItem> removedValuesList) {
        boolean updateImportFile = false;
        for (GenomeListItem genomeListItem : removedValuesList) {
            String id = genomeListItem.getId();
            this.genomeItemMap.remove(id);
            if (this.userDefinedGenomeMap == null || !this.userDefinedGenomeMap.containsKey(id)) continue;
            this.userDefinedGenomeMap.remove(id);
            updateImportFile = true;
        }
        if (updateImportFile) {
            this.exportUserDefinedGenomeList();
        }
    }

    public void removeGenomeListItem(GenomeListItem genomeListItem) {
        String id = genomeListItem.getId();
        this.genomeItemMap.remove(id);
        this.removeUserDefinedGenome(id);
    }

    public void removeUserDefinedGenome(String id) {
        if (this.userDefinedGenomeMap != null && this.userDefinedGenomeMap.containsKey(id)) {
            this.userDefinedGenomeMap.remove(id);
            this.exportUserDefinedGenomeList();
        }
    }

    public List<GenomeListItem> getServerGenomeList() {
        ArrayList<GenomeListItem> items = new ArrayList<GenomeListItem>(this.getServerGenomeMap().values());
        items.sort(sorter);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GenomeListItem> getServerGenomeMap() {
        if (this.serverGenomeListUnreachable) {
            return Collections.emptyMap();
        }
        if (this.serverGenomeMap == null) {
            this.serverGenomeMap = new HashMap<String, GenomeListItem>();
            BufferedReader dataReader = null;
            InputStream inputStream = null;
            String genomeListURLString = "";
            try {
                String genomeRecord;
                genomeListURLString = PreferencesManager.getPreferences().getGenomeListURL();
                if (HttpUtils.isRemoteURL(genomeListURLString)) {
                    URL serverGenomeURL = HttpUtils.createURL(genomeListURLString);
                    inputStream = HttpUtils.getInstance().openConnectionStream(serverGenomeURL);
                } else {
                    File file = new File(genomeListURLString.startsWith("file:") ? new URL(genomeListURLString).getFile() : genomeListURLString);
                    inputStream = new FileInputStream(file);
                }
                dataReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((genomeRecord = dataReader.readLine()) != null) {
                    if (genomeRecord.startsWith("<") || genomeRecord.startsWith("#") || genomeRecord == null) continue;
                    String[] fields = (genomeRecord = genomeRecord.trim()).split("\t");
                    if (fields != null && fields.length >= 3) {
                        String name = fields[0];
                        String url = fields[1];
                        String id = fields[2];
                        GenomeListItem item = new GenomeListItem(name, url, id);
                        this.serverGenomeMap.put(item.getId(), item);
                        continue;
                    }
                    log.error((Object)("Found invalid server genome list record: " + genomeRecord));
                }
            }
            catch (Exception e) {
                this.serverGenomeListUnreachable = true;
                this.serverGenomeMap = Collections.emptyMap();
                log.error((Object)"Error fetching genome list: ", (Throwable)e);
                ConfirmDialog.optionallyShowInfoDialog("Warning: could not connect to the genome server (" + genomeListURLString + ").    Only locally defined genomes will be available.", "SHOW_GENOME_SERVER_WARNING");
            }
            finally {
                if (dataReader != null) {
                    try {
                        dataReader.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        if (IGVMenuBar.getInstance() != null) {
            IGVMenuBar.getInstance().notifyGenomeServerReachable(!this.serverGenomeListUnreachable);
        }
        return this.serverGenomeMap;
    }

    public Map<String, GenomeListItem> getUserDefinedGenomeMap() {
        if (this.userDefinedGenomeMap == null) {
            boolean updateClientGenomeListFile = false;
            this.userDefinedGenomeMap = new HashMap<String, GenomeListItem>();
            File listFile = new File(DirectoryManager.getGenomeCacheDirectory(), this.getUserDefinedGenomeListFile());
            if (listFile.exists()) {
                BufferedReader reader = null;
                boolean mightBeProperties = false;
                try {
                    String nextLine;
                    reader = new BufferedReader(new FileReader(listFile));
                    while ((nextLine = reader.readLine()) != null) {
                        String file;
                        if (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                            mightBeProperties = true;
                            continue;
                        }
                        String[] fields = nextLine.split("\t");
                        if (fields.length < 3 && mightBeProperties && fields[0].contains("=")) {
                            fields = nextLine.split("\\\\t");
                            if (fields.length < 3) continue;
                            int idx = fields[0].indexOf("=");
                            fields[0] = fields[0].substring(idx + 1);
                        }
                        if (!FileUtils.isRemote(file = fields[1]) && !FileUtils.resourceExists(file)) {
                            updateClientGenomeListFile = true;
                            continue;
                        }
                        try {
                            GenomeListItem item = new GenomeListItem(fields[0], file, fields[2]);
                            this.userDefinedGenomeMap.put(item.getId(), item);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error updating user genome list line '" + nextLine + "'"), (Throwable)e);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    log.error((Object)e);
                }
                catch (IOException e) {
                    log.error((Object)e);
                    throw new RuntimeException(e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (updateClientGenomeListFile) {
                    this.exportUserDefinedGenomeList();
                }
            }
        }
        return this.userDefinedGenomeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUserDefinedGenomeList() {
        if (this.userDefinedGenomeMap == null) {
            return;
        }
        File listFile = new File(DirectoryManager.getGenomeCacheDirectory(), this.getUserDefinedGenomeListFile());
        File backup = null;
        if (listFile.exists()) {
            backup = new File(listFile.getAbsolutePath() + ".bak");
            try {
                FileUtils.copyFile(listFile, backup);
            }
            catch (IOException e) {
                log.error((Object)"Error backing up user-defined genome list file", (Throwable)e);
                backup = null;
            }
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(listFile)));
            for (GenomeListItem genomeListItem : this.userDefinedGenomeMap.values()) {
                writer.print(genomeListItem.getDisplayableName());
                writer.print("\t");
                writer.print(genomeListItem.getPath());
                writer.print("\t");
                writer.println(genomeListItem.getId());
            }
        }
        catch (Exception e) {
            if (backup != null) {
                try {
                    FileUtils.copyFile(backup, listFile);
                }
                catch (IOException e1) {
                    log.error((Object)"Error restoring genome-list file from backup");
                }
            }
            MessageUtils.showErrorMessage("Error updating user-defined genome list " + e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (backup != null) {
                backup.delete();
            }
        }
    }

    private String getUserDefinedGenomeListFile() {
        if (Globals.isTesting()) {
            return TEST_USER_DEFINED_GENOME_LIST_FILE;
        }
        return ACT_USER_DEFINED_GENOME_LIST_FILE;
    }

    public void clearUserDefinedGenomes() {
        this.userDefinedGenomeMap = null;
        new File(TEST_USER_DEFINED_GENOME_LIST_FILE).delete();
    }

    static {
        DEFAULT_GENOME = new GenomeListItem("Human (hg19)", "https://s3.amazonaws.com/igv.org.genomes/hg19/hg19.json", "hg19");
        sorter = new GenomeListSorter();
        TEST_USER_DEFINED_GENOME_LIST_FILE = "test-user-defined-genomes_" + System.currentTimeMillis() + "_" + Math.random() + ".txt";
    }

    private static class GenomeListSorter
    implements Comparator<GenomeListItem> {
        private GenomeListSorter() {
        }

        @Override
        public int compare(GenomeListItem o1, GenomeListItem o2) {
            return o1.getDisplayableName().toLowerCase().compareTo(o2.getDisplayableName().toLowerCase());
        }
    }
}

