/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.identifier;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.lang.MutableString;

public class DoubleIndexedIdentifier {
    private final IndexedIdentifier ids;
    private final Int2ObjectMap<MutableString> reverseMap;

    public DoubleIndexedIdentifier(IndexedIdentifier ids) {
        this.ids = ids;
        this.reverseMap = new Int2ObjectOpenHashMap();
        for (MutableString transcriptId : ids.keySet()) {
            this.reverseMap.put(ids.getInt(transcriptId), (Object)transcriptId);
        }
    }

    public int getIndex(MutableString id) {
        return this.ids.getInt(id);
    }

    public int getIndex(String id) {
        return this.ids.getInt(new MutableString(id));
    }

    public MutableString getId(int index) {
        return (MutableString)this.reverseMap.get(index);
    }

    public int size() {
        return this.reverseMap.size();
    }
}

