/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.TrackPanelScrollPane;

public class IGVPanel
extends JPanel
implements Paintable {
    Logger log = LogManager.getLogger(IGVPanel.class);
    MainPanel mainPanel;

    public IGVPanel(MainPanel mainPanel) {
        this.setLayout(null);
        this.mainPanel = mainPanel;
    }

    public int getViewportHeight() {
        Container parent = this.getParent();
        return parent == null ? 0 : parent.getHeight();
    }

    public TrackPanelScrollPane getScrollPane() {
        TrackPanelScrollPane scollpane = null;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            scollpane = (TrackPanelScrollPane)((Object)((JViewport)parent).getParent());
        }
        return scollpane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int h = this.getHeight();
            Component[] children = this.getComponents();
            int nw = this.mainPanel.getNamePanelWidth();
            Component namePanel = children[0];
            Component attributePanel = children[1];
            Component dataPanel = children[2];
            namePanel.setBounds(this.mainPanel.getNamePanelX(), 0, nw, h);
            attributePanel.setBounds(this.mainPanel.getAttributePanelX(), 0, this.mainPanel.getAttributePanelWidth(), h);
            dataPanel.setBounds(this.mainPanel.getDataPanelX(), 0, this.mainPanel.getDataPanelWidth(), h);
            dataPanel.doLayout();
        }
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect, boolean batch) {
        g.setColor(Color.black);
        Component[] children = this.getComponents();
        Component namePanel = children[0];
        Rectangle nameRect = new Rectangle(namePanel.getBounds());
        if (nameRect.width > 0) {
            Graphics2D nameGraphics = (Graphics2D)g.create();
            nameGraphics.translate(nameRect.x, 0);
            nameRect.x = 0;
            nameGraphics.setClip(nameRect);
            ((Paintable)((Object)namePanel)).paintOffscreen(nameGraphics, nameRect, batch);
            nameGraphics.dispose();
        }
        Component attributePanel = children[1];
        Rectangle attRect = new Rectangle(attributePanel.getBounds());
        if (attRect.width > 0) {
            Graphics2D attributeGraphics = (Graphics2D)g.create();
            attributeGraphics.translate(attRect.x, 0);
            attRect.x = 0;
            attributeGraphics.setClip(attRect);
            ((Paintable)((Object)attributePanel)).paintOffscreen(attributeGraphics, attRect, batch);
            attributeGraphics.dispose();
        }
        Component dataPanel = children[2];
        Rectangle dataRect = new Rectangle(dataPanel.getBounds());
        Graphics2D dataGraphics = (Graphics2D)g.create();
        dataGraphics.translate(dataRect.x, 0);
        dataRect.x = 0;
        g.setClip(dataRect);
        ((Paintable)((Object)dataPanel)).paintOffscreen(dataGraphics, dataRect, batch);
        dataGraphics.dispose();
    }

    @Override
    public int getSnapshotHeight(boolean batch) {
        return this.getHeight();
    }
}

