/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.goby;

import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import htsjdk.samtools.util.CloseableIterator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.broad.igv.goby.GobyAlignment;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.sam.Alignment;
import org.campagnelab.goby.alignments.AlignmentReaderImpl;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.exception.GobyRuntimeException;

public class GobyAlignmentIterator
implements CloseableIterator<Alignment> {
    private static final Logger LOG = LogManager.getLogger(GobyAlignmentIterator.class);
    private int targetIndex;
    private int startReferencePosition;
    private int endReferencePosition;
    private final AlignmentReaderImpl reader;
    protected final DoubleIndexedIdentifier indexToReferenceId;
    private int previousPosition = Integer.MIN_VALUE;
    private int previousReferenceIndex = -1;
    private boolean useWindow;
    private String reference;
    private int currentPosition;
    Int2ObjectMap<ObjectArrayList<GobyAlignment>> spliceCache = new Int2ObjectOpenHashMap();
    private Alignments.AlignmentEntry nextEntry = null;

    public GobyAlignmentIterator(AlignmentReaderImpl reader, DoubleIndexedIdentifier targetIdentifiers) {
        this.reader = reader;
        this.indexToReferenceId = targetIdentifiers;
        this.startReferencePosition = 0;
        this.endReferencePosition = Integer.MAX_VALUE;
        this.previousPosition = Integer.MIN_VALUE;
        this.useWindow = false;
    }

    public ObjectArrayList<GobyAlignment> cacheSpliceComponent(GobyAlignment alignment) {
        if (this.useWindow) {
            int queryIndex = alignment.entry.getQueryIndex();
            ObjectArrayList list = (ObjectArrayList)this.spliceCache.get(queryIndex);
            if (list == null) {
                list = new ObjectArrayList();
                this.spliceCache.put(queryIndex, (Object)list);
            }
            list.add((Object)alignment);
            return list;
        }
        return null;
    }

    public GobyAlignmentIterator(AlignmentReaderImpl reader, DoubleIndexedIdentifier targetIdentifiers, int referenceIndex, String chr, int start, int end) throws IOException {
        this(reader, targetIdentifiers);
        this.useWindow = true;
        if (referenceIndex != -1) {
            this.targetIndex = referenceIndex;
            this.reference = chr;
            this.startReferencePosition = start;
            this.endReferencePosition = end;
            this.previousReferenceIndex = referenceIndex;
            reader.reposition(referenceIndex, start);
        }
    }

    protected GobyAlignmentIterator(int targetIndex, int start, int end) throws IOException {
        this.useWindow = true;
        this.targetIndex = targetIndex;
        this.startReferencePosition = start;
        this.endReferencePosition = end;
        this.reader = null;
        this.indexToReferenceId = null;
    }

    public void close() {
    }

    public boolean hasNext() {
        if (this.nextEntry != null) {
            return true;
        }
        try {
            if (!this.useWindow) {
                if (!this.reader.hasNext()) {
                    return false;
                }
                this.nextEntry = this.reader.next();
            } else {
                this.nextEntry = this.reader.skipTo(this.targetIndex, this.startReferencePosition);
                if (this.nextEntry == null || this.nextEntry.getTargetIndex() != this.targetIndex || this.nextEntry.getPosition() < this.startReferencePosition || this.nextEntry.getPosition() > this.endReferencePosition) {
                    this.nextEntry = null;
                }
            }
        }
        catch (IOException e) {
            this.nextEntry = null;
            LOG.error(e);
            return false;
        }
        catch (GobyRuntimeException e) {
            this.nextEntry = null;
            LOG.error(e);
            return false;
        }
        boolean result = this.nextEntry != null;
        return result;
    }

    public Alignment next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Alignments.AlignmentEntry entry = this.nextEntry;
        this.nextEntry = null;
        this.currentPosition = entry.getPosition();
        return new GobyAlignment(this, entry);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    String getReference() {
        return this.reference;
    }

    public MutableString getId(int targetIndex) {
        return this.indexToReferenceId.getId(targetIndex);
    }
}

