/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.Feature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.feature.CytoBandFileParser;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.fasta.FastaBlockCompressedSequence;
import org.broad.igv.feature.genome.fasta.FastaIndexedSequence;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class JsonGenomeLoader
extends GenomeLoader {
    private static Logger log = LogManager.getLogger(JsonGenomeLoader.class);
    private String genomePath;

    public JsonGenomeLoader(String genomePath) {
        this.genomePath = genomePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Genome loadGenome() throws IOException {
        try (BufferedReader reader = null;){
            JsonElement chromosomeOrder;
            JsonElement wholeGenomeView;
            JsonElement aliasURL;
            JsonElement blatDB;
            JsonElement ucscIDElement;
            reader = ParsingUtils.openBufferedReader(this.genomePath);
            JsonParser parser = new JsonParser();
            JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
            String id = json.get("id").getAsString();
            String name = json.get("name").getAsString();
            String fastaPath = json.get("fastaURL").getAsString();
            JsonElement indexPathObject = json.get("indexURL");
            String indexPath = indexPathObject == null ? null : indexPathObject.getAsString();
            JsonElement gziObject = json.get("gziIndexURL");
            String gziIndexPath = gziObject == null ? null : gziObject.getAsString();
            fastaPath = FileUtils.getAbsolutePath(fastaPath, this.genomePath);
            if (indexPath != null) {
                indexPath = FileUtils.getAbsolutePath(indexPath, this.genomePath);
            }
            if (gziIndexPath != null) {
                gziIndexPath = FileUtils.getAbsolutePath(gziIndexPath, this.genomePath);
            }
            FastaIndexedSequence sequence = fastaPath.endsWith(".gz") ? new FastaBlockCompressedSequence(fastaPath, gziIndexPath, indexPath) : new FastaIndexedSequence(fastaPath, indexPath);
            JsonElement orderedElement = json.get("ordered");
            boolean ordered = orderedElement != null && orderedElement.getAsBoolean();
            ArrayList<ResourceLocator> tracks = new ArrayList<ResourceLocator>();
            ArrayList<ResourceLocator> hiddenTracks = new ArrayList<ResourceLocator>();
            JsonArray annotations = json.getAsJsonArray("tracks");
            if (annotations == null) {
                annotations = json.getAsJsonArray("annotations");
            }
            if (annotations != null) {
                annotations.forEach(jsonElement -> {
                    boolean indexed;
                    JsonElement vizwindow;
                    JsonElement format;
                    JsonElement trackIndex;
                    JsonObject obj = jsonElement.getAsJsonObject();
                    String trackPath = obj.get("url").getAsString();
                    if (trackPath != null) {
                        trackPath = FileUtils.getAbsolutePath(trackPath, this.genomePath);
                    }
                    ResourceLocator res = new ResourceLocator(trackPath);
                    JsonElement trackName = obj.get("name");
                    if (trackName != null) {
                        res.setName(trackName.getAsString());
                    }
                    if ((trackIndex = obj.get("indexURL")) != null) {
                        res.setIndexPath(FileUtils.getAbsolutePath(trackIndex.getAsString(), this.genomePath));
                    }
                    if ((format = obj.get("format")) != null) {
                        res.setFormat(format.getAsString());
                    }
                    if ((vizwindow = obj.get("visibilityWindow")) != null) {
                        res.setVisibilityWindow(obj.get("visibilityWindow").getAsInt());
                    } else {
                        res.setVisibilityWindow(-1);
                    }
                    JsonElement indexedElement = obj.get("indexed");
                    JsonElement hiddenElement = obj.get("hidden");
                    boolean hidden = hiddenElement != null && hiddenElement.getAsBoolean();
                    boolean bl = indexed = indexedElement != null && indexedElement.getAsBoolean();
                    if (indexedElement != null) {
                        res.setIndexed(indexed);
                    }
                    if (hidden) {
                        if (indexed || trackIndex != null) {
                            log.info("Hidden tracks cannot be indexed.  Ignoring " + trackPath);
                        } else {
                            hiddenTracks.add(res);
                        }
                    } else {
                        tracks.add(res);
                    }
                });
            }
            Genome newGenome = new Genome(id, name, sequence, ordered);
            newGenome.setAnnotationResources(tracks);
            JsonElement cyobandElement = json.get("cytobandURL");
            if (cyobandElement != null) {
                String cytobandPath = FileUtils.getAbsolutePath(cyobandElement.getAsString(), this.genomePath);
                BufferedReader br = null;
                try {
                    br = ParsingUtils.openBufferedReader(cytobandPath);
                    newGenome.setCytobands(CytoBandFileParser.loadData(br));
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if ((ucscIDElement = json.get("ucscID")) != null) {
                newGenome.setUcscID(ucscIDElement.getAsString());
            }
            if ((blatDB = json.get("blatDB")) != null) {
                newGenome.setUcscID(blatDB.getAsString());
            }
            if ((aliasURL = json.get("aliasURL")) != null) {
                String aliasPath = FileUtils.getAbsolutePath(aliasURL.getAsString(), this.genomePath);
                newGenome.addChrAliases(GenomeLoader.loadChrAliases(aliasPath));
            }
            if (hiddenTracks.size() > 0) {
                this.addToFeatureDB(hiddenTracks, newGenome);
            }
            if ((wholeGenomeView = json.get("wholeGenomeView")) != null) {
                newGenome.setShowWholeGenomeView(wholeGenomeView.getAsBoolean());
            }
            if ((chromosomeOrder = json.get("chromosomeOrder")) != null) {
                ArrayList<String> chrs;
                if (chromosomeOrder.isJsonArray()) {
                    JsonArray a = chromosomeOrder.getAsJsonArray();
                    chrs = new ArrayList<String>();
                    for (JsonElement e : a) {
                        chrs.add(e.getAsString());
                    }
                } else {
                    String[] c = Globals.commaPattern.split(chromosomeOrder.getAsString());
                    chrs = new ArrayList(c.length);
                    for (String t : c) {
                        chrs.add(t.trim());
                    }
                }
                newGenome.setLongChromosomeNames(chrs);
            }
            Genome genome = newGenome;
            return genome;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenomeDescriptor loadDescriptor() throws IOException {
        try (BufferedReader reader = null;){
            reader = ParsingUtils.openBufferedReader(this.genomePath);
            JsonParser parser = new JsonParser();
            JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
            String id = json.get("id").getAsString();
            String name = json.get("name").getAsString();
            String fastaPath = json.get("fastaURL").getAsString();
            GenomeDescriptor genomeDescriptor = new GenomeDescriptor(id, name, fastaPath);
            return genomeDescriptor;
        }
    }

    private void addToFeatureDB(List<ResourceLocator> locators, Genome genome) {
        for (ResourceLocator locator : locators) {
            try {
                AbstractFeatureReader featureReader = TribbleFeatureSource.getBasicReader(locator, genome);
                for (Feature f : featureReader) {
                    if (!(f instanceof NamedFeature)) continue;
                    FeatureDB.addFeature((NamedFeature)f, genome);
                }
            }
            catch (IOException e) {
                log.error("Error loading " + locator.getPath());
            }
        }
    }

    public static class GenomeDescriptor {
        String id;
        String name;
        String fastaURL;

        public GenomeDescriptor(String id, String name, String fastaURL) {
            this.id = id;
            this.name = name;
            this.fastaURL = fastaURL;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getFastaURL() {
            return this.fastaURL;
        }
    }
}

