/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.tribble.Tribble;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.util.ParsingUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Mutation;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.MUTCodec;
import org.broad.igv.feature.tribble.TribbleIndexNotFoundException;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.util.ResourceLocator;

public class MutationFeatureSource
implements FeatureSource<Mutation> {
    private static Logger log = LogManager.getLogger(MutationFeatureSource.class);
    String sample;
    MutationDataManager dataManager;

    public MutationFeatureSource(String sample, MutationDataManager dataManager) {
        this.sample = sample;
        this.dataManager = dataManager;
    }

    @Override
    public Iterator<Mutation> getFeatures(String chr, int start, int end) throws IOException {
        return this.dataManager.getFeatures(this.sample, chr, start, end);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    public static class MutationDataManager {
        Range currentRange;
        Map<String, List<Mutation>> featureMap = Collections.synchronizedMap(new HashMap());
        TribbleFeatureSource tribbleFeatureSource;
        ResourceLocator locator;

        public MutationDataManager(ResourceLocator locator, Genome genome) throws IOException, TribbleIndexNotFoundException {
            this.tribbleFeatureSource = TribbleFeatureSource.getFeatureSource(locator, genome);
            this.locator = locator;
        }

        public boolean isIndexed() {
            return this.tribbleFeatureSource.isIndexed();
        }

        synchronized Iterator<Mutation> getFeatures(String trackKey, String chr, int start, int end) throws IOException {
            List<Mutation> featureList;
            if (this.currentRange == null || !this.currentRange.contains(chr, start, end)) {
                Iterator features = this.tribbleFeatureSource.getFeatures(chr, start, end);
                while (features.hasNext()) {
                    Mutation feat = (Mutation)features.next();
                    String thisKey = feat.getSampleId();
                    List<Mutation> keyFeatures = this.featureMap.get(thisKey);
                    if (keyFeatures == null) {
                        keyFeatures = new ArrayList<Mutation>();
                        this.featureMap.put(thisKey, keyFeatures);
                    }
                    keyFeatures.add(feat);
                    this.currentRange = new Range(chr, start, end);
                }
            }
            return (featureList = this.featureMap.get(trackKey)) == null ? Collections.EMPTY_LIST.iterator() : featureList.iterator();
        }

        public String[] getSamples() {
            Map map;
            Index idx;
            if (this.tribbleFeatureSource.isIndexed() && (idx = this.loadIndex(this.locator.getPath())) != null && (map = idx.getProperties()) != null && map.containsKey("samples")) {
                return Globals.commaPattern.split((CharSequence)map.get("samples"));
            }
            MUTCodec codec = new MUTCodec(this.locator.getPath(), null);
            return codec.getSamples();
        }

        private Index loadIndex(String path) {
            try {
                String indexFile = Tribble.indexFile((String)path);
                Index index = null;
                if (ParsingUtils.resourceExists((String)indexFile)) {
                    index = IndexFactory.loadIndex((String)indexFile);
                } else if (ParsingUtils.resourceExists((String)(indexFile = ParsingUtils.appendToPath((String)indexFile, (String)".gz")))) {
                    index = IndexFactory.loadIndex((String)indexFile);
                }
                return index;
            }
            catch (IOException e) {
                log.error("Error loading index file", (Throwable)e);
                return null;
            }
        }
    }
}

