/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import htsjdk.samtools.util.CloseableIterator;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;

public class PairedEndStats {
    private static Logger log = LogManager.getLogger(PairedEndStats.class);
    private double minPercentileInsertSize;
    private double maxPercentileInsertSize;
    private double averageInsertSize;
    private double medianInsertSize;
    private double stddevInsertSize;
    private double madInsertSize;
    private static final int MAX_PAIRS = 10000;

    public static void main(String[] args) throws IOException {
        AlignmentReader reader = AlignmentReaderFactory.getReader(args[0], false);
        CloseableIterator iter = reader.iterator();
        PairedEndStats stats = PairedEndStats.compute(iter, 0.1, 99.9);
        iter.close();
        reader.close();
        System.out.println(args[0] + "\t" + stats.averageInsertSize + "\t" + stats.medianInsertSize + "\t" + stats.stddevInsertSize + "\t" + stats.madInsertSize);
    }

    public PairedEndStats(double averageInsertSize, double medianInsertSize, double insertSizeStdev, double madInsertSize, double secondPercentileSize, double maxPercentileInsertSize) {
        this.averageInsertSize = averageInsertSize;
        this.medianInsertSize = medianInsertSize;
        this.stddevInsertSize = insertSizeStdev;
        this.madInsertSize = madInsertSize;
        this.minPercentileInsertSize = secondPercentileSize;
        this.maxPercentileInsertSize = maxPercentileInsertSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PairedEndStats compute(String bamFile) {
        AlignmentReader reader = null;
        try {
            reader = AlignmentReaderFactory.getReader(bamFile, false);
            CloseableIterator alignmentCloseableIterator = reader.iterator();
            PairedEndStats stats = PairedEndStats.compute(alignmentCloseableIterator, 0.1, 99.9);
            alignmentCloseableIterator.close();
            PairedEndStats pairedEndStats = stats;
            return pairedEndStats;
        }
        catch (IOException e) {
            log.error("Error reading sam file: " + e.getMessage(), (Throwable)e);
            PairedEndStats pairedEndStats = null;
            return pairedEndStats;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static PairedEndStats compute(AlignmentReader reader, String chr, int start, int end) {
        try {
            PairedEndStats stats = PairedEndStats.compute(reader.query(chr, start, end, false), 0.1, 99.9);
            return stats;
        }
        catch (IOException e) {
            log.error("Error computing alignment stats: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static PairedEndStats compute(Iterator<Alignment> alignments, double minPercentile, double maxPercentile) {
        double[] insertSizes = new double[10000];
        int nPairs = 0;
        while (alignments.hasNext()) {
            Alignment al = alignments.next();
            if (PairedEndStats.isProperPair(al)) {
                insertSizes[nPairs] = Math.abs(al.getInferredInsertSize());
                ++nPairs;
            }
            if (nPairs < 10000) continue;
            break;
        }
        if (nPairs == 0) {
            log.error("Error computing insert size distribution. No alignments in sample interval.");
            return null;
        }
        double mean = StatUtils.mean((double[])insertSizes, (int)0, (int)nPairs);
        double median = StatUtils.percentile((double[])insertSizes, (int)0, (int)nPairs, (double)50.0);
        double stdDev = Math.sqrt(StatUtils.variance((double[])insertSizes, (int)0, (int)nPairs));
        double[] deviations = new double[nPairs];
        for (int i = 0; i < nPairs; ++i) {
            deviations[i] = Math.abs(insertSizes[i] - median);
        }
        double mad = 1.4826 * StatUtils.percentile((double[])deviations, (double)50.0);
        double sec = StatUtils.percentile((double[])insertSizes, (int)0, (int)nPairs, (double)minPercentile);
        double max = StatUtils.percentile((double[])insertSizes, (int)0, (int)nPairs, (double)maxPercentile);
        PairedEndStats stats = new PairedEndStats(mean, median, stdDev, mad, sec, max);
        return stats;
    }

    static boolean isProperPair(Alignment alignment) {
        if (alignment.isMapped() && alignment.isPaired() && alignment.isProperPair() && !alignment.isDuplicate() && alignment.getMappingQuality() > 0 && !alignment.isVendorFailedRead() && alignment.getInferredInsertSize() != 0) {
            ReadMate mate = alignment.getMate();
            boolean mateMapped = mate != null && mate.isMapped();
            boolean sameChromosome = mateMapped && mate.getChr().equals(alignment.getChr());
            return mateMapped && sameChromosome;
        }
        return false;
    }

    public double getAverageInsertSize() {
        return this.averageInsertSize;
    }

    public double getMedianInsertSize() {
        return this.medianInsertSize;
    }

    public double getStddevInsertSize() {
        return this.stddevInsertSize;
    }

    public double getMadInsertSize() {
        return this.madInsertSize;
    }

    public double getMinPercentileInsertSize() {
        return this.minPercentileInsertSize;
    }

    public double getMaxPercentileInsertSize() {
        return this.maxPercentileInsertSize;
    }
}

