/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ProgressMonitor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.RunnableResult;

public class URLDownloader
implements Runnable {
    private static Logger log = LogManager.getLogger(URLDownloader.class);
    private ProgressMonitor monitor = null;
    private final URL srcUrl;
    private final File outputFile;
    private volatile boolean started = false;
    private volatile boolean done = false;
    private volatile boolean cancelled = false;
    private volatile RunnableResult result;

    public URLDownloader(String url, File outputFile) throws MalformedURLException {
        this.srcUrl = HttpUtils.createURL(url);
        this.outputFile = outputFile;
    }

    @Override
    public void run() {
        if (this.cancelled) {
            return;
        }
        this.started = true;
        try {
            this.result = this.doDownload();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.done();
        }
    }

    public RunnableResult getResult() {
        if (!this.done) {
            throw new IllegalStateException("Must wait for run to finish before getting result");
        }
        return this.result;
    }

    private RunnableResult doDownload() throws IOException {
        boolean knownComplete;
        log.info("Downloading " + this.srcUrl + " to " + this.outputFile.getAbsolutePath());
        HttpURLConnection conn = HttpUtils.getInstance().openConnection(this.srcUrl, null);
        long contentLength = -1L;
        String contentLengthString = conn.getHeaderField("Content-Length");
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
        }
        InputStream is = null;
        OutputStream out = null;
        long downloaded = 0L;
        String msg1 = String.format("downloaded of %s total", contentLength >= 0L ? this.bytesToByteCountString(contentLength) : "unknown");
        int perc = 0;
        try {
            int bytesRead;
            is = conn.getInputStream();
            out = new FileOutputStream(this.outputFile);
            byte[] buf = new byte[65536];
            int counter = 0;
            int interval = 100;
            while (!this.cancelled && (bytesRead = is.read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
                downloaded += (long)bytesRead;
                counter = (counter + 1) % interval;
                if (counter == 0 && this.monitor != null) {
                    String curStatus = String.format("%s %s", this.bytesToByteCountString(downloaded), msg1);
                    this.monitor.setNote(curStatus);
                    if (contentLength >= 0L) {
                        perc = (int)(downloaded * 100L / contentLength);
                        this.monitor.setProgress(perc);
                    }
                }
                if (this.monitor == null || !this.monitor.isCanceled()) continue;
                is.close();
                this.outputFile.delete();
                this.cancelled = true;
            }
            log.info("Download complete.  Total bytes downloaded = " + downloaded);
        }
        catch (IOException e) {
            HttpUtils.getInstance().readErrorStream(conn);
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        long fileLength = this.outputFile.length();
        if (this.cancelled) {
            return RunnableResult.CANCELLED;
        }
        boolean bl = knownComplete = contentLength == fileLength;
        if (knownComplete || contentLength < 0L) {
            if (this.monitor != null) {
                this.monitor.setProgress(100);
                this.monitor.setNote("Done");
            }
            return RunnableResult.SUCCESS;
        }
        return RunnableResult.FAILURE;
    }

    protected void done() {
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.started && !mayInterruptIfRunning) {
            return false;
        }
        this.cancelled = true;
        return true;
    }

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public String bytesToByteCountString(long bytes) {
        int unit = 1000;
        String prefs = "KMGT";
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        if (exp <= 0 || exp >= prefs.length()) {
            return bytes + " B";
        }
        String pre = "" + prefs.charAt(exp - 1);
        return String.format("%.2f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

