/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.aa;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.feature.aa.AminoAcidManager;
import org.broad.igv.feature.aa.CodonTable;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.util.ParsingUtils;

public class CodonTableManager {
    private static final Logger log = Logger.getLogger(CodonTableManager.class);
    public static final String DEFAULT_CODON_TABLE_PATH = "resources/geneticCode.json";
    static final String DEFAULT_TRANS_TABLE_PATH = "resources/defaultTranslationTables.json";
    public static final int STANDARD_TABLE_ID = 1;
    private Map<String, CodonTableMap> genomeChromoTable = new HashMap<String, CodonTableMap>();
    private LinkedHashMap<Integer, CodonTable> allCodonTables = new LinkedHashMap(20);
    private CodonTable defaultCodonTable;
    private CodonTable currentCodonTable;
    private static CodonTableManager instance;

    public static synchronized CodonTableManager getInstance() {
        if (instance == null) {
            AminoAcidManager.initAANameMap();
            instance = new CodonTableManager();
        }
        return instance;
    }

    private CodonTableManager() {
        this.init();
    }

    private void init() {
        try {
            this.loadDefaultTranslationTables();
            this.loadCodonTables(DEFAULT_CODON_TABLE_PATH);
        }
        catch (IOException e) {
            CodonTableManager.handleExceptionLoading(e);
        }
        catch (JsonParseException e) {
            log.error((Object)e);
        }
    }

    private static void handleExceptionLoading(Exception e) {
        log.error((Object)e);
        if (instance == null) {
            throw new IllegalStateException("No codon table present, and error loading resources/geneticCode.json", e);
        }
    }

    public void resetToDefaults() {
        this.currentCodonTable = null;
        this.genomeChromoTable = new HashMap<String, CodonTableMap>();
        this.allCodonTables = new LinkedHashMap(20);
        this.init();
    }

    public CodonTable getCodonTableForChromosome(String genomeID, String chr) {
        if (this.currentCodonTable != null) {
            return this.currentCodonTable;
        }
        CodonTableMap map = this.genomeChromoTable.get(genomeID);
        if (map == null) {
            return this.defaultCodonTable;
        }
        Integer tableID = map.getTableIdForChr(chr);
        return this.allCodonTables.get(tableID);
    }

    public CodonTable getCodonTableForChromosome(String chr) {
        return this.getCodonTableForChromosome(GenomeManager.getInstance().getGenomeId(), chr);
    }

    public Collection<CodonTable> getAllCodonTables() {
        return Collections.unmodifiableCollection(this.allCodonTables.values());
    }

    public void setCurrentCodonTable(CodonTable codonTable) {
        this.currentCodonTable = codonTable;
    }

    synchronized void loadCodonTables(String codonTablesPath) throws IOException, JsonParseException {
        LinkedHashMap<Integer, CodonTable> newCodonTables = new LinkedHashMap<Integer, CodonTable>(20);
        InputStream is = AminoAcidManager.class.getResourceAsStream(codonTablesPath);
        if (is == null) {
            is = ParsingUtils.openInputStream(codonTablesPath);
        }
        if (codonTablesPath.endsWith(".json")) {
            JsonObject allData = CodonTableManager.readJSONFromStream(is);
            int defaultId = -1;
            defaultId = allData.get("defaultid").getAsInt();
            JsonArray codonArray = allData.get("Genetic-code-table").getAsJsonArray();
            if (codonArray.size() == 0) {
                throw new JsonParseException("JSON File has empty array for Genetic-code-table");
            }
            for (int ca = 0; ca < codonArray.size(); ++ca) {
                CodonTable curTable = CodonTable.createFromJSON(codonTablesPath, codonArray.get(ca).getAsJsonObject());
                newCodonTables.put(curTable.getId(), curTable);
                if (this.defaultCodonTable != null && curTable.getId() != defaultId) continue;
                this.defaultCodonTable = curTable;
            }
        } else {
            throw new IllegalArgumentException("Unknown file type, must be .json");
        }
        this.allCodonTables.putAll(newCodonTables);
        is.close();
    }

    private void loadDefaultTranslationTables() throws JsonParseException {
        InputStream is = CodonTableManager.class.getResourceAsStream(DEFAULT_TRANS_TABLE_PATH);
        JsonObject allData = CodonTableManager.readJSONFromStream(is);
        JsonArray organisms = allData.get("organisms").getAsJsonArray();
        for (int ind = 0; ind < organisms.size(); ++ind) {
            JsonObject obj = organisms.get(ind).getAsJsonObject();
            String genomeId = obj.get("genomeId").getAsString();
            this.genomeChromoTable.put(genomeId, new CodonTableMap(obj));
        }
    }

    private static JsonObject readJSONFromStream(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        JsonParser parser = new JsonParser();
        return parser.parse((Reader)reader).getAsJsonObject();
    }

    public CodonTable getDefaultCodonTable() {
        return this.defaultCodonTable;
    }

    public CodonTable getCurrentCodonTable() {
        return this.currentCodonTable;
    }

    public CodonTable getCodonTableByID(Integer id) {
        return this.allCodonTables.get(id);
    }

    static class CodonTableMap {
        String genomeID;
        Integer defaultID;
        Map<String, Integer> chromosomeIDs;

        CodonTableMap(JsonObject obj) {
            this.genomeID = obj.get("genomeId").getAsString();
            this.chromosomeIDs = new HashMap<String, Integer>();
            JsonObject chromosomes = obj.get("chromosomes").getAsJsonObject();
            this.defaultID = chromosomes.get("default").getAsInt();
            for (Map.Entry entry : chromosomes.entrySet()) {
                String chromoName = (String)entry.getKey();
                int id = ((JsonElement)entry.getValue()).getAsInt();
                this.chromosomeIDs.put(chromoName, id);
            }
        }

        Integer getTableIdForChr(String chr) {
            if (this.chromosomeIDs.containsKey(chr)) {
                return this.chromosomeIDs.get(chr);
            }
            return this.defaultID;
        }
    }
}

