/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceFinder {
    public SearchInClasspath searchInClasspath = SearchInClasspath.BEFORE_LOCAL;
    private static final Log LOG = LogFactory.getLog(ResourceFinder.class);
    private final List<String> searchPaths = new LinkedList<String>();

    public ResourceFinder() {
        this(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public ResourceFinder(String ... searchPathsVal) {
        if (searchPathsVal != null && searchPathsVal.length > 0) {
            for (String searchPath : searchPathsVal) {
                searchPath = FilenameUtils.separatorsToUnix((String)searchPath);
                while (searchPath.endsWith("/")) {
                    searchPath = searchPath.substring(0, searchPath.length() - 1);
                }
                this.searchPaths.add(searchPath);
            }
        } else {
            this.searchPaths.add(".");
        }
    }

    public URL findResource(String resource) {
        URL url;
        if (this.searchInClasspath == SearchInClasspath.BEFORE_LOCAL && (url = this.findResourceInClasspath(resource)) != null) {
            return url;
        }
        url = this.findResourceInLocal(resource);
        if (url != null) {
            return url;
        }
        if (this.searchInClasspath == SearchInClasspath.AFTER_LOCAL && (url = this.findResourceInClasspath(resource)) != null) {
            return url;
        }
        return null;
    }

    private URL findResourceInClasspath(String resource) {
        URL url = this.resourceToUrl(resource);
        if (url != null) {
            return url;
        }
        for (String searchPath : this.searchPaths) {
            url = this.resourceToUrl(searchPath + "/" + resource);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private URL findResourceInLocal(String resource) {
        for (String searchPath : this.searchPaths) {
            URL url = this.fileToURL(searchPath + IOUtils.DIR_SEPARATOR + resource);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private URL fileToURL(String filename) {
        URL url = null;
        try {
            File file = new File(filename);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to find [" + filename + "] as file in filesystem"));
            }
            if (file.exists() && file.isFile() && file.canRead()) {
                url = file.toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (url != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("... fo`und url is [" + url.toString() + "]"));
        }
        return url;
    }

    private URL resourceToUrl(String resource) {
        URL url;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to find [" + resource + "] using context class loader " + loader));
        }
        if ((url = loader.getResource(resource)) == null) {
            loader = ResourceFinder.class.getClassLoader();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to find [" + resource + "] using class loader " + loader));
            }
            url = loader.getResource(resource);
        }
        if (url == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to find [" + resource + "] using system class loader"));
            }
            url = ClassLoader.getSystemResource(resource);
        }
        if (url != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("... found url is [" + url.toString() + "]"));
        }
        return url;
    }

    public InputStream inputStreamForResource(String resource) throws IOException {
        URL url = this.findResource(resource);
        InputStream is = null;
        if (url != null) {
            is = url.openStream();
        }
        return is;
    }

    public String[] getResourceListing(Class clazz) throws URISyntaxException, IOException {
        String classPackage = ClassUtils.getPackageName((Class)clazz);
        String classPacakgePath = classPackage.replace(".", "/");
        return this.getResourceListing(clazz, classPacakgePath);
    }

    public String[] getResourceListing(Class clazz, String pathVal) throws URISyntaxException, IOException {
        String path = pathVal.replace("\\", "/");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        URL dirURL = this.findResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String classFilename = clazz.getName().replace(".", "/") + ".class";
            dirURL = this.findResource(classFilename);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf(33));
            if (jarPath.charAt(2) == ':') {
                jarPath = jarPath.substring(1);
            }
            jarPath = URLDecoder.decode(jarPath, "UTF-8");
            JarFile jar = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                int checkSubdir;
                String entry;
                String name = entries.nextElement().getName();
                if (!name.startsWith(path) || (entry = name.substring(path.length())).length() == 0 || (checkSubdir = entry.indexOf(47)) >= 0) continue;
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    public SearchInClasspath getSearchInClasspath() {
        return this.searchInClasspath;
    }

    public void setSearchInClasspath(SearchInClasspath searchInClasspath) {
        this.searchInClasspath = searchInClasspath;
    }

    public static enum SearchInClasspath {
        BEFORE_LOCAL,
        AFTER_LOCAL,
        NEVER;

    }
}

