/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.baseinfo;

import java.util.Properties;
import java.util.function.Function;
import org.campagnelab.dl.varanalysis.protobuf.BaseInformationRecords;

public abstract class StatAccumulator {
    protected final Function<? super BaseInformationRecords.BaseInformation, ? extends Float> statCalculation;
    protected float minimumValue = Float.POSITIVE_INFINITY;
    protected float maximumValue = Float.NEGATIVE_INFINITY;
    protected String propertyName;

    public StatAccumulator(String propertyName, Function<? super BaseInformationRecords.BaseInformation, ? extends Float> statCalculation) {
        this.propertyName = propertyName;
        this.statCalculation = statCalculation;
    }

    void observe(BaseInformationRecords.BaseInformation record) {
        this.observe(this.statCalculation.apply(record).floatValue());
    }

    void observe(float value) {
        this.minimumValue = Math.min(this.minimumValue, value);
        this.maximumValue = Math.max(this.maximumValue, value);
    }

    protected boolean isDefined(float v) {
        return v != Float.POSITIVE_INFINITY && v != Float.NEGATIVE_INFINITY;
    }

    void mergeWith(Properties properties) {
        if (properties.containsKey(this.propertyName + ".min")) {
            this.minimumValue = Math.min(this.minimumValue, Float.parseFloat(properties.get(this.propertyName + ".min").toString()));
        }
        if (properties.containsKey(this.propertyName + ".max")) {
            this.maximumValue = Math.max(this.maximumValue, Float.parseFloat(properties.get(this.propertyName + ".max").toString()));
        }
    }

    void setProperties(Properties properties) {
        if (this.minimumValue != Float.POSITIVE_INFINITY) {
            properties.setProperty(this.propertyName + ".min", Float.toString(this.minimumValue));
        }
        if (this.maximumValue != Float.NEGATIVE_INFINITY) {
            properties.setProperty(this.propertyName + ".max", Float.toString(this.maximumValue));
        }
    }
}

