/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.AttributePanel;
import org.broad.igv.ui.panel.DataPanelContainer;
import org.broad.igv.ui.panel.IGVPanel;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackNamePanel;

public class TrackPanel
extends IGVPanel {
    private static Logger log = LogManager.getLogger(TrackPanel.class);
    private String name = null;
    private TrackNamePanel namePanel;
    private AttributePanel attributePanel;
    private DataPanelContainer dataPanelContainer;
    private String groupAttribute;
    private int trackCountEstimate = 0;
    private List<TrackGroup> trackGroups;
    transient int lastHeight = 0;

    public TrackPanel(String name, MainPanel mainPanel) {
        super(mainPanel);
        this.name = name;
        TrackGroup nullGroup = new TrackGroup();
        nullGroup.setDrawBorder(false);
        this.trackGroups = Collections.synchronizedList(new LinkedList());
        this.trackGroups.add(nullGroup);
        this.init();
    }

    private void init() {
        this.namePanel = new TrackNamePanel(this);
        this.attributePanel = new AttributePanel(this);
        this.dataPanelContainer = new DataPanelContainer(this);
        this.add(this.namePanel);
        this.add(this.attributePanel);
        this.add(this.dataPanelContainer);
    }

    public void createDataPanels() {
        this.dataPanelContainer.createDataPanels();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.namePanel != null) {
            this.namePanel.setBackground(color);
            this.attributePanel.setBackground(color);
            this.dataPanelContainer.setBackground(color);
        }
    }

    public TrackNamePanel getNamePanel() {
        return this.namePanel;
    }

    public AttributePanel getAttributePanel() {
        return this.attributePanel;
    }

    public DataPanelContainer getDataPanelContainer() {
        return this.dataPanelContainer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<TrackGroup> getGroups() {
        return this.trackGroups;
    }

    public boolean hasTracks() {
        for (TrackGroup tg : this.trackGroups) {
            if (tg.getVisibleTracks().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public int getVisibleTrackCount() {
        int count = 0;
        for (TrackGroup tg : this.trackGroups) {
            for (Track t : tg.getVisibleTracks()) {
                if (t == null || !t.isVisible()) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean isHeightChanged() {
        int height = this.getPreferredPanelHeight();
        boolean change = height != this.lastHeight;
        this.lastHeight = height;
        return change;
    }

    public List<Track> getTracks() {
        ArrayList<Track> tracks = new ArrayList<Track>(this.trackCountEstimate);
        for (TrackGroup tg : this.trackGroups) {
            tracks.addAll(tg.getTracks());
        }
        return tracks;
    }

    public void clearTracks() {
        Genome currentGenome = GenomeManager.getInstance().getCurrentGenome();
        FeatureTrack geneTrack = currentGenome == null ? null : currentGenome.getGeneTrack();
        for (Track t : this.getTracks()) {
            if (t == geneTrack) continue;
            t.dispose();
        }
        this.trackGroups.clear();
        this.trackCountEstimate = 0;
    }

    public boolean fitTracksToPanel() {
        DataPanelContainer dataPanel = this.getScrollPane().getDataPanel();
        boolean success = true;
        int availableHeight = dataPanel.getVisibleHeight();
        int visibleTrackCount = 0;
        Collection<TrackGroup> groups = dataPanel.getTrackGroups();
        for (TrackGroup group : groups) {
            List<Track> tracks = group.getVisibleTracks();
            for (Track track : tracks) {
                if (!track.isVisible()) continue;
                ++visibleTrackCount;
            }
        }
        if (visibleTrackCount > 0) {
            int groupGapHeight = (groups.size() + 1) * 10;
            double adjustedAvailableHeight = Math.max(1, availableHeight - groupGapHeight);
            double delta = adjustedAvailableHeight / (double)visibleTrackCount;
            if (delta < 1.0) {
                delta = 1.0;
            }
            int iTotal = 0;
            double target = 0.0;
            for (TrackGroup group : groups) {
                List<Track> tracks = group.getVisibleTracks();
                for (Track track : tracks) {
                    int height = (int)((target += delta) - (double)iTotal);
                    track.setHeight(height);
                    iTotal += height;
                }
            }
        }
        return success;
    }

    public void addTrack(Track track) {
        log.debug("Adding track " + track.getName() + " to panel " + this.getName());
        String groupName = this.groupAttribute == null ? null : track.getAttributeValue(this.groupAttribute);
        boolean foundGroup = false;
        for (TrackGroup tg : this.trackGroups) {
            if (this.groupAttribute != null && groupName != null && !tg.getName().equals(groupName)) continue;
            tg.add(track);
            foundGroup = true;
            break;
        }
        if (!foundGroup) {
            TrackGroup newGroup = new TrackGroup(groupName);
            newGroup.add(track);
            if (this.groupAttribute == null) {
                newGroup.setDrawBorder(false);
            }
            this.trackGroups.add(newGroup);
        }
        log.debug("Done adding track to TrackPanel");
        ++this.trackCountEstimate;
    }

    public void addTracks(Collection<? extends Track> tracks) {
        for (Track track : tracks) {
            this.addTrack(track);
        }
    }

    public boolean hasTrack(Track track) {
        return this.trackGroups.stream().anyMatch(tg -> new HashSet<Track>(tg.getTracks()).contains(track));
    }

    public void moveGroup(TrackGroup group, int index) {
        if (index > this.trackGroups.indexOf(group)) {
            --index;
        }
        this.trackGroups.remove(group);
        if (index >= this.trackGroups.size()) {
            this.trackGroups.add(group);
        } else {
            this.trackGroups.add(index, group);
        }
    }

    public void reset() {
        this.groupAttribute = null;
        this.trackGroups.clear();
    }

    public void groupTracksByAttribute(String attribute) {
        this.groupAttribute = attribute;
        List<Track> tracks = this.getTracks();
        this.trackGroups.clear();
        if (attribute == null || attribute.length() == 0) {
            TrackGroup nullGroup = new TrackGroup();
            nullGroup.addAll(tracks);
            nullGroup.setDrawBorder(false);
            this.trackGroups.add(nullGroup);
        } else {
            HashMap<String, TrackGroup> groupMap = new HashMap<String, TrackGroup>();
            for (Track track : tracks) {
                TrackGroup group;
                String attributeValue = track.getAttributeValue(attribute);
                if (attributeValue == null) {
                    attributeValue = "";
                }
                if ((group = (TrackGroup)groupMap.get(attributeValue)) == null) {
                    group = new TrackGroup(attributeValue);
                    groupMap.put(attributeValue, group);
                    this.trackGroups.add(group);
                }
                group.add(track);
            }
        }
    }

    public void sortTracksByAttributes(String[] attributeNames, boolean[] ascending) {
        assert (attributeNames.length == ascending.length);
        for (TrackGroup tg : this.trackGroups) {
            tg.sortByAttributes(attributeNames, ascending);
        }
    }

    public void sortTracksByPosition(List<String> trackIds) {
        for (TrackGroup tg : this.trackGroups) {
            tg.sortByList(trackIds);
        }
    }

    public void sortByRegionsScore(RegionOfInterest region, RegionScoreType type, ReferenceFrame frame, List<String> sortedSamples) {
        this.sortGroupsByRegionScore(this.trackGroups, region, type, frame.getZoom(), frame.getName());
        for (TrackGroup group : this.trackGroups) {
            group.sortGroup(type, sortedSamples);
        }
    }

    private void sortGroupsByRegionScore(List<TrackGroup> groups, RegionOfInterest region, RegionScoreType type, int inzoom, String frameName) {
        if (groups != null && region != null && !groups.isEmpty()) {
            int zoom = Math.max(0, inzoom);
            String chr = region.getChr();
            int start = region.getStart();
            int end = region.getEnd();
            Comparator c = (group1, group2) -> {
                float s1 = group1.getRegionScore(chr, start, end, zoom, type, frameName);
                float s2 = group2.getRegionScore(chr, start, end, zoom, type, frameName);
                return Float.compare(s2, s1);
            };
            Collections.sort(groups, c);
        }
    }

    public boolean replaceTrack(Track oldTrack, Track newTrack) {
        boolean foundTrack = false;
        for (TrackGroup g : this.trackGroups) {
            if (!g.contains(oldTrack)) continue;
            int idx = g.indexOf(oldTrack);
            g.remove(oldTrack);
            idx = Math.min(g.size(), idx);
            if (newTrack != null) {
                g.add(idx, newTrack);
            }
            foundTrack = true;
        }
        return foundTrack;
    }

    public void removeTracks(Collection<? extends Track> tracksToRemove) {
        for (TrackGroup tg : this.trackGroups) {
            tg.removeTracks(tracksToRemove);
        }
    }

    public void removeAllTracks() {
        this.trackGroups.clear();
        this.trackCountEstimate = 0;
    }

    public void moveSelectedTracksTo(Collection<? extends Track> selectedTracks, Track targetTrack, boolean before) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        for (TrackGroup tg : this.trackGroups) {
            if (!tg.moveSelectedTracksTo(selectedTracks, targetTrack, before)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreferredPanelHeight() {
        int height = 0;
        List<TrackGroup> groups = this.getGroups();
        if (groups.size() > 1) {
            height += 10;
        }
        List<TrackGroup> list = groups;
        synchronized (list) {
            for (TrackGroup group : groups) {
                if (group == null || !group.isVisible()) continue;
                if (groups.size() > 1) {
                    height += 10;
                }
                height += group.getHeight();
            }
        }
        return Math.max(20, height);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = this.getPreferredPanelHeight();
        return dim;
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect, boolean batch) {
        int h = rect.height;
        Component[] children = this.getComponents();
        g.translate(this.mainPanel.getNamePanelX(), 0);
        Rectangle nameRect = new Rectangle(children[0].getBounds());
        nameRect.y = rect.y;
        nameRect.height = h;
        if (nameRect.width > 0) {
            Graphics2D nameGraphics = (Graphics2D)g.create();
            nameGraphics.setClip(nameRect);
            ((Paintable)((Object)children[0])).paintOffscreen(nameGraphics, nameRect, batch);
            nameGraphics.dispose();
        }
        int dx = this.mainPanel.getAttributePanelX() - this.mainPanel.getNamePanelX();
        g.translate(dx, 0);
        Rectangle attRect = new Rectangle(0, rect.y, children[1].getWidth(), h);
        if (attRect.width > 0) {
            Graphics2D attGraphics = (Graphics2D)g.create();
            attGraphics.setClip(attRect);
            ((Paintable)((Object)children[1])).paintOffscreen(attGraphics, attRect, batch);
            attGraphics.dispose();
        }
        dx = this.mainPanel.getDataPanelX() - this.mainPanel.getAttributePanelX();
        g.translate(dx, 0);
        Rectangle dataRect = new Rectangle(0, rect.y, this.mainPanel.getDataPanelWidth(), h);
        Graphics2D dataGraphics = (Graphics2D)g.create();
        dataGraphics.setClip(dataRect);
        ((Paintable)((Object)children[2])).paintOffscreen(dataGraphics, dataRect, batch);
        dataGraphics.dispose();
    }

    @Override
    public int getSnapshotHeight(boolean batch) {
        return this.getHeight();
    }

    public void addTrackGroup(TrackGroup trackGroup) {
        this.trackGroups.add(trackGroup);
    }

    public static TrackPanel getParentPanel(Track track) {
        for (TrackPanel panel : IGV.getInstance().getTrackPanels()) {
            for (TrackGroup group : panel.getGroups()) {
                if (!group.contains(track)) continue;
                return panel;
            }
        }
        return null;
    }
}

