/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.feature.genome.GenomeImporter;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.util.FileDialogUtils;

public class GenomeBuilderPane
extends JPanel
implements Serializable {
    private static Logger logger = LogManager.getLogger(GenomeBuilderPane.class);
    private String genomeArchiveLocation;
    private String genomeFilename;
    GenomeImporter importer;
    IGV igv;
    private JPanel panel3;
    private JPanel panel2;
    private JLabel genomeDisplayNameLabel2;
    private JTextField idField;
    private JLabel genomeDisplayNameLabel;
    private JTextField genomeDisplayNameTextField;
    private JLabel fastaFileLabel;
    private JTextField fastaFileTextField;
    private JButton fastaFileButton;
    private JPanel panel1;
    private JLabel cytobandFileLabel;
    private JTextField cytobandFileTextField;
    private JButton cytobandFileButton;
    private JLabel geneAnnotFileLabel;
    private JTextField geneAnnotFileTextField;
    private JButton geneAnnotFileButton;
    private JLabel aliasFileLabel;
    private JTextField chrAliasField;
    private JButton chrAliasButton;
    private JPanel vSpacer2;

    public GenomeBuilderPane() {
        this.initComponents();
        this.importer = new GenomeImporter();
    }

    public void setIgv(IGV igv) {
        this.igv = igv;
    }

    public String getCytobandFileName() {
        String cytobandFile = this.cytobandFileTextField.getText();
        if (cytobandFile != null && cytobandFile.trim().equals("")) {
            cytobandFile = null;
        }
        return cytobandFile;
    }

    public String getGeneAnnotFileName() {
        String refFlatFile = this.geneAnnotFileTextField.getText();
        if (refFlatFile != null && refFlatFile.trim().equals("")) {
            refFlatFile = null;
        }
        return refFlatFile;
    }

    public String getFastaFileName() {
        String fastaFile = this.fastaFileTextField.getText();
        if (fastaFile != null && fastaFile.trim().equals("")) {
            fastaFile = null;
        }
        return fastaFile;
    }

    public String getChrAliasFileName() {
        String chrAliasFile = this.chrAliasField.getText();
        if (chrAliasFile != null && chrAliasFile.trim().equals("")) {
            chrAliasFile = null;
        }
        return chrAliasFile;
    }

    public String getGenomeId() {
        return this.idField.getText();
    }

    public String getGenomeDisplayName() {
        String name = this.genomeDisplayNameTextField.getText();
        name = name != null && name.trim().equals("") ? null : name.trim();
        return name;
    }

    public String getGenomeArchiveLocation() {
        if (this.genomeArchiveLocation != null && this.genomeArchiveLocation.trim().equals("")) {
            this.genomeArchiveLocation = null;
        }
        return this.genomeArchiveLocation;
    }

    public String getArchiveFileName() {
        if (this.genomeFilename == null) {
            this.genomeFilename = this.getGenomeId() + ".genome";
        }
        return this.genomeFilename;
    }

    protected File showGenomeArchiveDirectoryChooser() {
        File archiveName;
        File directory = PreferencesManager.getPreferences().getLastGenomeImportDirectory();
        File file = FileDialogUtils.chooseFile("Save Genome File", directory, archiveName = new File(this.getGenomeId() + ".genome"), FileDialogUtils.SAVE);
        if (file != null) {
            this.genomeFilename = file.getName();
            if (this.genomeFilename != null) {
                if (!this.genomeFilename.endsWith(".genome")) {
                    this.genomeFilename = this.genomeFilename + ".genome";
                    file = new File(file.getParentFile(), this.genomeFilename);
                }
                this.genomeArchiveLocation = file.getParentFile().getAbsolutePath();
            }
        }
        return file;
    }

    public boolean validateSelection() {
        try {
            if (!this.isIdValid().booleanValue()) {
                return false;
            }
            if (!this.isGenomeDisplayNameValid()) {
                this.genomeDisplayNameTextField.setText(null);
                return false;
            }
            if (!this.isFASTAFileValid()) {
                JOptionPane.showMessageDialog(this, "A fasta file is required!");
                return false;
            }
        }
        catch (Exception e) {
            logger.error("Error during Genome Builder validation!", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean isFASTAFileValid() {
        String file = this.fastaFileTextField.getText();
        return file != null && file.trim().length() > 0;
    }

    private Boolean isIdValid() {
        String id = this.getGenomeId();
        if (id == null || id.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Genome ID is required");
            return false;
        }
        Collection<String> inUseIds = GenomeListManager.getInstance().getSelectableGenomeIDs();
        if (inUseIds.contains(id)) {
            JOptionPane.showMessageDialog(this, "The genome ID '" + id + "' is already in use - please select another!");
            return false;
        }
        return true;
    }

    private boolean isGenomeDisplayNameValid() {
        String displayName = this.getGenomeDisplayName();
        if (displayName == null || displayName.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Genome name is required");
            return false;
        }
        Collection<String> inUseDisplayNames = this.getGenomeDisplayNames();
        if (inUseDisplayNames.contains(displayName)) {
            JOptionPane.showMessageDialog(this, "The genome name '" + displayName + "' is already in use - please enter another!");
            return false;
        }
        return true;
    }

    public Collection<String> getGenomeDisplayNames() {
        HashSet<String> displayNames = new HashSet<String>();
        List<GenomeListItem> listItems = GenomeListManager.getInstance().getGenomeListItems();
        for (GenomeListItem genomeListItem : listItems) {
            displayNames.add(genomeListItem.getDisplayableName());
        }
        return displayNames;
    }

    private void initComponents() {
        this.panel3 = new JPanel();
        this.panel2 = new JPanel();
        this.genomeDisplayNameLabel2 = new JLabel();
        this.idField = new JTextField();
        this.genomeDisplayNameLabel = new JLabel();
        this.genomeDisplayNameTextField = new JTextField();
        this.fastaFileLabel = new JLabel();
        this.fastaFileTextField = new JTextField();
        this.fastaFileButton = new JButton();
        this.panel1 = new JPanel();
        this.cytobandFileLabel = new JLabel();
        this.cytobandFileTextField = new JTextField();
        this.cytobandFileButton = new JButton();
        this.geneAnnotFileLabel = new JLabel();
        this.geneAnnotFileTextField = new JTextField();
        this.geneAnnotFileButton = new JButton();
        this.aliasFileLabel = new JLabel();
        this.chrAliasField = new JTextField();
        this.chrAliasButton = new JButton();
        this.vSpacer2 = new JPanel(null);
        this.setFont(new Font("Tahoma", 2, 12));
        this.setMaximumSize(new Dimension(900, 500));
        this.setMinimumSize(new Dimension(400, 200));
        this.setPreferredSize(new Dimension(700, 200));
        this.setLayout(new BorderLayout());
        this.panel3.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.panel3.setLayout(new BoxLayout(this.panel3, 1));
        this.panel2.setBorder(new EmptyBorder(0, 0, 30, 0));
        this.panel2.setLayout(null);
        this.genomeDisplayNameLabel2.setText("Unique identifier");
        this.genomeDisplayNameLabel2.setToolTipText("Unique identifier (e.g. hg18)");
        this.genomeDisplayNameLabel2.setMaximumSize(new Dimension(84, 16));
        this.genomeDisplayNameLabel2.setMinimumSize(new Dimension(84, 16));
        this.genomeDisplayNameLabel2.setPreferredSize(new Dimension(14, 16));
        this.panel2.add(this.genomeDisplayNameLabel2);
        this.genomeDisplayNameLabel2.setBounds(15, 22, 125, 28);
        this.idField.setToolTipText("A uniqe identifier for the genome");
        this.panel2.add(this.idField);
        this.idField.setBounds(145, 22, 548, 29);
        this.genomeDisplayNameLabel.setText("Descriptive name");
        this.panel2.add(this.genomeDisplayNameLabel);
        this.genomeDisplayNameLabel.setBounds(15, 56, 175, 28);
        this.genomeDisplayNameTextField.setToolTipText("The user-readable name of the genome");
        this.genomeDisplayNameTextField.setPreferredSize(new Dimension(400, 28));
        this.genomeDisplayNameTextField.setMinimumSize(new Dimension(25, 28));
        this.panel2.add(this.genomeDisplayNameTextField);
        this.genomeDisplayNameTextField.setBounds(145, 56, 548, 29);
        this.fastaFileLabel.setText("FASTA file");
        this.panel2.add(this.fastaFileLabel);
        this.fastaFileLabel.setBounds(15, 88, 175, 29);
        this.fastaFileTextField.setToolTipText("A FASTA data file");
        this.fastaFileTextField.setPreferredSize(new Dimension(400, 28));
        this.fastaFileTextField.setMinimumSize(new Dimension(25, 28));
        this.panel2.add(this.fastaFileTextField);
        this.fastaFileTextField.setBounds(145, 88, 548, 29);
        this.fastaFileButton.setText("Browse");
        this.fastaFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenomeBuilderPane.this.fastaFileButtonActionPerformed(e);
            }
        });
        this.panel2.add(this.fastaFileButton);
        this.fastaFileButton.setBounds(698, 88, 83, this.fastaFileButton.getPreferredSize().height);
        this.panel3.add(this.panel2);
        this.panel1.setBorder(new TitledBorder(null, "Optional", 4, 0, new Font("Lucida Grande", 1, 13)));
        this.panel1.setLayout(null);
        this.cytobandFileLabel.setText("Cytoband file");
        this.panel1.add(this.cytobandFileLabel);
        this.cytobandFileLabel.setBounds(15, 25, 105, 29);
        this.cytobandFileTextField.setToolTipText("A cytoband data file");
        this.cytobandFileTextField.setPreferredSize(new Dimension(400, 28));
        this.cytobandFileTextField.setMinimumSize(new Dimension(25, 28));
        this.panel1.add(this.cytobandFileTextField);
        this.cytobandFileTextField.setBounds(145, 22, 548, 29);
        this.cytobandFileButton.setText("Browse");
        this.cytobandFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenomeBuilderPane.this.cytobandFileButtonActionPerformed(e);
            }
        });
        this.panel1.add(this.cytobandFileButton);
        this.cytobandFileButton.setBounds(698, 22, 83, this.cytobandFileButton.getPreferredSize().height);
        this.geneAnnotFileLabel.setText("Gene file");
        this.panel1.add(this.geneAnnotFileLabel);
        this.geneAnnotFileLabel.setBounds(15, 56, 84, 29);
        this.geneAnnotFileTextField.setToolTipText("An annotation file");
        this.geneAnnotFileTextField.setPreferredSize(new Dimension(400, 28));
        this.geneAnnotFileTextField.setMinimumSize(new Dimension(25, 28));
        this.panel1.add(this.geneAnnotFileTextField);
        this.geneAnnotFileTextField.setBounds(145, 56, 548, 29);
        this.geneAnnotFileButton.setText("Browse");
        this.geneAnnotFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenomeBuilderPane.this.refFlatFileButtonActionPerformed(e);
            }
        });
        this.panel1.add(this.geneAnnotFileButton);
        this.geneAnnotFileButton.setBounds(698, 56, 83, this.geneAnnotFileButton.getPreferredSize().height);
        this.aliasFileLabel.setText("Alias file");
        this.panel1.add(this.aliasFileLabel);
        this.aliasFileLabel.setBounds(15, 90, 84, 29);
        this.chrAliasField.setPreferredSize(new Dimension(400, 28));
        this.chrAliasField.setMinimumSize(new Dimension(25, 28));
        this.panel1.add(this.chrAliasField);
        this.chrAliasField.setBounds(145, 90, 548, 29);
        this.chrAliasButton.setText("Browse");
        this.chrAliasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenomeBuilderPane.this.chrAliasButtonActionPerformed(e);
            }
        });
        this.panel1.add(this.chrAliasButton);
        this.chrAliasButton.setBounds(698, 90, 83, this.chrAliasButton.getPreferredSize().height);
        this.panel1.add(this.vSpacer2);
        this.vSpacer2.setBounds(6, 124, 84, 20);
        this.panel3.add(this.panel1);
        this.add((Component)this.panel3, "Center");
    }

    private void chrAliasButtonActionPerformed(ActionEvent e) {
        File directory = PreferencesManager.getPreferences().getDefineGenomeInputDirectory();
        File file = FileDialogUtils.chooseFile("Select Chromosome Alias File", directory, FileDialogUtils.LOAD);
        if (file != null) {
            this.chrAliasField.setText(file.getAbsolutePath());
            PreferencesManager.getPreferences().setDefineGenomeInputDirectory(file.getParentFile());
        }
    }

    private void cytobandFileButtonActionPerformed(ActionEvent evt) {
        File directory = PreferencesManager.getPreferences().getDefineGenomeInputDirectory();
        File file = FileDialogUtils.chooseFile("Select Cytoband File", directory, FileDialogUtils.LOAD);
        if (file != null) {
            this.cytobandFileTextField.setText(file.getAbsolutePath());
            PreferencesManager.getPreferences().setDefineGenomeInputDirectory(file.getParentFile());
        }
    }

    private void refFlatFileButtonActionPerformed(ActionEvent evt) {
        File directory = PreferencesManager.getPreferences().getDefineGenomeInputDirectory();
        File file = FileDialogUtils.chooseFile("Select Annotation File", directory, FileDialogUtils.LOAD);
        if (file != null) {
            this.geneAnnotFileTextField.setText(file.getAbsolutePath());
            PreferencesManager.getPreferences().setDefineGenomeInputDirectory(file.getParentFile());
        }
    }

    private void fastaFileButtonActionPerformed(ActionEvent evt) {
        File directory = PreferencesManager.getPreferences().getDefineGenomeInputDirectory();
        File file = FileDialogUtils.chooseFile("Select Fasta File", directory, null, FileDialogUtils.LOAD);
        if (file != null) {
            this.fastaFileTextField.setText(file.getAbsolutePath());
            PreferencesManager.getPreferences().setDefineGenomeInputDirectory(file.getParentFile());
        }
    }
}

