/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.broad.igv.util.HttpUtils;

public class IGVSeekableHTTPStream
extends SeekableStream {
    static Logger log = Logger.getLogger(IGVSeekableHTTPStream.class);
    private long position = 0L;
    private URL url;
    long contentLength = -1L;

    public IGVSeekableHTTPStream(URL url) {
        this.url = url;
    }

    public long position() {
        return this.position;
    }

    public long length() {
        return this.contentLength;
    }

    public long skip(long n) throws IOException {
        long bytesToSkip = this.contentLength < 0L ? n : Math.min(n, this.contentLength - this.position);
        this.position += bytesToSkip;
        return bytesToSkip;
    }

    public boolean eof() throws IOException {
        return this.contentLength > 0L && this.position >= this.contentLength;
    }

    public void seek(long position) {
        this.position = position;
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        for (int attempts = 0; attempts < 3; ++attempts) {
            try {
                return this._read(buffer, offset, len);
            }
            catch (SocketException e) {
                if (attempts < 3) {
                    log.error((Object)"Socket exception. Trying again.", (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        throw new RuntimeException("Reading " + this.url + " failed with unknown error.");
    }

    public int _read(byte[] buffer, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            String stats = "Offset=" + offset + ",len=" + len + ",buflen=" + buffer.length;
            throw new IndexOutOfBoundsException(stats);
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        try (InputStream is = null;){
            if (this.contentLength > 0L && this.position >= this.contentLength) {
                int n2 = -1;
                return n2;
            }
            long endRange = this.position + (long)len - 1L;
            if (this.contentLength > 0L) {
                endRange = Math.min(endRange, this.contentLength);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Trying to read range " + this.position + " to " + endRange));
            }
            is = this.openInputStreamForRange(this.position, endRange);
            while (n < len) {
                int count = is.read(buffer, offset + n, len - n);
                if (count < 0) {
                    if (n != 0) break;
                    int n3 = -1;
                    return n3;
                }
                n += count;
            }
            this.position += (long)n;
            int n4 = n;
            return n4;
        }
    }

    private int handleUnsatisfiableRange(int n) {
        if (n == 0) {
            this.contentLength = this.position;
            return -1;
        }
        this.position += (long)n;
        this.contentLength = this.position;
        return n;
    }

    public void close() throws IOException {
    }

    public int read() throws IOException {
        byte[] tmp = new byte[1];
        this.read(tmp, 0, 1);
        return tmp[0] & 0xFF;
    }

    public InputStream openInputStreamForRange(long start, long end) throws IOException {
        String byteRange = "bytes=" + start + "-" + end;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Range", byteRange);
        HttpURLConnection conn = HttpUtils.getInstance().openConnection(this.url, params);
        try {
            InputStream input = conn.getInputStream();
            return input;
        }
        catch (IOException e) {
            HttpUtils.getInstance().readErrorStream(conn);
            throw e;
        }
    }

    static URL addStartEndQueryString(URL url, long start, long end) throws MalformedURLException {
        String queryString = url.getQuery();
        if (queryString == null) {
            return HttpUtils.createURL(url.toExternalForm() + "?start=" + start + "&end=" + end);
        }
        String newQueryString = queryString + "&start=" + start + "&end" + end;
        return HttpUtils.createURL(url.toExternalForm().replace(queryString, newQueryString));
    }

    public String getSource() {
        return this.url.toExternalForm();
    }

    public static void main(String[] args) throws IOException {
        IGVSeekableHTTPStream stream = new IGVSeekableHTTPStream(HttpUtils.createURL("http://localhost/igv-web/test/data/misc/BufferedReaderTest.bin"));
        byte[] buffer = new byte[1000];
        stream.read(buffer, 0, 1000);
        System.out.println("Done");
    }
}

