/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.blat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.PSLRecord;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.BlatTrack;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.URLUtils;
import org.broad.igv.util.blat.BlatQueryWindow;
import org.broad.igv.util.blat.LegacyBlatClient;

public class BlatClient {
    private static Logger log = Logger.getLogger(BlatClient.class);
    public static final int MINIMUM_BLAT_LENGTH = 20;

    public static List<PSLRecord> blat(String db, String userSeq) throws IOException {
        String serverType = PreferencesManager.getPreferences().get("BLAT_SERVER_TYPE", "");
        String urlpref = PreferencesManager.getPreferences().get("BLAT_URL", "https://genome.ucsc.edu/cgi-bin/hgBlat?userSeq=$SEQUENCE&type=DNA&db=$DB&output=json").trim();
        if (serverType.equalsIgnoreCase("web_blat") || !urlpref.contains("$SEQUENCE")) {
            return LegacyBlatClient.blat(userSeq);
        }
        if ((urlpref = urlpref.replace("$SEQUENCE", userSeq).replace("$DB", db)).startsWith("file://")) {
            urlpref = urlpref.substring("file://".length() + 1);
        }
        String jsonString = null;
        try {
            jsonString = URLUtils.isURL(urlpref) ? HttpUtils.getInstance().getContentsAsJSON(new URL(urlpref)) : RuntimeUtils.exec(urlpref);
            JsonObject obj = new JsonParser().parse(jsonString).getAsJsonObject();
            JsonArray arr = obj.get("blat").getAsJsonArray();
            Iterator iter = arr.iterator();
            ArrayList<String[]> results = new ArrayList<String[]>();
            while (iter.hasNext()) {
                JsonArray row = ((JsonElement)iter.next()).getAsJsonArray();
                String[] tokens = new String[row.size()];
                for (int i = 0; i < row.size(); ++i) {
                    String tmp = row.get(i).getAsString();
                    tokens[i] = StringUtils.stripQuotes(tmp);
                }
                results.add(tokens);
            }
            Genome genome = IGV.hasInstance() ? GenomeManager.getInstance().getCurrentGenome() : null;
            ArrayList<PSLRecord> features = new ArrayList<PSLRecord>(results.size());
            for (String[] tokens : results) {
                features.add(PSLCodec.getPslRecord(tokens, genome));
            }
            return features;
        }
        catch (JsonSyntaxException e) {
            int idx2;
            int idx3;
            String error = jsonString;
            int idx1 = jsonString.indexOf("<BODY");
            if (idx1 > 0 && (idx3 = jsonString.indexOf("</BODY", idx2 = jsonString.indexOf(">", idx1))) > 0) {
                error = jsonString.substring(idx2 + 1, idx3);
            }
            throw new RuntimeException(error);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void doBlatQuery(final String userSeq, final String trackLabel) {
        LongRunningTask.submit(new NamedRunnable(){

            @Override
            public String getName() {
                return "Blat sequence";
            }

            @Override
            public void run() {
                try {
                    Genome genome = IGV.hasInstance() ? GenomeManager.getInstance().getCurrentGenome() : null;
                    String db = genome == null ? "hg19" : genome.getBlatDB();
                    List<PSLRecord> features = BlatClient.blat(db, userSeq);
                    if (features.isEmpty()) {
                        MessageUtils.showMessage("No features found");
                    } else {
                        BlatTrack newTrack = new BlatTrack(userSeq, features, trackLabel);
                        IGV.getInstance().getTrackPanel("FeaturePanel").addTrack(newTrack);
                        IGV.getInstance().repaint();
                        BlatQueryWindow win = new BlatQueryWindow(IGV.getMainFrame(), userSeq, newTrack.getFeatures());
                        win.setVisible(true);
                    }
                }
                catch (Exception e1) {
                    MessageUtils.showErrorMessage("Error running blat", e1);
                }
            }
        });
    }

    public static void doBlatQueryFromRegion(String chr, int start, int end, Strand strand) {
        if (end - start > 8000) {
            MessageUtils.showMessage("BLAT searches are limited to 8kb.  Please try a shorter sequence.");
            return;
        }
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        byte[] seqBytes = genome.getSequence(chr, start, end);
        String userSeq = new String(seqBytes);
        if (strand == Strand.NEGATIVE) {
            userSeq = SequenceTrack.getReverseComplement(userSeq);
        }
        BlatClient.doBlatQuery(userSeq, "Blat");
    }
}

