/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ClickTaskScheduler;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;

public abstract class TrackPanelComponent
extends JPanel {
    private static Logger log = Logger.getLogger(TrackPanelComponent.class);
    List<MouseableRegion> mouseRegions;
    private TrackPanel trackPanel;
    protected ClickTaskScheduler clickScheduler = new ClickTaskScheduler();
    int searchIdx = 0;

    public TrackPanelComponent(TrackPanel trackPanel) {
        this.trackPanel = trackPanel;
        this.setFocusable(true);
        this.mouseRegions = new ArrayList<MouseableRegion>();
        this.initKeyDispatcher();
    }

    private void initKeyDispatcher() {
        AbstractAction delTracksAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackMenuUtils.removeTracksAction(IGV.getInstance().getSelectedTracks());
            }
        };
        if (Globals.isDevelopment()) {
            KeyStroke delKey = KeyStroke.getKeyStroke(127, 0, false);
            KeyStroke backspaceKey = KeyStroke.getKeyStroke(8, 0, false);
            this.getInputMap().put(delKey, "deleteTracks");
            this.getInputMap().put(backspaceKey, "deleteTracks");
            this.getActionMap().put("deleteTracks", delTracksAction);
        }
    }

    public TrackPanel getTrackPanel() {
        if (this.trackPanel == null) {
            this.trackPanel = (TrackPanel)this.getParent();
        }
        return this.trackPanel;
    }

    public String getTrackSetID() {
        return this.getTrackPanel().getName();
    }

    protected void addMousableRegion(MouseableRegion region) {
        this.mouseRegions.add(region);
    }

    protected void removeMousableRegions() {
        this.mouseRegions.clear();
    }

    protected List<MouseableRegion> getMouseRegions() {
        return this.mouseRegions;
    }

    public boolean scrollTo(String trackName) {
        Track t = this.findNextTrackMatching(trackName);
        if (t != null) {
            IGV.getInstance().clearSelections();
            t.setSelected(true);
            if (this.trackPanel.getScrollPane().getVerticalScrollBar().isShowing()) {
                this.trackPanel.getScrollPane().getVerticalScrollBar().setValue(t.getY());
            }
            return true;
        }
        return false;
    }

    private synchronized Track findNextTrackMatching(String trackName) {
        Track t;
        int i;
        List<Track> tracks = this.getAllTracks();
        for (i = this.searchIdx = Math.min(this.searchIdx, tracks.size()); i < tracks.size(); ++i) {
            t = tracks.get(i);
            if (!t.getName().toUpperCase().contains(trackName.toUpperCase())) continue;
            this.searchIdx = i + 1;
            return t;
        }
        for (i = 0; i < this.searchIdx; ++i) {
            t = tracks.get(i);
            if (!t.getName().toUpperCase().contains(trackName.toUpperCase())) continue;
            this.searchIdx = i + 1;
            return t;
        }
        return null;
    }

    public String getPopupMenuTitle(int x, int y) {
        Collection<Track> tracks = this.getSelectedTracks();
        Object popupTitle = tracks.size() == 1 ? tracks.iterator().next().getName() : "Total Tracks Selected: " + tracks.size();
        return popupTitle;
    }

    protected Collection<Track> getSelectedTracks() {
        return IGV.getInstance().getSelectedTracks();
    }

    public List<Track> getAllTracks() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getTracks();
    }

    protected void openPopupMenu(TrackClickEvent te) {
        this.openPopupMenu(te, null);
    }

    protected void openPopupMenu(TrackClickEvent te, List<Component> extraItems) {
        MouseEvent e = te.getMouseEvent();
        Collection<Track> selectedTracks = this.getSelectedTracks();
        if (selectedTracks.size() == 0) {
            return;
        }
        JPopupMenu menu = null;
        if (selectedTracks.size() == 1) {
            Track track = selectedTracks.iterator().next();
            menu = track.getPopupMenu(te);
        }
        if (menu == null) {
            String title = this.getPopupMenuTitle(e.getX(), e.getY());
            menu = TrackMenuUtils.getPopupMenu(selectedTracks, title, te);
        }
        if (extraItems != null) {
            menu.addSeparator();
            for (Component item : extraItems) {
                menu.add(item);
            }
        }
        if (((IGVPopupMenu)menu).includeStandardItems()) {
            TrackMenuUtils.addPluginItems(menu, selectedTracks, te);
            menu.addSeparator();
            JMenuItem savePng = new JMenuItem("Save PNG image...");
            savePng.addActionListener(e1 -> this.saveImage("png"));
            menu.add(savePng);
            JMenuItem saveSvg = new JMenuItem("Save SVG image...");
            saveSvg.addActionListener(e1 -> this.saveImage("svg"));
            menu.add(saveSvg);
            ReferenceFrame frame = FrameManager.getDefaultFrame();
            JMenuItem exportFeats = TrackMenuUtils.getExportFeatures(selectedTracks, frame);
            if (exportFeats != null) {
                menu.add(exportFeats);
            }
            JMenuItem exportNames = new JMenuItem("Export track names...");
            exportNames.addActionListener(e12 -> TrackMenuUtils.exportTrackNames(selectedTracks));
            menu.add(exportNames);
            menu.addSeparator();
            menu.add(TrackMenuUtils.getRemoveMenuItem(selectedTracks));
        }
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void toggleTrackSelections(MouseEvent e) {
        for (MouseableRegion mouseRegion : this.mouseRegions) {
            if (!mouseRegion.containsPoint(e.getX(), e.getY())) continue;
            IGV.getInstance().toggleTrackSelections(mouseRegion.getTracks());
            return;
        }
    }

    protected void clearTrackSelections() {
        IGV.getInstance().clearSelections();
        IGV.getMainFrame().repaint();
    }

    protected void selectTracks(MouseEvent e) {
        for (MouseableRegion mouseRegion : this.mouseRegions) {
            if (!mouseRegion.containsPoint(e.getX(), e.getY())) continue;
            IGV.getInstance().setTrackSelections(mouseRegion.getTracks());
            return;
        }
    }

    protected boolean isTrackSelected(MouseEvent e) {
        for (MouseableRegion mouseRegion : this.mouseRegions) {
            if (!mouseRegion.containsPoint(e.getX(), e.getY())) continue;
            for (Track t : mouseRegion.getTracks()) {
                if (!t.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public void saveImage(String extension) {
        IGV.getInstance().saveImage((Component)((Object)this.getTrackPanel().getScrollPane()), "igv_panel", extension);
    }
}

