/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.event.AlignmentTrackEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.lists.GeneList;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.HaplotypeUtils;
import org.broad.igv.sam.InsertionManager;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.sam.InsertionSelectionEvent;
import org.broad.igv.sam.LinkedAlignment;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PackedAlignments;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.Row;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.sam.SpliceJunctionTrack;
import org.broad.igv.sashimi.SashimiPlot;
import org.broad.igv.session.Persistable;
import org.broad.igv.session.Session;
import org.broad.igv.tools.PFMExporter;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.InsertSizeSettingsDialog;
import org.broad.igv.ui.color.ColorTable;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.Pair;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.blat.BlatClient;
import org.broad.igv.util.collections.CollUtils;
import org.broad.igv.util.extview.ExtendViewClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AlignmentTrack
extends AbstractTrack
implements IGVEventObserver {
    private static Logger log = Logger.getLogger(AlignmentTrack.class);
    private static final int GROUP_LABEL_HEIGHT = 10;
    private static final int GROUP_MARGIN = 5;
    private static final int TOP_MARGIN = 20;
    private static final int DS_MARGIN_0 = 2;
    private static final int DOWNAMPLED_ROW_HEIGHT = 3;
    private static final int INSERTION_ROW_HEIGHT = 9;
    private static final int DS_MARGIN_2 = 5;
    private static int nClusters = 2;
    private static final Map<BisulfiteContext, String> bisulfiteContextToPubString = new HashMap<BisulfiteContext, String>();
    private static final Map<BisulfiteContext, Pair<byte[], byte[]>> bisulfiteContextToContextString;
    private AlignmentDataManager dataManager;
    private SequenceTrack sequenceTrack;
    private CoverageTrack coverageTrack;
    private SpliceJunctionTrack spliceJunctionTrack;
    private final Genome genome;
    private ExperimentType experimentType;
    private final AlignmentRenderer renderer;
    RenderOptions renderOptions;
    private boolean removed = false;
    private RenderRollback renderRollback;
    private boolean showGroupLine;
    private Map<ReferenceFrame, List<InsertionInterval>> insertionIntervalsMap;
    private int expandedHeight = 14;
    private final int collapsedHeight = 9;
    private final int maxSquishedHeight = 5;
    private int squishedHeight = 5;
    private final int minHeight = 50;
    private Rectangle alignmentsRect;
    private Rectangle downsampleRect;
    private Rectangle insertionRect;
    private ColorTable readNamePalette;
    private JComponent dataPanel;
    protected final HashMap<String, Color> selectedReadNames = new HashMap();

    public static boolean isBisulfiteColorType(ColorOption o) {
        return o.equals((Object)ColorOption.BISULFITE) || o.equals((Object)ColorOption.NOMESEQ);
    }

    private static String getBisulfiteContextPubStr(BisulfiteContext item) {
        return bisulfiteContextToPubString.get((Object)item);
    }

    public static byte[] getBisulfiteContextPreContext(BisulfiteContext item) {
        Pair<byte[], byte[]> pair = bisulfiteContextToContextString.get((Object)item);
        return pair.getFirst();
    }

    public static byte[] getBisulfiteContextPostContext(BisulfiteContext item) {
        Pair<byte[], byte[]> pair = bisulfiteContextToContextString.get((Object)item);
        return pair.getSecond();
    }

    public AlignmentTrack(ResourceLocator locator, AlignmentDataManager dataManager, Genome genome) {
        super(locator);
        this.dataManager = dataManager;
        this.genome = genome;
        this.renderer = new AlignmentRenderer(this);
        this.renderOptions = new RenderOptions();
        dataManager.setAlignmentTrack(this);
        dataManager.subscribe(this);
        IGVPreferences prefs = this.getPreferences();
        this.minimumHeight = 50;
        this.maximumHeight = Integer.MAX_VALUE;
        this.showGroupLine = prefs.getAsBoolean("SAM.SHOW_GROUP_SEPARATOR");
        try {
            this.setDisplayMode(Track.DisplayMode.valueOf(prefs.get("SAM.DISPLAY_MODE").toUpperCase()));
        }
        catch (Exception e) {
            this.setDisplayMode(Track.DisplayMode.EXPANDED);
        }
        if (prefs.getAsBoolean("SAM.SHOW_REF_SEQ")) {
            this.sequenceTrack = new SequenceTrack("Reference sequence");
            this.sequenceTrack.setHeight(14);
        }
        if (this.renderOptions.colorOption == ColorOption.BISULFITE) {
            this.setExperimentType(ExperimentType.BISULFITE);
        }
        this.readNamePalette = new PaletteColorTable(ColorUtilities.getDefaultPalette());
        this.insertionIntervalsMap = Collections.synchronizedMap(new HashMap());
        IGVEventBus.getInstance().subscribe(FrameManager.ChangeEvent.class, this);
        IGVEventBus.getInstance().subscribe(AlignmentTrackEvent.class, this);
    }

    public void init() {
        ExperimentType type;
        if (this.experimentType == null && (type = this.dataManager.inferType()) != null) {
            this.setExperimentType(type);
        }
    }

    @Override
    public void receiveEvent(Object event) {
        if (event instanceof FrameManager.ChangeEvent) {
            Map<ReferenceFrame, List<InsertionInterval>> newMap = Collections.synchronizedMap(new HashMap());
            for (ReferenceFrame frame : ((FrameManager.ChangeEvent)event).getFrames()) {
                if (!this.insertionIntervalsMap.containsKey(frame)) continue;
                newMap.put(frame, this.insertionIntervalsMap.get(frame));
            }
            this.insertionIntervalsMap = newMap;
        } else if (event instanceof AlignmentTrackEvent) {
            AlignmentTrackEvent e = (AlignmentTrackEvent)event;
            AlignmentTrackEvent.Type eventType = e.getType();
            switch (eventType) {
                case ALLELE_THRESHOLD: {
                    this.dataManager.alleleThresholdChanged();
                    break;
                }
                case RELOAD: {
                    this.clearCaches();
                    this.repaint();
                }
                case REFRESH: {
                    this.renderOptions.repaintDefaults(this.getExperimentType());
                    this.repaint();
                }
            }
        }
    }

    void setExperimentType(ExperimentType type) {
        if (type != this.experimentType) {
            boolean showAlignments;
            boolean showCoverage;
            this.experimentType = type;
            this.renderOptions.repaintDefaults(type);
            boolean showJunction = AlignmentTrack.getPreferences(type).getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
            if (showJunction != this.spliceJunctionTrack.isVisible()) {
                this.spliceJunctionTrack.setVisible(showJunction);
                IGV.getInstance().revalidateTrackPanels();
            }
            if ((showCoverage = AlignmentTrack.getPreferences(type).getAsBoolean("SAM.SHOW_COV_TRACK")) != this.coverageTrack.isVisible()) {
                this.coverageTrack.setVisible(showCoverage);
                IGV.getInstance().revalidateTrackPanels();
            }
            if ((showAlignments = AlignmentTrack.getPreferences(type).getAsBoolean("SAM.SHOW_ALIGNMENT_TRACK")) != this.isVisible()) {
                this.setVisible(showAlignments);
                IGV.getInstance().revalidateTrackPanels();
            }
        }
    }

    ExperimentType getExperimentType() {
        return this.experimentType;
    }

    public AlignmentDataManager getDataManager() {
        return this.dataManager;
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public void setSpliceJunctionTrack(SpliceJunctionTrack spliceJunctionTrack) {
        this.spliceJunctionTrack = spliceJunctionTrack;
    }

    public SpliceJunctionTrack getSpliceJunctionTrack() {
        return this.spliceJunctionTrack;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        return new PopupMenu(te);
    }

    @Override
    public void setHeight(int preferredHeight) {
        super.setHeight(preferredHeight);
        this.minimumHeight = preferredHeight;
    }

    @Override
    public int getHeight() {
        if (this.dataPanel != null && this.dataPanel instanceof DataPanel && ((DataPanel)this.dataPanel).getFrame().getScale() > this.dataManager.getMinVisibleScale()) {
            return this.minimumHeight;
        }
        int nGroups = this.dataManager.getMaxGroupCount();
        int h = Math.max(50, this.getNLevels() * this.getRowHeight() + nGroups * 5 + 20 + 2 + 3 + 5);
        h += 11;
        h = Math.min(this.maximumHeight, h);
        return h;
    }

    private int getRowHeight() {
        if (this.getDisplayMode() == Track.DisplayMode.EXPANDED) {
            return this.expandedHeight;
        }
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            return 9;
        }
        return this.squishedHeight;
    }

    private int getNLevels() {
        return this.dataManager.getNLevels();
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        if (frame.getChrName().equals("All") || frame.getScale() > this.dataManager.getMinVisibleScale()) {
            return true;
        }
        List<InsertionInterval> insertionIntervals = this.getInsertionIntervals(frame);
        insertionIntervals.clear();
        return this.dataManager.isLoaded(frame);
    }

    @Override
    public void load(ReferenceFrame referenceFrame) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading - thread: " + Thread.currentThread().getName()));
        }
        this.dataManager.load(referenceFrame, this.renderOptions, true);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int seqHeight;
        int viewWindowSize = context.getReferenceFrame().getCurrentRange().getLength();
        if ((double)viewWindowSize > this.dataManager.getVisibilityWindow()) {
            Rectangle visibleRect = context.getVisibleRect().intersection(rect);
            Graphics2D g2 = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Zoom in to see alignments.", visibleRect, g2);
            return;
        }
        context.getGraphics2D("LABEL").setFont(FontManager.getFont(10));
        this.dataPanel = context.getPanel();
        int n = seqHeight = this.sequenceTrack == null ? 0 : this.sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            this.sequenceTrack.render(context, seqRect);
        }
        rect.y += 2;
        this.downsampleRect = new Rectangle(rect);
        this.downsampleRect.height = 3;
        this.renderDownsampledIntervals(context, this.downsampleRect);
        if (this.renderOptions.isDrawInsertionIntervals()) {
            this.insertionRect = new Rectangle(rect);
            this.insertionRect.y += 5;
            this.insertionRect.height = 9;
            this.renderInsertionIntervals(context, this.insertionRect);
            rect.y = this.insertionRect.y + this.insertionRect.height;
        }
        this.alignmentsRect = new Rectangle(rect);
        this.alignmentsRect.y += 2;
        this.alignmentsRect.height -= this.alignmentsRect.y - rect.y;
        this.renderAlignments(context, this.alignmentsRect);
    }

    private void renderDownsampledIntervals(RenderContext context, Rectangle downsampleRect) {
        if (!context.getVisibleRect().intersects(downsampleRect)) {
            return;
        }
        AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(context.getReferenceFrame());
        if (loadedInterval == null) {
            return;
        }
        Graphics2D g = context.getGraphic2DForColor(Color.black);
        List<DownsampledInterval> intervals = loadedInterval.getDownsampledIntervals();
        for (DownsampledInterval interval : intervals) {
            double scale = context.getScale();
            double origin = context.getOrigin();
            int x0 = (int)(((double)interval.getStart() - origin) / scale);
            int x1 = (int)(((double)interval.getEnd() - origin) / scale);
            int w = Math.max(1, x1 - x0);
            if (w > 5) {
                --w;
            }
            g.fillRect(x0, downsampleRect.y, w, downsampleRect.height);
        }
    }

    private void renderAlignments(RenderContext context, Rectangle inputRect) {
        double h;
        Map<String, PEStats> peStats;
        AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(context.getReferenceFrame(), true);
        if (loadedInterval == null) {
            return;
        }
        AlignmentCounts alignmentCounts = loadedInterval.getCounts();
        RenderOptions renderOptions = PreferencesManager.forceDefaults ? new RenderOptions() : this.renderOptions;
        PackedAlignments groups = this.dataManager.getGroups(loadedInterval, renderOptions);
        if (groups == null) {
            return;
        }
        if (renderOptions.colorOption == null && this.dataManager.hasYCTags()) {
            renderOptions.colorOption = ColorOption.YC_TAG;
        }
        if ((peStats = this.dataManager.getPEStats()) != null) {
            renderOptions.peStats = peStats;
        }
        Rectangle visibleRect = context.getVisibleRect();
        this.maximumHeight = Integer.MAX_VALUE;
        double y = inputRect.getY();
        if (this.getDisplayMode() == Track.DisplayMode.EXPANDED) {
            h = this.expandedHeight;
        } else if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            h = 9.0;
        } else {
            int visHeight = visibleRect.height;
            int depth = this.dataManager.getNLevels();
            this.squishedHeight = depth == 0 ? Math.min(5, Math.max(1, this.expandedHeight)) : Math.min(5, Math.max(1, Math.min(this.expandedHeight, visHeight / depth)));
            h = this.squishedHeight;
        }
        Graphics2D groupBorderGraphics = context.getGraphic2DForColor(AlignmentRenderer.GROUP_DIVIDER_COLOR);
        int nGroups = groups.size();
        int groupNumber = 0;
        GroupOption groupOption = renderOptions.getGroupByOption();
        for (Map.Entry entry : groups.entrySet()) {
            ++groupNumber;
            double yGroup = y;
            List rows = (List)entry.getValue();
            for (Row row : rows) {
                if (visibleRect != null && y > visibleRect.getMaxY()) break;
                assert (visibleRect != null);
                if (y + h > visibleRect.getY()) {
                    Rectangle rowRectangle = new Rectangle(inputRect.x, (int)y, inputRect.width, (int)h);
                    this.renderer.renderAlignments(row.alignments, alignmentCounts, context, rowRectangle, renderOptions);
                    row.y = y;
                    row.h = h;
                }
                y += h;
            }
            if (groupOption != GroupOption.NONE) {
                double groupHeight;
                if (this.showGroupLine && groupNumber < nGroups) {
                    int borderY = (int)y + 2;
                    GraphicUtils.drawDottedDashLine(groupBorderGraphics, inputRect.x, borderY, inputRect.width, borderY);
                }
                if ((groupHeight = (double)rows.size() * h) > 12.0) {
                    String groupName = (String)entry.getKey();
                    Graphics2D g = context.getGraphics2D("LABEL");
                    FontMetrics fm = g.getFontMetrics();
                    Rectangle2D stringBouds = fm.getStringBounds(groupName, g);
                    Rectangle rect = new Rectangle(inputRect.x, (int)yGroup, (int)stringBouds.getWidth() + 10, (int)stringBouds.getHeight());
                    GraphicUtils.drawVerticallyCenteredText(groupName, 5, rect, g, false, true);
                }
            }
            y += 5.0;
        }
        int bottom = inputRect.y + inputRect.height;
        groupBorderGraphics.drawLine(inputRect.x, bottom, inputRect.width, bottom);
    }

    private List<InsertionInterval> getInsertionIntervals(ReferenceFrame frame) {
        List insertionIntervals = this.insertionIntervalsMap.computeIfAbsent(frame, k -> new ArrayList());
        return insertionIntervals;
    }

    private void renderInsertionIntervals(RenderContext context, Rectangle rect) {
        if (!context.getVisibleRect().intersects(rect)) {
            return;
        }
        List<InsertionMarker> intervals = context.getInsertionMarkers();
        if (intervals == null) {
            return;
        }
        InsertionMarker selected = InsertionManager.getInstance().getSelectedInsertion(context.getChr());
        int w = (int)(1.41 * (double)rect.height / 2.0);
        boolean hideSmallIndex = this.getPreferences().getAsBoolean("SAM.HIDE_SMALL_INDEL");
        int smallIndelThreshold = this.getPreferences().getAsInt("SAM.SMALL_INDEL_BP_THRESHOLD");
        List<InsertionInterval> insertionIntervals = this.getInsertionIntervals(context.getReferenceFrame());
        insertionIntervals.clear();
        for (InsertionMarker insertionMarker : intervals) {
            if (hideSmallIndex && insertionMarker.size < smallIndelThreshold) continue;
            double scale = context.getScale();
            double origin = context.getOrigin();
            int midpoint = (int)(((double)insertionMarker.position - origin) / scale);
            int x0 = midpoint - w;
            int x1 = midpoint + w;
            Rectangle iRect = new Rectangle(x0 + context.translateX, rect.y, 2 * w, rect.height);
            insertionIntervals.add(new InsertionInterval(iRect, insertionMarker));
            Color c = selected != null && selected.position == insertionMarker.position ? new Color(200, 0, 0, 80) : AlignmentRenderer.purple;
            Graphics2D g = context.getGraphic2DForColor(c);
            g.fillPolygon(new Polygon(new int[]{x0, x1, midpoint}, new int[]{rect.y, rect.y, rect.y + rect.height}, 3));
        }
    }

    public void renderExpandedInsertion(InsertionMarker insertionMarker, RenderContext context, Rectangle inputRect) {
        double h;
        boolean leaveMargin = this.getDisplayMode() != Track.DisplayMode.SQUISHED;
        Graphics2D g = context.getGraphic2DForColor(Color.red);
        Rectangle iRect = new Rectangle(inputRect.x, this.insertionRect.y, inputRect.width, this.insertionRect.height);
        g.fill(iRect);
        List<InsertionInterval> insertionIntervals = this.getInsertionIntervals(context.getReferenceFrame());
        iRect.x += context.translateX;
        insertionIntervals.add(new InsertionInterval(iRect, insertionMarker));
        inputRect.y += 21;
        AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(context.getReferenceFrame(), true);
        PackedAlignments groups = this.dataManager.getGroups(loadedInterval, this.renderOptions);
        if (groups == null) {
            return;
        }
        Rectangle visibleRect = context.getVisibleRect();
        this.maximumHeight = Integer.MAX_VALUE;
        double y = inputRect.getY() - 3.0;
        if (this.getDisplayMode() == Track.DisplayMode.EXPANDED) {
            h = this.expandedHeight;
        } else if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            h = 9.0;
        } else {
            int visHeight = visibleRect.height;
            int depth = this.dataManager.getNLevels();
            this.squishedHeight = depth == 0 ? Math.min(5, Math.max(1, this.expandedHeight)) : Math.min(5, Math.max(1, Math.min(this.expandedHeight, visHeight / depth)));
            h = this.squishedHeight;
        }
        for (Map.Entry entry : groups.entrySet()) {
            List rows = (List)entry.getValue();
            for (Row row : rows) {
                if (visibleRect != null && y > visibleRect.getMaxY()) {
                    return;
                }
                assert (visibleRect != null);
                if (y + h > visibleRect.getY()) {
                    Rectangle rowRectangle = new Rectangle(inputRect.x, (int)y, inputRect.width, (int)h);
                    this.renderer.renderExpandedInsertion(insertionMarker, row.alignments, context, rowRectangle, leaveMargin);
                    row.y = y;
                    row.h = h;
                }
                y += h;
            }
            y += 5.0;
        }
    }

    private InsertionInterval getInsertionInterval(ReferenceFrame frame, int x, int y) {
        List<InsertionInterval> insertionIntervals = this.getInsertionIntervals(frame);
        for (InsertionInterval i : insertionIntervals) {
            if (!i.rect.contains(x, y)) continue;
            return i;
        }
        return null;
    }

    public boolean sortRows(SortOption option, ReferenceFrame referenceFrame, double location, String tag) {
        return this.dataManager.sortRows(option, referenceFrame, location, tag);
    }

    private static void sortAlignmentTracks(SortOption option, String tag) {
        IGV.getInstance().sortAlignmentTracks(option, tag);
        Collection<IGVPreferences> allPrefs = PreferencesManager.getAllPreferences();
        for (IGVPreferences prefs : allPrefs) {
            prefs.put("SAM.SORT_OPTION", option.toString());
            prefs.put("SAM.SORT_BY_TAG", tag);
        }
    }

    public void groupAlignments(GroupOption option, String tag, Range pos) {
        if (option == GroupOption.TAG && tag != null) {
            this.renderOptions.setGroupByTag(tag);
        }
        if (option == GroupOption.BASE_AT_POS && pos != null) {
            this.renderOptions.setGroupByPos(pos);
        }
        this.renderOptions.setGroupByOption(option);
        this.dataManager.packAlignments(this.renderOptions);
    }

    public void setBisulfiteContext(BisulfiteContext option) {
        this.renderOptions.bisulfiteContext = option;
        this.getPreferences().put("SAM.BISULFITE_CONTEXT", option.toString());
    }

    public void setColorOption(ColorOption option) {
        this.renderOptions.setColorOption(option);
    }

    public void setColorByTag(String tag) {
        this.renderOptions.setColorByTag(tag);
        AlignmentTrack.getPreferences(this.experimentType).put("SAM.COLOR_BY_TAG", tag);
    }

    public void packAlignments() {
        this.dataManager.packAlignments(this.renderOptions);
    }

    private void copyToClipboard(TrackClickEvent e, Alignment alignment, double location, int mouseX) {
        if (alignment != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(alignment.getClipboardString(location, mouseX).replace("<b>", "").replace("</b>", "").replace("<br>", "\n").replace("<br/>", "\n").replace("<hr>", "\n------------------\n").replace("<hr/>", "\n------------------\n"));
            buf.append("\n");
            buf.append("Alignment start position = ").append(alignment.getChr()).append(":").append(alignment.getAlignmentStart() + 1);
            buf.append("\n");
            buf.append(alignment.getReadSequence());
            StringSelection stringSelection = new StringSelection(buf.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    private void gotoMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.setSelected(alignment);
                String chr = mate.getChr();
                int start = mate.start - 1;
                double range = te.getFrame().getEnd() - te.getFrame().getOrigin();
                int newStart = (int)Math.max(0.0, (double)(start + (alignment.getEnd() - alignment.getStart()) / 2) - range / 2.0);
                int newEnd = newStart + (int)range;
                te.getFrame().jumpTo(chr, newStart, newEnd);
                te.getFrame().recordHistory();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    private void splitScreenMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                List<Object> loci;
                this.setSelected(alignment);
                String mateChr = mate.getChr();
                int mateStart = mate.start - 1;
                ReferenceFrame frame = te.getFrame();
                String locus1 = frame.getFormattedLocusString();
                Range range = frame.getCurrentRange();
                int length = range.getLength();
                int s2 = Math.max(0, mateStart - length / 2);
                int e2 = s2 + length;
                String startStr = String.valueOf(s2);
                String endStr = String.valueOf(e2);
                String mateLocus = mateChr + ":" + startStr + "-" + endStr;
                Session currentSession = IGV.getInstance().getSession();
                if (FrameManager.isGeneListMode()) {
                    loci = new ArrayList(FrameManager.getFrames().size());
                    for (ReferenceFrame referenceFrame : FrameManager.getFrames()) {
                        String string = referenceFrame.getName();
                        if (Locus.fromString(string) != null) {
                            loci.add(string);
                            continue;
                        }
                        loci.add(referenceFrame.getFormattedLocusString());
                    }
                    loci.add(mateLocus);
                } else {
                    loci = Arrays.asList(locus1, mateLocus);
                }
                StringBuilder listName = new StringBuilder();
                for (String string : loci) {
                    listName.append(string + "   ");
                }
                GeneList geneList = new GeneList(listName.toString(), loci, false);
                currentSession.setCurrentGeneList(geneList);
                Comparator comparator = (n0, n1) -> {
                    ReferenceFrame f0 = FrameManager.getFrame(n0);
                    ReferenceFrame f1 = FrameManager.getFrame(n1);
                    String chr0 = f0 == null ? "" : f0.getChrName();
                    String chr1 = f1 == null ? "" : f1.getChrName();
                    int s0 = f0 == null ? 0 : f0.getCurrentRange().getStart();
                    int s1 = f1 == null ? 0 : f1.getCurrentRange().getStart();
                    int chrComp = ChromosomeNameComparator.get().compare(chr0, chr1);
                    if (chrComp != 0) {
                        return chrComp;
                    }
                    return s0 - s1;
                };
                currentSession.sortGeneList(comparator);
                IGV.getInstance().resetFrames();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        if (this.downsampleRect != null && mouseY > this.downsampleRect.y && mouseY <= this.downsampleRect.y + this.downsampleRect.height) {
            AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(frame);
            if (loadedInterval == null) {
                return null;
            }
            List<DownsampledInterval> intervals = loadedInterval.getDownsampledIntervals();
            DownsampledInterval interval = FeatureUtils.getFeatureAt(position, 0, intervals);
            if (interval != null) {
                return interval.getValueString();
            }
            return null;
        }
        InsertionInterval insertionInterval = this.getInsertionInterval(frame, mouseX, mouseY);
        if (insertionInterval != null) {
            return "Insertions (" + insertionInterval.insertionMarker.size + " bases)";
        }
        Alignment feature = this.getAlignmentAt(position, mouseY, frame);
        if (feature != null) {
            return feature.getAlignmentValueString(position, mouseX, this.renderOptions);
        }
        return null;
    }

    private Alignment getAlignment(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        ReferenceFrame frame = te.getFrame();
        if (frame == null) {
            return null;
        }
        double location = frame.getChromosomePosition(e.getX());
        return this.getAlignmentAt(location, e.getY(), frame);
    }

    private Alignment getAlignmentAt(double position, int y, ReferenceFrame frame) {
        if (this.alignmentsRect == null || this.dataManager == null) {
            return null;
        }
        PackedAlignments groups = this.dataManager.getGroupedAlignmentsContaining(position, frame);
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        for (List rows : groups.values()) {
            for (Row row : rows) {
                if (!((double)y >= row.y) || !((double)y <= row.y + row.h)) continue;
                List<Alignment> features = row.alignments;
                int buffer = 0;
                return FeatureUtils.getFeatureAt(position, buffer, features);
            }
        }
        return null;
    }

    private Alignment getSpecficAlignment(TrackClickEvent te) {
        Alignment alignment = this.getAlignment(te);
        if (alignment != null) {
            ReferenceFrame frame = te.getFrame();
            MouseEvent e = te.getMouseEvent();
            double location = frame.getChromosomePosition(e.getX());
            if (alignment instanceof LinkedAlignment) {
                Alignment sa = null;
                for (Alignment a : ((LinkedAlignment)alignment).alignments) {
                    if (!a.contains(location) || sa != null && a.getAlignmentEnd() - a.getAlignmentStart() >= sa.getAlignmentEnd() - sa.getAlignmentStart()) continue;
                    sa = a;
                }
                alignment = sa;
            } else if (alignment instanceof PairedAlignment) {
                Alignment sa = null;
                if (((PairedAlignment)alignment).firstAlignment.contains(location)) {
                    sa = ((PairedAlignment)alignment).firstAlignment;
                } else if (((PairedAlignment)alignment).secondAlignment.contains(location)) {
                    sa = ((PairedAlignment)alignment).secondAlignment;
                }
                alignment = sa;
            }
        }
        return alignment;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        ReferenceFrame frame;
        MouseEvent e = te.getMouseEvent();
        if ((Globals.IS_MAC && e.isMetaDown() || !Globals.IS_MAC && e.isControlDown()) && (frame = te.getFrame()) != null) {
            this.selectAlignment(e, frame);
            IGV.getInstance().repaint(this);
            return true;
        }
        InsertionInterval insertionInterval = this.getInsertionInterval(te.getFrame(), te.getMouseEvent().getX(), te.getMouseEvent().getY());
        if (insertionInterval != null) {
            String chrName = te.getFrame().getChrName();
            InsertionMarker currentSelection = InsertionManager.getInstance().getSelectedInsertion(chrName);
            if (currentSelection != null && currentSelection.position == insertionInterval.insertionMarker.position) {
                InsertionManager.getInstance().clearSelected();
            } else {
                InsertionManager.getInstance().setSelected(chrName, insertionInterval.insertionMarker.position);
            }
            IGVEventBus.getInstance().post(new InsertionSelectionEvent(insertionInterval.insertionMarker));
            return true;
        }
        if (IGV.getInstance().isShowDetailsOnClick()) {
            this.openTooltipWindow(te);
            return true;
        }
        return false;
    }

    private void selectAlignment(MouseEvent e, ReferenceFrame frame) {
        double location = frame.getChromosomePosition(e.getX());
        Alignment alignment = this.getAlignmentAt(location, e.getY(), frame);
        if (alignment != null) {
            if (this.selectedReadNames.containsKey(alignment.getReadName())) {
                this.selectedReadNames.remove(alignment.getReadName());
            } else {
                this.setSelected(alignment);
            }
        }
    }

    private void setSelected(Alignment alignment) {
        Color c = this.readNamePalette.get(alignment.getReadName());
        this.selectedReadNames.put(alignment.getReadName(), c);
    }

    private void clearCaches() {
        if (this.dataManager != null) {
            this.dataManager.clear();
        }
        if (this.spliceJunctionTrack != null) {
            this.spliceJunctionTrack.clear();
        }
    }

    public void setViewAsPairs(boolean vAP) {
        if (vAP && this.renderOptions.groupByOption == GroupOption.STRAND) {
            boolean ungroup = MessageUtils.confirm("\"View as pairs\" is incompatible with \"Group by strand\". Ungroup?");
            if (ungroup) {
                this.renderOptions.setGroupByOption(null);
            } else {
                return;
            }
        }
        this.dataManager.setViewAsPairs(vAP, this.renderOptions);
        this.repaint();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && !this.removed;
    }

    IGVPreferences getPreferences() {
        return AlignmentTrack.getPreferences(this.experimentType);
    }

    private static IGVPreferences getPreferences(ExperimentType type) {
        try {
            if (Globals.VERSION.contains("2.4")) {
                return PreferencesManager.getPreferences("NULL");
            }
            String prefKey = "NULL";
            if (type == ExperimentType.THIRD_GEN) {
                prefKey = "THIRD_GEN";
            } else if (type == ExperimentType.RNA) {
                prefKey = "RNA";
            }
            return PreferencesManager.getPreferences(prefKey);
        }
        catch (NullPointerException e) {
            String prefKey = "NULL";
            if (type == ExperimentType.THIRD_GEN) {
                prefKey = "THIRD_GEN";
            } else if (type == ExperimentType.RNA) {
                prefKey = "RNA";
            }
            return PreferencesManager.getPreferences(prefKey);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.dataManager != null) {
            this.dataManager.unsubscribe(this);
        }
        this.dataManager = null;
        this.removed = true;
        this.setVisible(false);
    }

    private boolean isLinkedReads() {
        return this.renderOptions != null && this.renderOptions.isLinkedReads();
    }

    private void setLinkedReadView(boolean linkedReads, String tag) {
        if (!linkedReads || this.isLinkedReadView()) {
            this.undoLinkedReadView();
        }
        this.renderOptions.setLinkedReads(linkedReads);
        if (linkedReads) {
            this.renderOptions.setLinkByTag(tag);
            this.renderOptions.setColorOption(ColorOption.TAG);
            this.renderOptions.setColorByTag(tag);
            if (this.dataManager.isPhased()) {
                this.renderOptions.setGroupByOption(GroupOption.TAG);
                this.renderOptions.setGroupByTag("HP");
            }
            this.showGroupLine = false;
            this.setDisplayMode(Track.DisplayMode.SQUISHED);
        }
        this.dataManager.packAlignments(this.renderOptions);
        this.repaint();
    }

    private boolean isLinkedReadView() {
        return this.renderOptions != null && this.renderOptions.isLinkedReads() && this.renderOptions.getLinkByTag() != null && this.renderOptions.getColorOption() == ColorOption.TAG && this.renderOptions.getColorByTag() != null;
    }

    private void setLinkByTag(boolean linkReads, String tag) {
        if (this.isLinkedReadView()) {
            this.undoLinkedReadView();
        }
        if (linkReads) {
            this.renderOptions.setLinkByTag(tag);
            if (this.renderOptions.getGroupByOption() == GroupOption.NONE) {
                this.renderOptions.setGroupByOption(GroupOption.LINKED);
            }
        } else {
            this.renderOptions.setLinkByTag(null);
            if (this.renderOptions.getGroupByOption() == GroupOption.LINKED) {
                this.renderOptions.setGroupByOption(GroupOption.NONE);
            }
        }
        this.renderOptions.setLinkedReads(linkReads);
        this.dataManager.packAlignments(this.renderOptions);
        this.repaint();
    }

    private void undoLinkedReadView() {
        this.renderOptions.setLinkByTag(null);
        this.renderOptions.setColorOption(ColorOption.NONE);
        this.renderOptions.setColorByTag(null);
        this.renderOptions.setGroupByOption(GroupOption.NONE);
        this.renderOptions.setGroupByTag(null);
        this.showGroupLine = true;
        this.setDisplayMode(Track.DisplayMode.EXPANDED);
    }

    private AlignmentBlock getInsertion(Alignment alignment, int pixelX) {
        if (alignment != null && alignment.getInsertions() != null) {
            for (AlignmentBlock block : alignment.getInsertions()) {
                if (!block.containsPixel(pixelX)) continue;
                return block;
            }
        }
        return null;
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        NodeList tmp;
        super.unmarshalXML(element, version);
        if (element.hasAttribute("experimentType")) {
            this.experimentType = ExperimentType.valueOf(element.getAttribute("experimentType"));
        }
        if ((tmp = element.getElementsByTagName("RenderOptions")).getLength() > 0) {
            Element renderElement = (Element)tmp.item(0);
            this.renderOptions = new RenderOptions();
            this.renderOptions.unmarshalXML(renderElement, version);
        }
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        if (this.experimentType != null) {
            element.setAttribute("experimentType", this.experimentType.toString());
        }
        Element sourceElement = document.createElement("RenderOptions");
        this.renderOptions.marshalXML(document, sourceElement);
        element.appendChild(sourceElement);
    }

    static {
        bisulfiteContextToPubString.put(BisulfiteContext.CG, "CG");
        bisulfiteContextToPubString.put(BisulfiteContext.CHH, "CHH");
        bisulfiteContextToPubString.put(BisulfiteContext.CHG, "CHG");
        bisulfiteContextToPubString.put(BisulfiteContext.HCG, "HCG");
        bisulfiteContextToPubString.put(BisulfiteContext.GCH, "GCH");
        bisulfiteContextToPubString.put(BisulfiteContext.WCG, "WCG");
        bisulfiteContextToPubString.put(BisulfiteContext.NONE, "None");
        bisulfiteContextToContextString = new HashMap<BisulfiteContext, Pair<byte[], byte[]>>();
        bisulfiteContextToContextString.put(BisulfiteContext.CG, new Pair<byte[], byte[]>(new byte[0], new byte[]{71}));
        bisulfiteContextToContextString.put(BisulfiteContext.CHH, new Pair<byte[], byte[]>(new byte[0], new byte[]{72, 72}));
        bisulfiteContextToContextString.put(BisulfiteContext.CHG, new Pair<byte[], byte[]>(new byte[0], new byte[]{72, 71}));
        bisulfiteContextToContextString.put(BisulfiteContext.HCG, new Pair<byte[], byte[]>(new byte[]{72}, new byte[]{71}));
        bisulfiteContextToContextString.put(BisulfiteContext.GCH, new Pair<byte[], byte[]>(new byte[]{71}, new byte[]{72}));
        bisulfiteContextToContextString.put(BisulfiteContext.WCG, new Pair<byte[], byte[]>(new byte[]{87}, new byte[]{71}));
    }

    public static class RenderOptions
    implements Cloneable,
    Persistable {
        public static final String NAME = "RenderOptions";
        private Boolean shadeBasesOption;
        private Boolean shadeCenters;
        private Boolean flagUnmappedPairs;
        private Boolean showAllBases;
        private Integer minInsertSize;
        private Integer maxInsertSize;
        private ColorOption colorOption;
        private GroupOption groupByOption;
        private Boolean viewPairs;
        private String colorByTag;
        private String groupByTag;
        private String sortByTag;
        private String linkByTag;
        private Boolean linkedReads;
        private Boolean quickConsensusMode;
        private Boolean showMismatches;
        private Boolean computeIsizes;
        private Double minInsertSizePercentile;
        private Double maxInsertSizePercentile;
        private Boolean pairedArcView;
        private Boolean flagZeroQualityAlignments;
        private Range groupByPos;
        private Boolean drawInsertionIntervals;
        BisulfiteContext bisulfiteContext = BisulfiteContext.CG;
        Map<String, PEStats> peStats;
        DefaultValues defaultValues;
        private IGVPreferences prefs;

        public RenderOptions() {
            this(ExperimentType.OTHER);
        }

        RenderOptions(ExperimentType experimentType) {
            this.prefs = AlignmentTrack.getPreferences(experimentType);
            this.peStats = new HashMap<String, PEStats>();
            this.defaultValues = new DefaultValues(this.prefs);
        }

        private <T extends Enum<T>> T getFromMap(Map<String, String> attributes, String key, Class<T> clazz, T defaultValue) {
            String value = attributes.get(key);
            if (value == null) {
                return defaultValue;
            }
            return CollUtils.valueOf(clazz, value, defaultValue);
        }

        private String getFromMap(Map<String, String> attributes, String key, String defaultValue) {
            String value = attributes.get(key);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        void setShowAllBases(boolean showAllBases) {
            this.showAllBases = showAllBases;
        }

        void setShowMismatches(boolean showMismatches) {
            this.showMismatches = showMismatches;
        }

        void setMinInsertSize(int minInsertSize) {
            this.minInsertSize = minInsertSize;
        }

        public void setViewPairs(boolean viewPairs) {
            this.viewPairs = viewPairs;
        }

        void setComputeIsizes(boolean computeIsizes) {
            this.computeIsizes = computeIsizes;
        }

        void setMaxInsertSizePercentile(double maxInsertSizePercentile) {
            this.maxInsertSizePercentile = maxInsertSizePercentile;
        }

        void setMaxInsertSize(int maxInsertSize) {
            this.maxInsertSize = maxInsertSize;
        }

        void setMinInsertSizePercentile(double minInsertSizePercentile) {
            this.minInsertSizePercentile = minInsertSizePercentile;
        }

        void setColorByTag(String colorByTag) {
            this.colorByTag = colorByTag;
        }

        void setColorOption(ColorOption colorOption) {
            this.colorOption = colorOption;
        }

        void setSortByTag(String sortByTag) {
            this.sortByTag = sortByTag;
        }

        void setGroupByTag(String groupByTag) {
            this.groupByTag = groupByTag;
        }

        void setGroupByPos(Range groupByPos) {
            this.groupByPos = groupByPos;
        }

        void setLinkByTag(String linkByTag) {
            this.linkByTag = linkByTag;
        }

        void setQuickConsensusMode(boolean quickConsensusMode) {
            this.quickConsensusMode = quickConsensusMode;
        }

        public void setGroupByOption(GroupOption groupByOption) {
            this.groupByOption = groupByOption == null ? GroupOption.NONE : groupByOption;
        }

        void setShadeBasesOption(boolean shadeBasesOption) {
            this.shadeBasesOption = shadeBasesOption;
        }

        void setLinkedReads(boolean linkedReads) {
            this.linkedReads = linkedReads;
        }

        public void setDrawInsertionIntervals(boolean drawInsertionIntervals) {
            this.drawInsertionIntervals = drawInsertionIntervals;
        }

        public int getMinInsertSize() {
            return this.minInsertSize == null ? this.prefs.getAsInt("SAM.MIN_INSERT_SIZE_THRESHOLD") : this.minInsertSize.intValue();
        }

        public int getMaxInsertSize() {
            return this.maxInsertSize == null ? this.prefs.getAsInt("SAM.INSERT_SIZE_THRESHOLD") : this.maxInsertSize.intValue();
        }

        public boolean isFlagUnmappedPairs() {
            return this.flagUnmappedPairs == null ? this.prefs.getAsBoolean("SAM.FLAG_UNMAPPED_PAIR") : this.flagUnmappedPairs.booleanValue();
        }

        public boolean getShadeBasesOption() {
            return this.shadeBasesOption == null ? this.prefs.getAsBoolean("SAM.SHADE_BASE_QUALITY") : this.shadeBasesOption.booleanValue();
        }

        public boolean isShowMismatches() {
            return this.showMismatches == null ? this.prefs.getAsBoolean("SAM.SHOW_MISMATCHES") : this.showMismatches.booleanValue();
        }

        public boolean isShowAllBases() {
            return this.showAllBases == null ? this.prefs.getAsBoolean("SAM.SHOW_ALL_BASES") : this.showAllBases.booleanValue();
        }

        public boolean isShadeCenters() {
            return this.shadeCenters == null ? this.prefs.getAsBoolean("SAM.SHADE_CENTER") : this.shadeCenters.booleanValue();
        }

        boolean isDrawInsertionIntervals() {
            return this.drawInsertionIntervals == null ? this.prefs.getAsBoolean("SAM.SHOW_INSERTION_MARKERS") : this.drawInsertionIntervals.booleanValue();
        }

        public boolean isFlagZeroQualityAlignments() {
            return this.flagZeroQualityAlignments == null ? this.prefs.getAsBoolean("SAM.FLAG_ZERO_QUALITY") : this.flagZeroQualityAlignments.booleanValue();
        }

        public boolean isViewPairs() {
            return this.viewPairs == null ? this.defaultValues.viewPairs : this.viewPairs;
        }

        public boolean isComputeIsizes() {
            return this.computeIsizes == null ? this.prefs.getAsBoolean("SAM.COMPUTE_ISIZES") : this.computeIsizes.booleanValue();
        }

        public double getMinInsertSizePercentile() {
            return this.minInsertSizePercentile == null ? (double)this.prefs.getAsFloat("SAM.MIN_ISIZE_MIN_PERCENTILE") : this.minInsertSizePercentile;
        }

        public double getMaxInsertSizePercentile() {
            return this.maxInsertSizePercentile == null ? (double)this.prefs.getAsFloat("SAM.ISIZE_MAX_PERCENTILE") : this.maxInsertSizePercentile;
        }

        public ColorOption getColorOption() {
            return this.colorOption == null ? CollUtils.valueOf(ColorOption.class, this.prefs.get("SAM.COLOR_BY"), ColorOption.NONE) : this.colorOption;
        }

        public String getColorByTag() {
            return this.colorByTag == null ? this.prefs.get("SAM.COLOR_BY_TAG") : this.colorByTag;
        }

        String getSortByTag() {
            return this.sortByTag == null ? this.prefs.get("SAM.SORT_BY_TAG") : this.sortByTag;
        }

        public String getGroupByTag() {
            return this.groupByTag == null ? this.prefs.get("SAM.GROUP_BY_TAG") : this.groupByTag;
        }

        public Range getGroupByPos() {
            return this.groupByPos == null ? this.defaultValues.groupByPos : this.groupByPos;
        }

        public String getLinkByTag() {
            return this.linkByTag;
        }

        public GroupOption getGroupByOption() {
            GroupOption gbo = this.groupByOption;
            gbo = gbo == null ? CollUtils.valueOf(GroupOption.class, this.prefs.get("SAM.GROUP_OPTION"), GroupOption.NONE) : gbo;
            gbo = gbo == null ? GroupOption.NONE : gbo;
            return gbo;
        }

        public boolean isLinkedReads() {
            return this.linkedReads != null && this.linkedReads != false;
        }

        public boolean isQuickConsensusMode() {
            return this.quickConsensusMode == null ? this.prefs.getAsBoolean("SAM.QUICK_CONSENSUS_MODE") : this.quickConsensusMode.booleanValue();
        }

        void repaintDefaults(ExperimentType experimentType) {
            this.prefs = AlignmentTrack.getPreferences(experimentType);
            this.defaultValues = new DefaultValues(this.prefs);
        }

        @Override
        public void marshalXML(Document document, Element element) {
            if (this.shadeBasesOption != null) {
                element.setAttribute("shadeBasesOption", this.shadeBasesOption.toString());
            }
            if (this.shadeCenters != null) {
                element.setAttribute("shadeCenters", this.shadeCenters.toString());
            }
            if (this.flagUnmappedPairs != null) {
                element.setAttribute("flagUnmappedPairs", this.flagUnmappedPairs.toString());
            }
            if (this.showAllBases != null) {
                element.setAttribute("showAllBases", this.showAllBases.toString());
            }
            if (this.minInsertSize != null) {
                element.setAttribute("minInsertSize", this.minInsertSize.toString());
            }
            if (this.maxInsertSize != null) {
                element.setAttribute("maxInsertSize", this.maxInsertSize.toString());
            }
            if (this.colorOption != null) {
                element.setAttribute("colorOption", this.colorOption.toString());
            }
            if (this.groupByOption != null) {
                element.setAttribute("groupByOption", this.groupByOption.toString());
            }
            if (this.viewPairs != null) {
                element.setAttribute("viewPairs", this.viewPairs.toString());
            }
            if (this.colorByTag != null) {
                element.setAttribute("colorByTag", this.colorByTag);
            }
            if (this.groupByTag != null) {
                element.setAttribute("groupByTag", this.groupByTag);
            }
            if (this.sortByTag != null) {
                element.setAttribute("sortByTag", this.sortByTag);
            }
            if (this.linkByTag != null) {
                element.setAttribute("linkByTag", this.linkByTag);
            }
            if (this.linkedReads != null) {
                element.setAttribute("linkedReads", this.linkedReads.toString());
            }
            if (this.quickConsensusMode != null) {
                element.setAttribute("quickConsensusMode", this.quickConsensusMode.toString());
            }
            if (this.showMismatches != null) {
                element.setAttribute("showMismatches", this.showMismatches.toString());
            }
            if (this.computeIsizes != null) {
                element.setAttribute("computeIsizes", this.computeIsizes.toString());
            }
            if (this.minInsertSizePercentile != null) {
                element.setAttribute("minInsertSizePercentile", this.minInsertSizePercentile.toString());
            }
            if (this.maxInsertSizePercentile != null) {
                element.setAttribute("maxInsertSizePercentile", this.maxInsertSizePercentile.toString());
            }
            if (this.pairedArcView != null) {
                element.setAttribute("pairedArcView", this.pairedArcView.toString());
            }
            if (this.flagZeroQualityAlignments != null) {
                element.setAttribute("flagZeroQualityAlignments", this.flagZeroQualityAlignments.toString());
            }
            if (this.groupByPos != null) {
                element.setAttribute("groupByPos", this.groupByPos.toString());
            }
        }

        @Override
        public void unmarshalXML(Element element, Integer version) {
            String v;
            if (element.hasAttribute("shadeBasesOption") && (v = element.getAttribute("shadeBasesOption")) != null) {
                this.shadeBasesOption = v.equalsIgnoreCase("quality") || v.equalsIgnoreCase("true");
            }
            if (element.hasAttribute("shadeCenters")) {
                this.shadeCenters = Boolean.parseBoolean(element.getAttribute("shadeCenters"));
            }
            if (element.hasAttribute("showAllBases")) {
                this.showAllBases = Boolean.parseBoolean(element.getAttribute("showAllBases"));
            }
            if (element.hasAttribute("flagUnmappedPairs")) {
                this.flagUnmappedPairs = Boolean.parseBoolean(element.getAttribute("flagUnmappedPairs"));
            }
            if (element.hasAttribute("minInsertSize")) {
                this.minInsertSize = Integer.parseInt(element.getAttribute("minInsertSize"));
            }
            if (element.hasAttribute("maxInsertSize")) {
                this.maxInsertSize = Integer.parseInt(element.getAttribute("maxInsertSize"));
            }
            if (element.hasAttribute("colorOption")) {
                this.colorOption = ColorOption.valueOf(element.getAttribute("colorOption"));
            }
            if (element.hasAttribute("groupByOption")) {
                this.groupByOption = GroupOption.valueOf(element.getAttribute("groupByOption"));
            }
            if (element.hasAttribute("viewPairs")) {
                this.viewPairs = Boolean.parseBoolean(element.getAttribute("viewPairs"));
            }
            if (element.hasAttribute("colorByTag")) {
                this.colorByTag = element.getAttribute("colorByTag");
            }
            if (element.hasAttribute("groupByTag")) {
                this.groupByTag = element.getAttribute("groupByTag");
            }
            if (element.hasAttribute("sortByTag")) {
                this.sortByTag = element.getAttribute("sortByTag");
            }
            if (element.hasAttribute("linkByTag")) {
                this.linkByTag = element.getAttribute("linkByTag");
            }
            if (element.hasAttribute("linkedReads")) {
                this.linkedReads = Boolean.parseBoolean(element.getAttribute("linkedReads"));
            }
            if (element.hasAttribute("quickConsensusMode")) {
                this.quickConsensusMode = Boolean.parseBoolean(element.getAttribute("quickConsensusMode"));
            }
            if (element.hasAttribute("showMismatches")) {
                this.showMismatches = Boolean.parseBoolean(element.getAttribute("showMismatches"));
            }
            if (element.hasAttribute("computeIsizes")) {
                this.computeIsizes = Boolean.parseBoolean(element.getAttribute("computeIsizes"));
            }
            if (element.hasAttribute("minInsertSizePercentile")) {
                this.minInsertSizePercentile = Double.parseDouble(element.getAttribute("minInsertSizePercentile"));
            }
            if (element.hasAttribute("maxInsertSizePercentile")) {
                this.maxInsertSizePercentile = Double.parseDouble(element.getAttribute("maxInsertSizePercentile"));
            }
            if (element.hasAttribute("pairedArcView")) {
                this.pairedArcView = Boolean.parseBoolean(element.getAttribute("pairedArcView"));
            }
            if (element.hasAttribute("flagZeroQualityAlignments")) {
                this.flagZeroQualityAlignments = Boolean.parseBoolean(element.getAttribute("flagZeroQualityAlignments"));
            }
            if (element.hasAttribute("groupByPos")) {
                this.groupByPos = Range.fromString(element.getAttribute("groupByPos"));
            }
        }

        static class DefaultValues {
            final boolean viewPairs;
            final boolean pairedArcView;
            Range groupByPos;

            DefaultValues(IGVPreferences prefs) {
                String pos = prefs.get("SAM.GROUP_BY_POS");
                this.viewPairs = false;
                this.pairedArcView = false;
                if (pos != null) {
                    String[] posParts = pos.split(" ");
                    if (posParts.length != 2) {
                        this.groupByPos = null;
                    } else {
                        int posChromStart = Integer.parseInt(posParts[1]);
                        this.groupByPos = new Range(posParts[0], posChromStart, posChromStart + 1);
                    }
                }
            }
        }
    }

    static class InsertionMenu
    extends IGVPopupMenu {
        final AlignmentBlock insertion;

        InsertionMenu(AlignmentBlock insertion) {
            this.insertion = insertion;
            this.addCopySequenceItem();
            if (insertion.getBases() != null && insertion.getBases().length > 10) {
                this.addBlatItem();
            }
        }

        void addCopySequenceItem() {
            JMenuItem item = new JMenuItem("Copy insert sequence");
            this.add(item);
            item.addActionListener(aEvt -> StringUtils.copyTextToClipboard(this.insertion.getBases().getString()));
        }

        void addBlatItem() {
            JMenuItem item = new JMenuItem("Blat insert sequence");
            this.add(item);
            item.addActionListener(aEvt -> {
                String blatSeq = this.insertion.getBases().getString();
                BlatClient.doBlatQuery(blatSeq, "Blat insert sequence");
            });
            item.setEnabled(this.insertion.getBases() != null && this.insertion.getBases().length >= 10);
        }

        @Override
        public boolean includeStandardItems() {
            return false;
        }
    }

    class PopupMenu
    extends IGVPopupMenu {
        PopupMenu(TrackClickEvent e) {
            MouseEvent me = e.getMouseEvent();
            ReferenceFrame frame = e.getFrame();
            Alignment clickedAlignment = null;
            if (frame != null) {
                double location = frame.getChromosomePosition(me.getX());
                clickedAlignment = AlignmentTrack.this.getAlignmentAt(location, me.getY(), frame);
            }
            ArrayList<Track> tracks = new ArrayList<Track>();
            tracks.add(AlignmentTrack.this);
            JLabel popupTitle = new JLabel("  " + AlignmentTrack.this.getName(), 0);
            Font newFont = this.getFont().deriveFont(1, 12.0f);
            popupTitle.setFont(newFont);
            this.add(popupTitle);
            this.addSeparator();
            this.add(TrackMenuUtils.getTrackRenameItem(tracks));
            this.addCopyToClipboardItem(e, clickedAlignment);
            this.addSeparator();
            this.addExperimentTypeMenuItem();
            if (AlignmentTrack.this.experimentType == ExperimentType.THIRD_GEN) {
                this.addHaplotype(e);
            }
            this.addLinkedReadItems();
            this.addSeparator();
            this.addGroupMenuItem(e);
            this.addSortMenuItem();
            this.addColorByMenuItem();
            this.addPackMenuItem();
            this.addSeparator();
            this.addShadeBaseByMenuItem();
            JMenuItem misMatchesItem = this.addShowMismatchesMenuItem();
            JMenuItem showAllItem = this.addShowAllBasesMenuItem();
            misMatchesItem.addActionListener(new Deselector(misMatchesItem, showAllItem));
            showAllItem.addActionListener(new Deselector(showAllItem, misMatchesItem));
            this.addQuickConsensusModeItem();
            this.addSeparator();
            this.addViewAsPairsMenuItem();
            if (clickedAlignment != null) {
                this.addGoToMate(e, clickedAlignment);
                this.showMateRegion(e, clickedAlignment);
            }
            this.addInsertSizeMenuItem();
            this.addSeparator();
            TrackMenuUtils.addDisplayModeItems(tracks, this);
            this.addSeparator();
            this.addSelectByNameItem();
            this.addClearSelectionsMenuItem();
            this.addSeparator();
            this.addCopySequenceItem(e);
            this.addBlatItem(e);
            this.addBlatClippingItems(e);
            this.addConsensusSequence(e);
            AlignmentBlock insertion = AlignmentTrack.this.getInsertion(clickedAlignment, e.getMouseEvent().getX());
            if (insertion != null) {
                this.addSeparator();
                this.addInsertionItems(insertion);
            }
            this.addSeparator();
            JMenuItem sashimi = new JMenuItem("Sashimi Plot");
            sashimi.addActionListener(e1 -> SashimiPlot.getSashimiPlot(null));
            this.add(sashimi);
            this.addSeparator();
            this.addShowItems();
            if (AlignmentTrack.this.getPreferences().get("EXTVIEW_URL") != null) {
                this.addSeparator();
                this.addExtViewItem(e);
            }
        }

        private void addHaplotype(TrackClickEvent e) {
            JMenuItem item = new JMenuItem("Cluster (phase) alignments");
            ReferenceFrame frame = e.getFrame() == null && FrameManager.getFrames().size() == 1 ? FrameManager.getFrames().get(0) : e.getFrame();
            item.setEnabled(frame != null);
            this.add(item);
            item.addActionListener(ae -> {
                if (frame == null) {
                    MessageUtils.showMessage("Unknown region bounds");
                    return;
                }
                String nString = MessageUtils.showInputDialog("Enter the number of clusters", String.valueOf(nClusters));
                if (nString == null) {
                    return;
                }
                try {
                    nClusters = Integer.parseInt(nString);
                }
                catch (NumberFormatException e1) {
                    MessageUtils.showMessage("Clusters size must be an integer");
                    return;
                }
                int start = (int)frame.getOrigin();
                int end = (int)frame.getEnd();
                AlignmentInterval interval = AlignmentTrack.this.dataManager.getLoadedInterval(frame);
                HaplotypeUtils haplotypeUtils = new HaplotypeUtils(interval, AlignmentTrack.this.genome);
                boolean success = haplotypeUtils.clusterAlignments(frame.getChrName(), start, end, nClusters);
                if (success) {
                    AlignmentTrack.this.groupAlignments(GroupOption.HAPLOTYPE, null, null);
                    AlignmentTrack.this.repaint();
                }
            });
        }

        public JMenuItem addExpandInsertions() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Expand insertions");
            Session session = IGV.getInstance().getSession();
            item.setSelected(session.expandInsertions);
            item.addActionListener(aEvt -> {
                session.expandInsertions = !session.expandInsertions;
                AlignmentTrack.this.repaint();
            });
            this.add(item);
            return item;
        }

        private void addConsensusSequence(TrackClickEvent e) {
            JMenuItem item = new JMenuItem("Copy consensus sequence");
            ReferenceFrame frame = e.getFrame() == null && FrameManager.getFrames().size() == 1 ? FrameManager.getFrames().get(0) : e.getFrame();
            item.setEnabled(frame != null);
            this.add(item);
            item.addActionListener(ae -> {
                if (frame == null) {
                    MessageUtils.showMessage("Unknown region bounds, cannot export consensus");
                    return;
                }
                int start = (int)frame.getOrigin();
                int end = (int)frame.getEnd();
                if (end - start > 1000000) {
                    MessageUtils.showMessage("Cannot export region more than 1 Megabase");
                    return;
                }
                AlignmentInterval interval = AlignmentTrack.this.dataManager.getLoadedInterval(frame);
                AlignmentCounts counts = interval.getCounts();
                String text = PFMExporter.createPFMText(counts, frame.getChrName(), start, end);
                StringUtils.copyTextToClipboard(text);
            });
        }

        private JMenu getBisulfiteContextMenuItem(ButtonGroup group) {
            JMenu bisulfiteContextMenu = new JMenu("bisulfite mode");
            JRadioButtonMenuItem nomeESeqOption = null;
            boolean showNomeESeq = AlignmentTrack.this.getPreferences().getAsBoolean("SAM.NOMESEQ_ENABLED");
            if (showNomeESeq) {
                nomeESeqOption = new JRadioButtonMenuItem("NOMe-seq bisulfite mode");
                nomeESeqOption.setSelected(AlignmentTrack.this.renderOptions.getColorOption() == ColorOption.NOMESEQ);
                nomeESeqOption.addActionListener(aEvt -> {
                    AlignmentTrack.this.setColorOption(ColorOption.NOMESEQ);
                    AlignmentTrack.this.repaint();
                });
                group.add(nomeESeqOption);
            }
            for (BisulfiteContext item : BisulfiteContext.values()) {
                String optionStr = AlignmentTrack.getBisulfiteContextPubStr(item);
                JRadioButtonMenuItem m1 = new JRadioButtonMenuItem(optionStr);
                m1.setSelected(AlignmentTrack.this.renderOptions.bisulfiteContext == item);
                m1.addActionListener(aEvt -> {
                    AlignmentTrack.this.setColorOption(ColorOption.BISULFITE);
                    AlignmentTrack.this.setBisulfiteContext(item);
                    AlignmentTrack.this.repaint();
                });
                bisulfiteContextMenu.add(m1);
                group.add(m1);
            }
            if (nomeESeqOption != null) {
                bisulfiteContextMenu.add(nomeESeqOption);
            }
            return bisulfiteContextMenu;
        }

        void addSelectByNameItem() {
            JMenuItem item = new JMenuItem("Select by name...");
            item.addActionListener(aEvt -> {
                String val = MessageUtils.showInputDialog("Enter read name: ");
                if (val != null && val.trim().length() > 0) {
                    AlignmentTrack.this.selectedReadNames.put(val, AlignmentTrack.this.readNamePalette.get(val));
                    AlignmentTrack.this.repaint();
                }
            });
            this.add(item);
        }

        void addExperimentTypeMenuItem() {
            LinkedHashMap<String, ExperimentType> mappings = new LinkedHashMap<String, ExperimentType>();
            mappings.put("Other", ExperimentType.OTHER);
            mappings.put("RNA", ExperimentType.RNA);
            mappings.put("3rd Gen", ExperimentType.THIRD_GEN);
            JMenu groupMenu = new JMenu("Experiment Type");
            ButtonGroup group = new ButtonGroup();
            for (Map.Entry el : mappings.entrySet()) {
                JCheckBoxMenuItem mi = this.getExperimentTypeMenuItem((String)el.getKey(), (ExperimentType)((Object)el.getValue()));
                groupMenu.add(mi);
                group.add(mi);
            }
            this.add(groupMenu);
        }

        private JCheckBoxMenuItem getExperimentTypeMenuItem(String label, ExperimentType option) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(label);
            mi.setSelected(AlignmentTrack.this.getExperimentType() == option);
            mi.addActionListener(aEvt -> AlignmentTrack.this.setExperimentType(option));
            return mi;
        }

        void addGroupMenuItem(TrackClickEvent te) {
            GroupOption[] groupOptions;
            MouseEvent me = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                frame = FrameManager.getDefaultFrame();
            }
            Range range = frame.getCurrentRange();
            String chrom = range.getChr();
            int chromStart = (int)frame.getChromosomePosition(me.getX());
            JMenu groupMenu = new JMenu("Group alignments by");
            ButtonGroup group = new ButtonGroup();
            for (GroupOption option : groupOptions = new GroupOption[]{GroupOption.NONE, GroupOption.STRAND, GroupOption.FIRST_OF_PAIR_STRAND, GroupOption.SAMPLE, GroupOption.LIBRARY, GroupOption.READ_GROUP, GroupOption.MATE_CHROMOSOME, GroupOption.PAIR_ORIENTATION, GroupOption.SUPPLEMENTARY, GroupOption.REFERENCE_CONCORDANCE, GroupOption.MOVIE, GroupOption.ZMW, GroupOption.READ_ORDER, GroupOption.LINKED, GroupOption.PHASE}) {
                JCheckBoxMenuItem mi = new JCheckBoxMenuItem(option.label);
                mi.setSelected(AlignmentTrack.this.renderOptions.getGroupByOption() == option);
                mi.addActionListener(aEvt -> IGV.getInstance().groupAlignmentTracks(option, null, null));
                groupMenu.add(mi);
                group.add(mi);
            }
            JCheckBoxMenuItem tagOption = new JCheckBoxMenuItem("tag");
            tagOption.addActionListener(aEvt -> {
                String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getGroupByTag());
                if (tag != null) {
                    if (tag.trim().length() > 0) {
                        IGV.getInstance().groupAlignmentTracks(GroupOption.TAG, tag, null);
                    } else {
                        IGV.getInstance().groupAlignmentTracks(GroupOption.NONE, null, null);
                    }
                }
            });
            tagOption.setSelected(AlignmentTrack.this.renderOptions.getGroupByOption() == GroupOption.TAG);
            groupMenu.add(tagOption);
            group.add(tagOption);
            Range oldGroupByPos = AlignmentTrack.this.renderOptions.getGroupByPos();
            if (oldGroupByPos != null && AlignmentTrack.this.renderOptions.getGroupByOption() == GroupOption.BASE_AT_POS) {
                JCheckBoxMenuItem oldGroupByPosOption = new JCheckBoxMenuItem("base at " + oldGroupByPos.getChr() + ":" + Globals.DECIMAL_FORMAT.format(1 + oldGroupByPos.getStart()));
                groupMenu.add(oldGroupByPosOption);
                oldGroupByPosOption.setSelected(true);
            }
            if (AlignmentTrack.this.renderOptions.getGroupByOption() != GroupOption.BASE_AT_POS || oldGroupByPos == null || !oldGroupByPos.getChr().equals(chrom) || oldGroupByPos.getStart() != chromStart) {
                JCheckBoxMenuItem newGroupByPosOption = new JCheckBoxMenuItem("base at " + chrom + ":" + Globals.DECIMAL_FORMAT.format(1 + chromStart));
                newGroupByPosOption.addActionListener(aEvt -> {
                    Range groupByPos = new Range(chrom, chromStart, chromStart + 1);
                    IGV.getInstance().groupAlignmentTracks(GroupOption.BASE_AT_POS, null, groupByPos);
                });
                groupMenu.add(newGroupByPosOption);
                group.add(newGroupByPosOption);
            }
            this.add(groupMenu);
        }

        void addSortMenuItem() {
            JMenu sortMenu = new JMenu("Sort alignments by");
            LinkedHashMap<String, SortOption> mappings = new LinkedHashMap<String, SortOption>();
            mappings.put("start location", SortOption.START);
            mappings.put("read strand", SortOption.STRAND);
            mappings.put("first-of-pair strand", SortOption.FIRST_OF_PAIR_STRAND);
            mappings.put("base", SortOption.NUCLEOTIDE);
            mappings.put("mapping quality", SortOption.QUALITY);
            mappings.put("sample", SortOption.SAMPLE);
            mappings.put("read group", SortOption.READ_GROUP);
            mappings.put("read order", SortOption.READ_ORDER);
            mappings.put("read name", SortOption.READ_NAME);
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("insert size", SortOption.INSERT_SIZE);
                mappings.put("chromosome of mate", SortOption.MATE_CHR);
            }
            for (Map.Entry el : mappings.entrySet()) {
                JMenuItem mi = new JMenuItem((String)el.getKey());
                mi.addActionListener(aEvt -> AlignmentTrack.sortAlignmentTracks((SortOption)((Object)((Object)el.getValue())), null));
                sortMenu.add(mi);
            }
            JMenuItem tagOption = new JMenuItem("tag");
            tagOption.addActionListener(aEvt -> {
                String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getSortByTag());
                if (tag != null && tag.trim().length() > 0) {
                    AlignmentTrack.this.renderOptions.setSortByTag(tag);
                    AlignmentTrack.sortAlignmentTracks(SortOption.TAG, tag);
                }
            });
            sortMenu.add(tagOption);
            this.add(sortMenu);
        }

        public void addFilterMenuItem() {
            JMenu filterMenu = new JMenu("Filter alignments by");
            JMenuItem mi = new JMenuItem("mapping quality");
            mi.addActionListener(aEvt -> {
                String defString = PreferencesManager.getPreferences().get("SAM.QUALITY_THRESHOLD");
                if (defString == null) {
                    defString = "";
                }
                String mqString = MessageUtils.showInputDialog("Minimum mapping quality: ", defString);
                try {
                    int n = Integer.parseInt(mqString);
                }
                catch (NumberFormatException e) {
                    MessageUtils.showMessage("Mapping quality must be an integer");
                }
            });
            filterMenu.add(mi);
            this.add(filterMenu);
        }

        private JRadioButtonMenuItem getColorMenuItem(String label, ColorOption option) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(label);
            mi.setSelected(AlignmentTrack.this.renderOptions.getColorOption() == option);
            mi.addActionListener(aEvt -> {
                AlignmentTrack.this.setColorOption(option);
                AlignmentTrack.this.repaint();
            });
            return mi;
        }

        void addColorByMenuItem() {
            JMenu colorMenu = new JMenu("Color alignments by");
            ButtonGroup group = new ButtonGroup();
            LinkedHashMap<String, ColorOption> mappings = new LinkedHashMap<String, ColorOption>();
            mappings.put("no color", ColorOption.NONE);
            if (AlignmentTrack.this.dataManager.hasYCTags()) {
                mappings.put("YC tag", ColorOption.YC_TAG);
            }
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("insert size", ColorOption.INSERT_SIZE);
                mappings.put("pair orientation", ColorOption.PAIR_ORIENTATION);
                mappings.put("insert size and pair orientation", ColorOption.UNEXPECTED_PAIR);
            }
            mappings.put("read strand", ColorOption.READ_STRAND);
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("first-of-pair strand", ColorOption.FIRST_OF_PAIR_STRAND);
            }
            mappings.put("read group", ColorOption.READ_GROUP);
            mappings.put("sample", ColorOption.SAMPLE);
            mappings.put("library", ColorOption.LIBRARY);
            mappings.put("movie", ColorOption.MOVIE);
            mappings.put("ZMW", ColorOption.ZMW);
            mappings.put("base modification", ColorOption.BASE_MODIFICATION);
            for (Map.Entry el : mappings.entrySet()) {
                JRadioButtonMenuItem mi = this.getColorMenuItem((String)el.getKey(), (ColorOption)((Object)el.getValue()));
                colorMenu.add(mi);
                group.add(mi);
            }
            JRadioButtonMenuItem tagOption = new JRadioButtonMenuItem("tag");
            tagOption.setSelected(AlignmentTrack.this.renderOptions.getColorOption() == ColorOption.TAG);
            tagOption.addActionListener(aEvt -> {
                AlignmentTrack.this.setColorOption(ColorOption.TAG);
                String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getColorByTag());
                if (tag != null && tag.trim().length() > 0) {
                    AlignmentTrack.this.setColorByTag(tag);
                    AlignmentTrack.this.repaint();
                }
            });
            colorMenu.add(tagOption);
            group.add(tagOption);
            colorMenu.add(this.getBisulfiteContextMenuItem(group));
            this.add(colorMenu);
        }

        void addPackMenuItem() {
            JMenuItem item = new JMenuItem("Re-pack alignments");
            item.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
                IGV.getInstance().packAlignmentTracks();
                AlignmentTrack.this.repaint();
            }));
            this.add(item);
        }

        void addCopyToClipboardItem(TrackClickEvent te, Alignment alignment) {
            MouseEvent me = te.getMouseEvent();
            JMenuItem item = new JMenuItem("Copy read details to clipboard");
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                double location = frame.getChromosomePosition(me.getX());
                item.addActionListener(aEvt -> AlignmentTrack.this.copyToClipboard(te, alignment, location, me.getX()));
                if (alignment == null) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        void addViewAsPairsMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("View as pairs");
            item.setSelected(AlignmentTrack.this.renderOptions.isViewPairs());
            item.addActionListener(aEvt -> {
                boolean viewAsPairs = item.isSelected();
                AlignmentTrack.this.setViewAsPairs(viewAsPairs);
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        void addGoToMate(TrackClickEvent te, Alignment alignment) {
            JMenuItem item = new JMenuItem("Go to mate");
            MouseEvent e = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                item.addActionListener(aEvt -> AlignmentTrack.this.gotoMate(te, alignment));
                if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        void showMateRegion(TrackClickEvent te, Alignment clickedAlignment) {
            JMenuItem item = new JMenuItem("View mate region in split screen");
            MouseEvent e = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                double location = frame.getChromosomePosition(e.getX());
                if (clickedAlignment instanceof PairedAlignment) {
                    Alignment first = ((PairedAlignment)clickedAlignment).getFirstAlignment();
                    Alignment second = ((PairedAlignment)clickedAlignment).getSecondAlignment();
                    clickedAlignment = first.contains(location) ? first : (second.contains(location) ? second : null);
                }
                Alignment alignment = clickedAlignment;
                item.addActionListener(aEvt -> AlignmentTrack.this.splitScreenMate(te, alignment));
                if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        void addClearSelectionsMenuItem() {
            JMenuItem item = new JMenuItem("Clear selections");
            item.addActionListener(aEvt -> {
                AlignmentTrack.this.selectedReadNames.clear();
                AlignmentTrack.this.repaint();
            });
            this.add(item);
        }

        JMenuItem addShowAllBasesMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show all bases");
            if (AlignmentTrack.this.renderOptions.getColorOption() != ColorOption.BISULFITE && AlignmentTrack.this.renderOptions.getColorOption() != ColorOption.NOMESEQ) {
                item.setSelected(AlignmentTrack.this.renderOptions.isShowAllBases());
            }
            item.addActionListener(aEvt -> {
                AlignmentTrack.this.renderOptions.setShowAllBases(item.isSelected());
                AlignmentTrack.this.repaint();
            });
            this.add(item);
            return item;
        }

        void addQuickConsensusModeItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Quick consensus mode");
            item.setSelected(AlignmentTrack.this.renderOptions.isQuickConsensusMode());
            item.addActionListener(aEvt -> {
                AlignmentTrack.this.renderOptions.setQuickConsensusMode(item.isSelected());
                AlignmentTrack.this.repaint();
            });
            this.add(item);
        }

        JMenuItem addShowMismatchesMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show mismatched bases");
            item.setSelected(AlignmentTrack.this.renderOptions.isShowMismatches());
            item.addActionListener(aEvt -> {
                AlignmentTrack.this.renderOptions.setShowMismatches(item.isSelected());
                AlignmentTrack.this.repaint();
            });
            this.add(item);
            return item;
        }

        void addInsertSizeMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Set insert size options ...");
            item.addActionListener(aEvt -> {
                InsertSizeSettingsDialog dlg = new InsertSizeSettingsDialog(IGV.getMainFrame(), AlignmentTrack.this.renderOptions);
                dlg.setModal(true);
                dlg.setVisible(true);
                if (!dlg.isCanceled()) {
                    AlignmentTrack.this.renderOptions.setComputeIsizes(dlg.isComputeIsize());
                    AlignmentTrack.this.renderOptions.setMinInsertSizePercentile(dlg.getMinPercentile());
                    AlignmentTrack.this.renderOptions.setMaxInsertSizePercentile(dlg.getMaxPercentile());
                    if (AlignmentTrack.this.renderOptions.computeIsizes.booleanValue()) {
                        AlignmentTrack.this.dataManager.updatePEStats(AlignmentTrack.this.renderOptions);
                    }
                    AlignmentTrack.this.renderOptions.setMinInsertSize(dlg.getMinThreshold());
                    AlignmentTrack.this.renderOptions.setMaxInsertSize(dlg.getMaxThreshold());
                    AlignmentTrack.this.repaint();
                }
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        void addShadeBaseByMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Shade base by quality");
            item.setSelected(AlignmentTrack.this.renderOptions.getShadeBasesOption());
            item.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
                AlignmentTrack.this.renderOptions.setShadeBasesOption(item.isSelected());
                AlignmentTrack.this.repaint();
            }));
            this.add(item);
        }

        void addShowItems() {
            JCheckBoxMenuItem item;
            if (AlignmentTrack.this.coverageTrack != null) {
                item = new JCheckBoxMenuItem("Show Coverage Track");
                item.setSelected(AlignmentTrack.this.coverageTrack.isVisible());
                item.setEnabled(!AlignmentTrack.this.coverageTrack.isRemoved());
                item.addActionListener(aEvt -> {
                    AlignmentTrack.this.getCoverageTrack().setVisible(item.isSelected());
                    IGV.getInstance().repaint(Arrays.asList(AlignmentTrack.this.coverageTrack));
                });
                this.add(item);
            }
            if (AlignmentTrack.this.spliceJunctionTrack != null) {
                item = new JCheckBoxMenuItem("Show Splice Junction Track");
                item.setSelected(AlignmentTrack.this.spliceJunctionTrack.isVisible());
                item.setEnabled(!AlignmentTrack.this.spliceJunctionTrack.isRemoved());
                item.addActionListener(aEvt -> {
                    AlignmentTrack.this.spliceJunctionTrack.setVisible(item.isSelected());
                    IGV.getInstance().repaint(Arrays.asList(AlignmentTrack.this.spliceJunctionTrack));
                });
                this.add(item);
            }
            JCheckBoxMenuItem alignmentItem = new JCheckBoxMenuItem("Show Alignment Track");
            alignmentItem.setSelected(true);
            alignmentItem.addActionListener(e -> {
                AlignmentTrack.this.setVisible(alignmentItem.isSelected());
                IGV.getInstance().repaint(Arrays.asList(AlignmentTrack.this));
            });
            if (!(AlignmentTrack.this.coverageTrack != null && AlignmentTrack.this.coverageTrack.isVisible() || AlignmentTrack.this.spliceJunctionTrack != null && AlignmentTrack.this.spliceJunctionTrack.isVisible())) {
                alignmentItem.setEnabled(false);
            }
            this.add(alignmentItem);
        }

        void addCopySequenceItem(TrackClickEvent te) {
            JMenuItem item = new JMenuItem("Copy read sequence");
            this.add(item);
            Alignment alignment = AlignmentTrack.this.getSpecficAlignment(te);
            if (alignment == null) {
                item.setEnabled(false);
                return;
            }
            String seq = alignment.getReadSequence();
            if (seq == null) {
                item.setEnabled(false);
                return;
            }
            item.addActionListener(aEvt -> StringUtils.copyTextToClipboard(seq));
        }

        void addBlatItem(TrackClickEvent te) {
            JMenuItem item = new JMenuItem("Blat read sequence");
            this.add(item);
            Alignment alignment = AlignmentTrack.this.getSpecficAlignment(te);
            if (alignment == null) {
                item.setEnabled(false);
                return;
            }
            String seq = alignment.getReadSequence();
            if (seq == null || seq.equals("*")) {
                item.setEnabled(false);
                return;
            }
            item.addActionListener(aEvt -> {
                String blatSeq = alignment.getReadStrand() == Strand.NEGATIVE ? SequenceTrack.getReverseComplement(seq) : seq;
                BlatClient.doBlatQuery(blatSeq, alignment.getReadName());
            });
        }

        void addBlatClippingItems(TrackClickEvent te) {
            Alignment alignment = AlignmentTrack.this.getSpecficAlignment(te);
            if (alignment == null) {
                return;
            }
            int minimumBlatLength = 20;
            int[] clipping = SAMAlignment.getClipping(alignment.getCigarString());
            if (clipping[1] > 0) {
                String lcSeq = this.getClippedSequence(alignment.getReadSequence(), alignment.getReadStrand(), 0, clipping[1]);
                JMenuItem lccItem = new JMenuItem("Copy left-clipped sequence");
                this.add(lccItem);
                lccItem.addActionListener(aEvt -> StringUtils.copyTextToClipboard(lcSeq));
                if (clipping[1] > minimumBlatLength) {
                    JMenuItem lcbItem = new JMenuItem("Blat left-clipped sequence");
                    this.add(lcbItem);
                    lcbItem.addActionListener(aEvt -> BlatClient.doBlatQuery(lcSeq, alignment.getReadName() + " - left clip"));
                }
            }
            if (clipping[3] > 0) {
                String seq = alignment.getReadSequence();
                int seqLength = seq.length();
                String rcSeq = this.getClippedSequence(alignment.getReadSequence(), alignment.getReadStrand(), seqLength - clipping[3], seqLength);
                JMenuItem rccItem = new JMenuItem("Copy right-clipped sequence");
                this.add(rccItem);
                rccItem.addActionListener(aEvt -> StringUtils.copyTextToClipboard(rcSeq));
                if (clipping[3] > minimumBlatLength) {
                    JMenuItem rcbItem = new JMenuItem("Blat right-clipped sequence");
                    this.add(rcbItem);
                    rcbItem.addActionListener(aEvt -> BlatClient.doBlatQuery(rcSeq, alignment.getReadName() + " - right clip"));
                }
            }
        }

        private String getClippedSequence(String readSequence, Strand strand, int i, int i2) {
            if (readSequence == null || readSequence.equals("*")) {
                return "*";
            }
            String seq = readSequence.substring(i, i2);
            if (strand == Strand.NEGATIVE) {
                seq = SequenceTrack.getReverseComplement(seq);
            }
            return seq;
        }

        void addExtViewItem(TrackClickEvent te) {
            JMenuItem item = new JMenuItem("ExtView");
            this.add(item);
            Alignment alignment = AlignmentTrack.this.getAlignment(te);
            if (alignment == null) {
                item.setEnabled(false);
                return;
            }
            String seq = alignment.getReadSequence();
            if (seq == null) {
                item.setEnabled(false);
                return;
            }
            item.addActionListener(aEvt -> ExtendViewClient.postExtendView(alignment));
        }

        void addLinkedReadItems() {
            this.addSeparator();
            this.add(this.linkedReadViewItem("BX"));
            this.add(this.linkedReadViewItem("MI"));
            this.addSeparator();
            JCheckBoxMenuItem supplementalItem = new JCheckBoxMenuItem("Link supplementary alignments");
            supplementalItem.setSelected(AlignmentTrack.this.isLinkedReads() && "READNAME".equals(AlignmentTrack.this.renderOptions.getLinkByTag()));
            supplementalItem.addActionListener(aEvt -> {
                boolean linkedReads = supplementalItem.isSelected();
                AlignmentTrack.this.setLinkByTag(linkedReads, "READNAME");
            });
            this.add(supplementalItem);
            String linkedTagsString = PreferencesManager.getPreferences().get("SAM.LINK_BY_TAGS");
            if (linkedTagsString != null) {
                String[] t;
                for (String tag : t = Globals.commaPattern.split(linkedTagsString)) {
                    if (tag.length() <= 0) continue;
                    this.add(this.linkedReadItem(tag));
                }
            }
            JMenuItem linkByTagItem = new JMenuItem("Link by tag...");
            linkByTagItem.addActionListener(aEvt -> {
                String tag = MessageUtils.showInputDialog("Link by tag:");
                if (tag != null) {
                    AlignmentTrack.this.setLinkByTag(true, tag);
                    Object linkedTags = PreferencesManager.getPreferences().get("SAM.LINK_BY_TAGS");
                    linkedTags = linkedTags == null ? tag : (String)linkedTags + "," + tag;
                    PreferencesManager.getPreferences().put("SAM.LINK_BY_TAGS", (String)linkedTags);
                }
            });
            this.add(linkByTagItem);
        }

        private JCheckBoxMenuItem linkedReadViewItem(String tag) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Linked read view (" + tag + ")");
            item.setSelected(AlignmentTrack.this.isLinkedReadView() && tag != null && tag.equals(AlignmentTrack.this.renderOptions.getLinkByTag()));
            item.addActionListener(aEvt -> {
                boolean linkedReads = item.isSelected();
                AlignmentTrack.this.setLinkedReadView(linkedReads, tag);
            });
            return item;
        }

        private JCheckBoxMenuItem linkedReadItem(String tag) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Link by " + tag);
            item.setSelected(!AlignmentTrack.this.isLinkedReadView() && AlignmentTrack.this.isLinkedReads() && tag.equals(AlignmentTrack.this.renderOptions.getLinkByTag()));
            item.addActionListener(aEvt -> {
                boolean linkedReads = item.isSelected();
                AlignmentTrack.this.setLinkByTag(linkedReads, tag);
            });
            return item;
        }

        private void addInsertionItems(AlignmentBlock insertion) {
            JMenuItem item = new JMenuItem("Copy insert sequence");
            this.add(item);
            item.addActionListener(aEvt -> StringUtils.copyTextToClipboard(insertion.getBases().getString()));
            if (insertion.getBases() != null && insertion.getBases().length >= 10) {
                JMenuItem blatItem = new JMenuItem("Blat insert sequence");
                this.add(blatItem);
                blatItem.addActionListener(aEvt -> {
                    String blatSeq = insertion.getBases().getString();
                    BlatClient.doBlatQuery(blatSeq, "Blat insert sequence");
                });
            }
        }
    }

    private static class InsertionInterval {
        final Rectangle rect;
        final InsertionMarker insertionMarker;

        InsertionInterval(Rectangle rect, InsertionMarker insertionMarker) {
            this.rect = rect;
            this.insertionMarker = insertionMarker;
        }
    }

    private static class Deselector
    implements ActionListener {
        private final JMenuItem toDeselect;
        private final JMenuItem parent;

        Deselector(JMenuItem parent, JMenuItem toDeselect) {
            this.parent = parent;
            this.toDeselect = toDeselect;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.parent.isSelected()) {
                this.toDeselect.setSelected(false);
            }
        }
    }

    class RenderRollback {
        final ColorOption colorOption;
        final GroupOption groupByOption;
        final String groupByTag;
        final String colorByTag;
        final String linkByTag;
        final Track.DisplayMode displayMode;
        final int expandedHeight;
        final boolean showGroupLine;

        RenderRollback(RenderOptions renderOptions, Track.DisplayMode displayMode) {
            this.colorOption = renderOptions.colorOption;
            this.groupByOption = renderOptions.groupByOption;
            this.colorByTag = renderOptions.colorByTag;
            this.groupByTag = renderOptions.groupByTag;
            this.displayMode = displayMode;
            this.expandedHeight = AlignmentTrack.this.expandedHeight;
            this.showGroupLine = AlignmentTrack.this.showGroupLine;
            this.linkByTag = renderOptions.linkByTag;
        }

        void restore(RenderOptions renderOptions) {
            renderOptions.colorOption = this.colorOption;
            renderOptions.groupByOption = this.groupByOption;
            renderOptions.colorByTag = this.colorByTag;
            renderOptions.groupByTag = this.groupByTag;
            renderOptions.linkByTag = this.linkByTag;
            AlignmentTrack.this.expandedHeight = this.expandedHeight;
            AlignmentTrack.this.showGroupLine = this.showGroupLine;
            AlignmentTrack.this.setDisplayMode(this.displayMode);
        }
    }

    public static enum ExperimentType {
        OTHER,
        RNA,
        BISULFITE,
        THIRD_GEN;

    }

    static enum OrientationType {
        RR,
        LL,
        RL,
        LR,
        UNKNOWN;

    }

    public static enum BisulfiteContext {
        CG,
        CHH,
        CHG,
        HCG,
        GCH,
        WCG,
        NONE;

    }

    public static enum GroupOption {
        STRAND("read strand"),
        SAMPLE("sample"),
        READ_GROUP("read group"),
        LIBRARY("library"),
        FIRST_OF_PAIR_STRAND("first-in-pair strand"),
        TAG("tag"),
        PAIR_ORIENTATION("pair orientation"),
        MATE_CHROMOSOME("chromosome of mate"),
        NONE("none"),
        SUPPLEMENTARY("supplementary flag"),
        BASE_AT_POS("base at position"),
        MOVIE("movie"),
        ZMW("ZMW"),
        HAPLOTYPE("haplotype"),
        READ_ORDER("read order"),
        LINKED("linked"),
        PHASE("phase"),
        REFERENCE_CONCORDANCE("reference concordance");

        public String label;

        private GroupOption(String label) {
            this.label = label;
        }
    }

    public static enum SortOption {
        START,
        STRAND,
        NUCLEOTIDE,
        QUALITY,
        SAMPLE,
        READ_GROUP,
        INSERT_SIZE,
        FIRST_OF_PAIR_STRAND,
        MATE_CHR,
        TAG,
        SUPPLEMENTARY,
        NONE,
        HAPLOTYPE,
        READ_ORDER,
        READ_NAME;

    }

    public static enum ColorOption {
        INSERT_SIZE,
        READ_STRAND,
        FIRST_OF_PAIR_STRAND,
        PAIR_ORIENTATION,
        SAMPLE,
        READ_GROUP,
        LIBRARY,
        MOVIE,
        ZMW,
        BISULFITE,
        NOMESEQ,
        TAG,
        NONE,
        UNEXPECTED_PAIR,
        MAPPED_SIZE,
        LINK_STRAND,
        YC_TAG,
        BASE_MODIFICATION;

    }
}

