/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.log4j.Logger;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.ftp.FTPUtils;

public class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String FILE_SEP = System.getProperty("file.separator");
    static final String[] igvJnlpPrefixes = new String[]{"igv", "ichip", "29mammals", "hic"};

    public static boolean resourceExists(String path) {
        if (path == null) {
            return false;
        }
        if (FileUtils.isRemote(path)) {
            return HttpUtils.getInstance().resourceAvailable(path);
        }
        if (path.startsWith("file://")) {
            path = path.substring(7);
        }
        return new File(path).exists();
    }

    public static boolean isRemote(String path) {
        if (path == null) {
            return false;
        }
        return path.startsWith("http://") || path.startsWith("https://") || path.startsWith("ftp://") || path.startsWith("gs://") || path.startsWith("s3://") || path.startsWith("htsget://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWriteTo(File file) {
        Object fos = null;
        try {
            file.createNewFile();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            file.delete();
        }
    }

    public static String getInstallDirectory() {
        String path = FileUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File f = new File(path);
        if (f.isDirectory()) {
            return f.getAbsolutePath();
        }
        return f.getParentFile().getAbsolutePath();
    }

    public static String getRelativePath(String basePath, String targetPath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (pathSeparator.equals("\\")) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuffer common = new StringBuffer();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            return targetPath;
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuffer relative = new StringBuffer();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }

    public static String getPlatformIndependentPath(String path) {
        return path.replace('\\', '/');
    }

    public static String getRelativePath(String basePath, String targetPath) {
        return FileUtils.getRelativePath(basePath, targetPath, FILE_SEP);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTabDelimited(ResourceLocator loc, int minColumnCount) throws IOException {
        try (BufferedReader reader = null;){
            String nextLine;
            reader = ParsingUtils.openBufferedReader(loc.getPath());
            int nLinesTested = 0;
            while ((nextLine = reader.readLine()) != null && nLinesTested < 1000) {
                if (nextLine.startsWith("#")) continue;
                ++nLinesTested;
                String[] tokens = nextLine.split("\t");
                if (tokens.length < minColumnCount) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFirstLine(String path, String commentChar) throws IOException {
        if (path == null) {
            return null;
        }
        try (BufferedReader reader = null;){
            String nextLine;
            reader = ParsingUtils.openBufferedReader(path);
            while ((nextLine = reader.readLine()) != null) {
                if (commentChar != null && nextLine.startsWith(commentChar)) continue;
                String string = nextLine;
                return string;
            }
            String string = null;
            return string;
        }
    }

    public static void copyFile(File inputFile, File outputFile) throws IOException {
        OutputStream out = null;
        FileInputStream in = null;
        try {
            int bytes_read;
            in = new FileInputStream(inputFile);
            out = new FileOutputStream(outputFile);
            byte[] buffer = new byte[64000];
            while ((bytes_read = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, bytes_read);
            }
        }
        catch (Exception e) {
            outputFile.delete();
            throw new RuntimeException("<html>Error copying file: " + outputFile.getAbsoluteFile() + "<br/>" + e.toString());
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    private static void cleanup(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] jnlpFiles = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    String name = arg0.getName();
                    for (String pre : igvJnlpPrefixes) {
                        if (!name.startsWith(pre) || !name.endsWith(".jnlp")) continue;
                        return true;
                    }
                    return false;
                }
            });
            Arrays.sort(jnlpFiles, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    if (org.apache.commons.io.FileUtils.isFileNewer((File)file1, (File)file2)) {
                        return 1;
                    }
                    return -1;
                }
            });
            for (int i = 0; i < jnlpFiles.length - 1; ++i) {
                jnlpFiles[i].delete();
            }
            if (jnlpFiles.length > 1) {
                File newestFile = jnlpFiles[jnlpFiles.length - 1];
                String fn = newestFile.getName();
                int dotIndex = fn.indexOf(".jnlp");
                int dashIndex = fn.lastIndexOf("-");
                if (dashIndex > 1) {
                    String newName = fn.substring(0, dashIndex) + fn.substring(dotIndex);
                    newestFile.renameTo(new File(newestFile.getParentFile(), newName));
                }
            }
        }
    }

    public static String getFileExtension(String filePath) {
        String extension = null;
        int indexOfExtension = filePath.lastIndexOf(".");
        if (indexOfExtension >= 0) {
            extension = filePath.substring(indexOfExtension, filePath.length());
        }
        return extension;
    }

    public static String getAbsolutePath(String inputPath, String referencePath) {
        Object absolutePath;
        if (FileUtils.isRemote(inputPath) || referencePath == null) {
            return inputPath;
        }
        File inFile = new File(inputPath);
        if (inFile.isAbsolute()) {
            return inFile.getAbsolutePath();
        }
        if (FileUtils.isRemote(referencePath)) {
            int idx = referencePath.lastIndexOf("/");
            String basePath = referencePath.substring(0, idx);
            absolutePath = basePath + "/" + inputPath;
        } else {
            File referenceFile = new File(referencePath);
            File parent = referenceFile.isDirectory() ? referenceFile : referenceFile.getParentFile();
            File file = new File(parent, inputPath);
            try {
                absolutePath = file.getCanonicalPath();
            }
            catch (IOException e) {
                absolutePath = file.getAbsolutePath();
            }
        }
        return absolutePath;
    }

    public static String getParent(String path) {
        String piPath = FileUtils.getPlatformIndependentPath(path);
        int lastSlashIdx = piPath.lastIndexOf("/");
        return lastSlashIdx <= 0 ? path : path.substring(0, lastSlashIdx);
    }

    public static String findExecutableOnPath(String executable) {
        if (executable.contains(File.separator)) {
            return executable;
        }
        String systemPath = System.getenv("PATH");
        if (systemPath == null) {
            systemPath = System.getenv("path");
        }
        if (systemPath == null || File.pathSeparator == null) {
            return executable;
        }
        String[] pathDirs = systemPath.split(File.pathSeparator);
        String fullPath = executable;
        for (String pathDir : pathDirs) {
            File file = new File(pathDir, executable);
            if (!file.isFile()) continue;
            fullPath = file.getAbsolutePath();
            break;
        }
        return fullPath;
    }

    public static long getLength(String file) {
        if (FileUtils.isRemote(file)) {
            try {
                URL url = HttpUtils.createURL(file);
                if (file.startsWith("ftp://")) {
                    return FTPUtils.getContentLength(url);
                }
                return HttpUtils.getInstance().getContentLength(url);
            }
            catch (Exception e) {
                log.error((Object)("Error fetching content length for: " + file), (Throwable)e);
                return -1L;
            }
        }
        File f = new File(file);
        if (f.exists() && f.isFile()) {
            return f.length();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(String path) throws IOException {
        try (BufferedReader reader = null;){
            String nextLine;
            reader = ParsingUtils.openBufferedReader(path);
            StringBuilder contents = new StringBuilder();
            PrintWriter pw = new PrintWriter((Writer)new StringBuilderWriter(contents));
            while ((nextLine = reader.readLine()) != null) {
                pw.println(nextLine);
            }
            String string = contents.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(String aInputFileName) {
        File file = new File(aInputFileName);
        byte[] result = new byte[(int)file.length()];
        try (InputStream input = null;){
            int totalBytesRead = 0;
            input = new BufferedInputStream(new FileInputStream(file));
            while (totalBytesRead < result.length) {
                int bytesRemaining = result.length - totalBytesRead;
                int bytesRead = input.read(result, totalBytesRead, bytesRemaining);
                if (bytesRead <= 0) continue;
                totalBytesRead += bytesRead;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

