/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.event.RefreshEvent;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTileLoader;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PackedAlignments;
import org.broad.igv.sam.ReadStats;
import org.broad.igv.sam.Row;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.track.Track;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.ResourceLocator;

public class AlignmentDataManager
implements IGVEventObserver {
    private static Logger log = Logger.getLogger(AlignmentDataManager.class);
    private final AlignmentReader reader;
    private AlignmentTrack alignmentTrack;
    private CoverageTrack coverageTrack;
    private Set<Track> subscribedTracks;
    private List<AlignmentInterval> intervalCache;
    private ResourceLocator locator;
    private HashMap<String, String> chrMappings = new HashMap();
    private AlignmentTileLoader loader;
    private Map<String, PEStats> peStats;
    private SpliceJunctionHelper.LoadOptions loadOptions;
    private Range currentlyLoading;

    public AlignmentDataManager(ResourceLocator locator, Genome genome) throws IOException {
        this.locator = locator;
        this.reader = AlignmentReaderFactory.getReader(locator);
        this.loader = new AlignmentTileLoader(this.reader);
        this.peStats = new HashMap<String, PEStats>();
        this.initLoadOptions();
        this.initChrMap(genome);
        this.intervalCache = Collections.synchronizedList(new ArrayList());
        this.subscribedTracks = Collections.synchronizedSet(new HashSet());
        IGVEventBus.getInstance().subscribe(FrameManager.ChangeEvent.class, this);
        IGVEventBus.getInstance().subscribe(RefreshEvent.class, this);
    }

    @Override
    public void receiveEvent(Object event) {
        if (event instanceof FrameManager.ChangeEvent) {
            this.trimCache();
        } else if (event instanceof RefreshEvent) {
            this.clear();
        } else {
            log.info((Object)("Unknown event type: " + event.getClass()));
        }
    }

    public void subscribe(Track track) {
        this.subscribedTracks.add(track);
    }

    public void unsubscribe(Track track) {
        this.subscribedTracks.remove(track);
        if (this.subscribedTracks.isEmpty()) {
            this.dispose();
            this.dumpAlignments();
            IGVEventBus.getInstance().unsubscribe(this);
        }
    }

    void initLoadOptions() {
        this.loadOptions = new SpliceJunctionHelper.LoadOptions();
    }

    private void initChrMap(Genome genome) throws IOException {
        if (genome != null) {
            List<String> seqNames;
            HashMap<Long, String> inverseDict = null;
            Map<String, Long> sequenceDictionary = this.checkReader().getSequenceDictionary();
            if (sequenceDictionary != null) {
                HashSet<Long> nonUnique = new HashSet<Long>();
                HashSet<Long> seen = new HashSet<Long>();
                for (Long size : sequenceDictionary.values()) {
                    if (seen.contains(size)) {
                        nonUnique.add(size);
                        continue;
                    }
                    seen.add(size);
                }
                inverseDict = new HashMap<Long, String>();
                for (Chromosome chromosome : genome.getChromosomes()) {
                    Long size = chromosome.getLength();
                    if (nonUnique.contains(size)) continue;
                    if (inverseDict.containsKey(size)) {
                        inverseDict.remove(size);
                        nonUnique.add(size);
                        continue;
                    }
                    inverseDict.put(size, chromosome.getName());
                }
            }
            if ((seqNames = this.checkReader().getSequenceNames()) != null) {
                for (String seq : seqNames) {
                    String chr;
                    Long size;
                    if (genome.isKnownChr(seq)) {
                        String chr2 = genome.getCanonicalChrName(seq);
                        this.chrMappings.put(chr2, seq);
                        continue;
                    }
                    if (sequenceDictionary == null || (chr = (String)inverseDict.get(size = sequenceDictionary.get(seq))) == null) continue;
                    this.chrMappings.put(chr, seq);
                }
            }
        }
    }

    public boolean hasMatchingSequences() {
        return this.chrMappings.size() > 0;
    }

    public AlignmentTileLoader getLoader() {
        return this.checkReader();
    }

    public ResourceLocator getLocator() {
        return this.locator;
    }

    public Map<String, PEStats> getPEStats() {
        return this.peStats;
    }

    public boolean isPairedEnd() {
        return this.checkReader().isPairedEnd();
    }

    public boolean hasYCTags() {
        return this.checkReader().hasYCTags();
    }

    public boolean hasIndex() {
        return this.checkReader().hasIndex();
    }

    public void setAlignmentTrack(AlignmentTrack alignmentTrack) {
        this.alignmentTrack = alignmentTrack;
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public double getMinVisibleScale() {
        return this.getVisibilityWindow() / 700.0;
    }

    public double getVisibilityWindow() {
        return this.getPreferences().getAsFloat("SAM.MAX_VISIBLE_RANGE") * 1000.0f;
    }

    private IGVPreferences getPreferences() {
        String category = "NULL";
        AlignmentTrack.ExperimentType experimentType = this.getExperimentType();
        if (experimentType == AlignmentTrack.ExperimentType.RNA) {
            category = "RNA";
        } else if (experimentType == AlignmentTrack.ExperimentType.THIRD_GEN) {
            category = "THIRD_GEN";
        }
        return PreferencesManager.getPreferences(category);
    }

    public List<String> getSequenceNames() throws IOException {
        return this.checkReader().getSequenceNames();
    }

    public Map<String, Long> getSequenceDictionary() {
        return this.checkReader().getSequenceDictionary();
    }

    public AlignmentInterval getLoadedInterval(ReferenceFrame frame) {
        return this.getLoadedInterval(frame, false);
    }

    public AlignmentInterval getLoadedInterval(ReferenceFrame frame, boolean includeOverlaps) {
        for (AlignmentInterval interval : this.intervalCache) {
            if (!interval.contains(frame.getCurrentRange())) continue;
            return interval;
        }
        if (includeOverlaps) {
            for (AlignmentInterval interval : this.intervalCache) {
                if (!interval.overlaps(frame.getCurrentRange())) continue;
                return interval;
            }
        }
        return null;
    }

    public boolean sortRows(AlignmentTrack.SortOption option, ReferenceFrame frame, double location, String tag) {
        AlignmentInterval interval = this.getLoadedInterval(frame);
        if (interval == null) {
            return false;
        }
        PackedAlignments packedAlignments = interval.getPackedAlignments();
        if (packedAlignments == null) {
            return false;
        }
        for (List alignmentRows : packedAlignments.values()) {
            for (Row row : alignmentRows) {
                row.updateScore(option, location, interval, tag);
            }
            Collections.sort(alignmentRows);
        }
        return true;
    }

    public void setViewAsPairs(boolean option, AlignmentTrack.RenderOptions renderOptions) {
        if (option == renderOptions.isViewPairs()) {
            return;
        }
        renderOptions.setViewPairs(option);
        this.packAlignments(renderOptions);
    }

    void packAlignments(AlignmentTrack.RenderOptions renderOptions) {
        for (AlignmentInterval interval : this.intervalCache) {
            interval.packAlignments(renderOptions);
        }
    }

    public boolean isLoaded(ReferenceFrame frame) {
        return this.getLoadedInterval(frame) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ReferenceFrame frame, AlignmentTrack.RenderOptions renderOptions, boolean expandEnds) {
        if (frame.getChrName().equals("All") || frame.getScale() > this.getMinVisibleScale()) {
            return;
        }
        if (this.isLoaded(frame)) {
            return;
        }
        Range range = frame.getCurrentRange();
        String chr = frame.getChrName();
        int start = range.getStart();
        int end = range.getEnd();
        int adjustedStart = start;
        int adjustedEnd = end;
        Range adjustedRange = new Range(chr, start, end);
        if (this.currentlyLoading != null && this.currentlyLoading.contains(adjustedRange)) {
            return;
        }
        try {
            this.currentlyLoading = adjustedRange;
            int windowSize = Math.min(4 * (end - start), PreferencesManager.getPreferences().getAsInt("SAM.MAX_VISIBLE_RANGE") * 1000);
            int center = start + (end - start) / 2;
            int expand = Math.min(Integer.MAX_VALUE - center, Math.max(end - start, windowSize / 2));
            if (expandEnds) {
                adjustedStart = Math.max(0, Math.min(start, center - expand));
                adjustedEnd = Math.max(end, center + expand);
                if (adjustedEnd < 0) {
                    adjustedEnd = Integer.MAX_VALUE;
                }
            }
            AlignmentInterval loadedInterval = this.loadInterval(chr, adjustedStart, adjustedEnd, renderOptions);
            this.trimCache();
            this.intervalCache.add(loadedInterval);
            this.packAlignments(renderOptions);
        }
        finally {
            this.currentlyLoading = null;
        }
    }

    private void trimCache() {
        ArrayList<AlignmentInterval> trimmedIntervals = new ArrayList<AlignmentInterval>();
        for (AlignmentInterval interval : this.intervalCache) {
            if (!this.intervalInView(interval)) continue;
            trimmedIntervals.add(interval);
        }
        this.intervalCache = trimmedIntervals;
    }

    private boolean intervalInView(AlignmentInterval interval) {
        for (ReferenceFrame frame : FrameManager.getFrames()) {
            if (!interval.contains(frame.getCurrentRange())) continue;
            return true;
        }
        return false;
    }

    AlignmentInterval loadInterval(String chr, int start, int end, AlignmentTrack.RenderOptions renderOptions) {
        String sequence = this.chrMappings.containsKey(chr) ? this.chrMappings.get(chr) : chr;
        DownsampleOptions downsampleOptions = new DownsampleOptions();
        AlignmentTrack.BisulfiteContext bisulfiteContext = renderOptions != null ? renderOptions.bisulfiteContext : null;
        SpliceJunctionHelper spliceJunctionHelper = new SpliceJunctionHelper(this.loadOptions);
        AlignmentTileLoader.AlignmentTile t = this.checkReader().loadTile(sequence, start, end, spliceJunctionHelper, downsampleOptions, this.peStats, bisulfiteContext);
        List<Alignment> alignments = t.getAlignments();
        List<DownsampledInterval> downsampledIntervals = t.getDownsampledIntervals();
        return new AlignmentInterval(chr, start, end, alignments, t.getCounts(), spliceJunctionHelper, downsampledIntervals);
    }

    public AlignmentTrack.ExperimentType inferType() {
        ReadStats readStats = new ReadStats();
        List<Alignment> sample = AlignmentUtils.firstAlignments(this.reader, 1000);
        for (Alignment a : sample) {
            readStats.addAlignment(a);
        }
        readStats.compute();
        if (readStats.readCount < 100) {
            return null;
        }
        if (readStats.readLengthStdDev > 100.0 || readStats.medianReadLength > 1000.0) {
            return AlignmentTrack.ExperimentType.THIRD_GEN;
        }
        if (readStats.medianRefToReadRatio > 10.0 || readStats.fracReadsWithNs > 0.2) {
            return AlignmentTrack.ExperimentType.RNA;
        }
        return AlignmentTrack.ExperimentType.OTHER;
    }

    private AlignmentTrack.ExperimentType getExperimentType() {
        return this.alignmentTrack == null ? null : this.alignmentTrack.getExperimentType();
    }

    private void setExperimentType(AlignmentTrack.ExperimentType type) {
        if (this.alignmentTrack != null) {
            this.alignmentTrack.setExperimentType(type);
        }
    }

    public PackedAlignments getGroups(AlignmentInterval interval, AlignmentTrack.RenderOptions renderOptions) {
        if (interval != null) {
            return interval.getPackedAlignments();
        }
        return null;
    }

    public void clear() {
        this.intervalCache.clear();
    }

    public void dumpAlignments() {
        for (AlignmentInterval interval : this.intervalCache) {
            interval.dumpAlignments();
        }
    }

    public PackedAlignments getGroupedAlignmentsContaining(double position, ReferenceFrame frame) {
        String chr = frame.getChrName();
        int start = (int)position;
        int end = start + 1;
        AlignmentInterval interval = this.getLoadedInterval(frame);
        if (interval == null) {
            return null;
        }
        PackedAlignments packedAlignments = interval.getPackedAlignments();
        if (packedAlignments != null && packedAlignments.contains(chr, start, end)) {
            return packedAlignments;
        }
        return null;
    }

    public int getNLevels() {
        int nLevels = 0;
        for (AlignmentInterval interval : this.intervalCache) {
            PackedAlignments packedAlignments = interval.getPackedAlignments();
            if (packedAlignments == null) continue;
            int intervalNLevels = packedAlignments.getNLevels();
            nLevels = Math.max(nLevels, intervalNLevels);
        }
        return nLevels;
    }

    public int getMaxGroupCount() {
        int groupCount = 0;
        for (AlignmentInterval interval : this.intervalCache) {
            PackedAlignments packedAlignments;
            if (interval == null || (packedAlignments = interval.getPackedAlignments()) == null) continue;
            groupCount = Math.max(groupCount, packedAlignments.size());
        }
        return groupCount;
    }

    private void dispose() {
        if (this.loader != null) {
            try {
                this.loader.close();
            }
            catch (IOException ex) {
                log.error((Object)"Error closing AlignmentQueryReader. ", (Throwable)ex);
            }
        }
    }

    public void updatePEStats(AlignmentTrack.RenderOptions renderOptions) {
        if (this.peStats != null) {
            for (PEStats stats : this.peStats.values()) {
                stats.computeInsertSize(renderOptions.getMinInsertSizePercentile(), renderOptions.getMaxInsertSizePercentile());
            }
        }
    }

    public SpliceJunctionHelper.LoadOptions getSpliceJunctionLoadOptions() {
        return this.loadOptions;
    }

    public void setMinJunctionCoverage(int minJunctionCoverage) {
        this.loadOptions = new SpliceJunctionHelper.LoadOptions(minJunctionCoverage, this.loadOptions.minReadFlankingWidth);
        for (AlignmentInterval interval : this.intervalCache) {
            interval.getSpliceJunctionHelper().setLoadOptions(this.loadOptions);
        }
    }

    public void alleleThresholdChanged() {
        this.coverageTrack.setSnpThreshold(PreferencesManager.getPreferences().getAsFloat("SAM.ALLELE_THRESHOLD"));
    }

    public boolean isTenX() {
        return this.checkReader().isTenX();
    }

    public boolean isPhased() {
        return this.checkReader().isPhased();
    }

    public boolean isMoleculo() {
        return this.checkReader().isMoleculo();
    }

    public Collection<AlignmentInterval> getLoadedIntervals() {
        return this.intervalCache;
    }

    private AlignmentTileLoader checkReader() {
        try {
            String aPath = this.locator.getPath();
            if (AmazonUtils.isAwsS3Path(aPath).booleanValue() && !AmazonUtils.isS3PresignedValid(aPath)) {
                this.loader = new AlignmentTileLoader(AlignmentReaderFactory.getReader(this.locator));
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.loader;
    }

    static class IntervalCache {
        private int maxSize;
        ArrayList<AlignmentInterval> intervals;

        public IntervalCache() {
            this(1);
        }

        public IntervalCache(int ms) {
            this.maxSize = Math.max(1, ms);
            this.intervals = new ArrayList(this.maxSize);
        }

        void setMaxSize(int ms, List<ReferenceFrame> frames) {
            this.maxSize = Math.max(1, ms);
            if (this.intervals.size() > this.maxSize) {
                if (frames.size() * this.intervals.size() < 25) {
                    ArrayList<AlignmentInterval> tmp = new ArrayList<AlignmentInterval>(this.maxSize);
                    block0: for (AlignmentInterval interval : this.intervals) {
                        if (tmp.size() == this.maxSize) break;
                        for (ReferenceFrame frame : frames) {
                            Range range = frame.getCurrentRange();
                            if (!interval.contains(range.getChr(), range.getStart(), range.getEnd())) continue;
                            tmp.add(interval);
                            continue block0;
                        }
                    }
                    this.intervals = tmp;
                } else {
                    this.intervals = new ArrayList<AlignmentInterval>(this.intervals.subList(0, this.maxSize));
                    this.intervals.trimToSize();
                }
            }
        }

        public void add(AlignmentInterval interval) {
            if (this.intervals.size() >= this.maxSize) {
                this.intervals.remove(0);
            }
            this.intervals.add(interval);
        }

        public AlignmentInterval getIntervalForRange(Range range) {
            for (AlignmentInterval interval : this.intervals) {
                if (!interval.contains(range.getChr(), range.getStart(), range.getEnd())) continue;
                return interval;
            }
            return null;
        }

        public Collection<AlignmentInterval> values() {
            return this.intervals;
        }

        public void clear() {
            this.intervals.clear();
        }
    }

    public static class DownsampleOptions {
        private boolean downsample;
        private int sampleWindowSize;
        private int maxReadCount;

        public DownsampleOptions() {
            IGVPreferences prefs = PreferencesManager.getPreferences();
            this.init(prefs.getAsBoolean("SAM.DOWNSAMPLE_READS"), prefs.getAsInt("SAM.SAMPLING_WINDOW"), prefs.getAsInt("SAM.MAX_LEVELS"));
        }

        DownsampleOptions(boolean downsample, int sampleWindowSize, int maxReadCount) {
            this.init(downsample, sampleWindowSize, maxReadCount);
        }

        private void init(boolean downsample, int sampleWindowSize, int maxReadCount) {
            this.downsample = downsample;
            this.sampleWindowSize = sampleWindowSize;
            this.maxReadCount = maxReadCount;
        }

        public boolean isDownsample() {
            return this.downsample;
        }

        public int getSampleWindowSize() {
            return this.sampleWindowSize;
        }

        public int getMaxReadCount() {
            return this.maxReadCount;
        }
    }
}

