/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.ReferenceLocation;
import org.campagnelab.goby.modes.core.UpgradeModeCore;
import org.campagnelab.goby.util.FileExtensionHelper;

public abstract class AbstractAlignmentReader
implements Closeable,
Iterator<Alignments.AlignmentEntry>,
Iterable<Alignments.AlignmentEntry> {
    protected IndexedIdentifier queryIdentifiers;
    protected int numberOfQueries;
    protected IndexedIdentifier targetIdentifiers;
    protected int numberOfTargets;
    protected int[] targetLengths;
    private boolean headerLoaded;
    protected boolean constantQueryLengths;
    protected int constantLength;
    protected int smallestQueryIndex;
    protected int largestQueryIndex;
    protected String alignerName;
    protected String alignerVersion;
    protected ObjectArrayList<String> sampleBasenames = new ObjectArrayList();

    protected AbstractAlignmentReader(boolean upgrade, String basename) {
        if (basename != null && upgrade) {
            UpgradeModeCore upgrader = new UpgradeModeCore();
            upgrader.setSilent(true);
            upgrader.upgrade(basename);
        }
    }

    public static String getBasename(String filename) {
        for (String ext : FileExtensionHelper.COMPACT_ALIGNMENT_FILE_EXTS) {
            if (!StringUtils.endsWith((String)filename, (String)ext)) continue;
            return StringUtils.removeEnd((String)filename, (String)ext);
        }
        return filename;
    }

    public static String[] getBasenames(String ... filenames) {
        ObjectArraySet result = new ObjectArraySet();
        ObjectArrayList unique = new ObjectArrayList();
        if (filenames != null) {
            for (String filename : filenames) {
                String newBasename = AbstractAlignmentReader.getBasename(filename);
                if (result.contains((Object)newBasename)) continue;
                unique.add((Object)newBasename);
                result.add((Object)AbstractAlignmentReader.getBasename(filename));
            }
        }
        return (String[])unique.toArray((Object[])new String[unique.size()]);
    }

    public int getSmallestSplitQueryIndex() {
        return this.smallestQueryIndex;
    }

    public int getLargestSplitQueryIndex() {
        return this.largestQueryIndex;
    }

    public int getNumberOfQueries() {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access number of queries";
        return Math.max(0, Math.max(this.numberOfQueries, this.largestQueryIndex - this.smallestQueryIndex));
    }

    protected final boolean isHeaderLoaded() {
        return this.headerLoaded;
    }

    protected void setHeaderLoaded(boolean headerLoaded) {
        this.headerLoaded = headerLoaded;
    }

    public abstract void readHeader() throws IOException;

    public final IndexedIdentifier getQueryIdentifiers() {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access query identifiers";
        return this.queryIdentifiers;
    }

    public final IndexedIdentifier getTargetIdentifiers() {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access target identifiers";
        return this.targetIdentifiers;
    }

    public int getNumberOfTargets() {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access number of targets";
        return Math.max(0, this.numberOfTargets);
    }

    public final int getTargetLength(int targetIndex) {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access target lengths";
        assert (this.targetLengths != null) : "Target lengths must exist in the header.";
        return this.targetLengths[targetIndex];
    }

    public final int[] getTargetLength() {
        assert (this.isHeaderLoaded()) : "Header must be loaded to access target lengths";
        return this.targetLengths;
    }

    public boolean isConstantQueryLengths() {
        return this.constantQueryLengths;
    }

    public String getAlignerName() {
        return this.alignerName;
    }

    public String getAlignerVersion() {
        return this.alignerVersion;
    }

    public String getSampleBasename(int sampleIndex) {
        return (String)this.sampleBasenames.get(sampleIndex);
    }

    public abstract ReferenceLocation getMinLocation() throws IOException;

    public abstract ReferenceLocation getMaxLocation() throws IOException;
}

