/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.BisulfiteCounts;
import org.broad.igv.sam.ByteSubarray;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.track.WindowFunction;

public class ReducedMemoryAlignment
implements Alignment {
    private static Logger log = Logger.getLogger(ReducedMemoryAlignment.class);
    private final String cigarString;
    private String readName;
    private String chromosome;
    private int start;
    private int end;
    boolean negativeStrand;
    AlignmentBlock[] blocks;
    AlignmentBlock[] insertions;
    List<Gap> gaps;

    public ReducedMemoryAlignment(Alignment al, int indelLimit) {
        List<Gap> gaps;
        AlignmentBlock[] insertions;
        this.negativeStrand = al.isNegativeStrand();
        this.readName = al.getReadName();
        this.chromosome = al.getChr();
        this.start = al.getStart();
        this.end = al.getEnd();
        this.cigarString = al.getCigarString();
        AlignmentBlock[] blocks = al.getAlignmentBlocks();
        if (blocks != null) {
            ArrayList<ReducedMemoryAlignmentBlock> rmBlocks = new ArrayList<ReducedMemoryAlignmentBlock>(blocks.length);
            int start = blocks[0].getStart();
            int end = blocks[0].getEnd();
            boolean softClip = blocks[0].isSoftClip();
            for (int i = 1; i < blocks.length; ++i) {
                if (blocks[i].getStart() - end < indelLimit && blocks[i].isSoftClip() == softClip) {
                    end = blocks[i].getEnd();
                    continue;
                }
                rmBlocks.add(new ReducedMemoryAlignmentBlock(start, end - start, softClip));
                start = blocks[i].getStart();
                end = blocks[i].getEnd();
                softClip = blocks[i].isSoftClip();
            }
            rmBlocks.add(new ReducedMemoryAlignmentBlock(start, end - start, softClip));
            this.blocks = rmBlocks.toArray(new AlignmentBlock[rmBlocks.size()]);
        }
        if ((insertions = al.getInsertions()) != null) {
            ArrayList<AlignmentBlock> rmInsertions = new ArrayList<AlignmentBlock>();
            for (AlignmentBlock b : insertions) {
                if (b.getLength() < indelLimit) continue;
                rmInsertions.add(b);
            }
            this.insertions = rmInsertions.toArray(new AlignmentBlock[rmInsertions.size()]);
        }
        if ((gaps = al.getGaps()) != null) {
            ArrayList<Gap> rmGaps = new ArrayList<Gap>();
            for (Gap gap : gaps) {
                if (gap.getnBases() < indelLimit) continue;
                rmGaps.add(gap);
            }
            this.gaps = rmGaps;
        }
    }

    @Override
    public String getReadName() {
        return null;
    }

    @Override
    public String getReadSequence() {
        return "";
    }

    @Override
    public void setMateSequence(String sequnce) {
    }

    @Override
    public String getPairOrientation() {
        return "";
    }

    public boolean isSmallInsert() {
        return false;
    }

    @Override
    public boolean isVendorFailedRead() {
        return false;
    }

    @Override
    public Color getYcColor() {
        return null;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    @Override
    public String getChr() {
        return this.chromosome;
    }

    public String getContig() {
        return this.chromosome;
    }

    @Override
    public int getAlignmentStart() {
        return this.getStart();
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.getStart() && location < (double)this.getEnd();
    }

    @Override
    public AlignmentBlock[] getAlignmentBlocks() {
        return this.blocks;
    }

    @Override
    public AlignmentBlock[] getInsertions() {
        return this.insertions;
    }

    @Override
    public String getCigarString() {
        return "*";
    }

    @Override
    public int getInferredInsertSize() {
        return 0;
    }

    @Override
    public int getMappingQuality() {
        return 255;
    }

    @Override
    public ReadMate getMate() {
        return null;
    }

    @Override
    public boolean isProperPair() {
        return true;
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public boolean isPaired() {
        return false;
    }

    @Override
    public boolean isNegativeStrand() {
        return this.negativeStrand;
    }

    @Override
    public boolean isDuplicate() {
        return false;
    }

    @Override
    public float getScore() {
        return 1.0f;
    }

    public LocusScore copy() {
        return this;
    }

    @Override
    public String getClipboardString(double location, int mouseX) {
        return this.getValueString(location, mouseX, (WindowFunction)null);
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction ignored) {
        StringBuffer buf = new StringBuffer();
        buf.append("Read name = " + this.readName + "<br>");
        String sample = this.getSample();
        if (sample != null) {
            buf.append("Sample = " + sample + "<br>");
        }
        String readGroup = this.getReadGroup();
        if (sample != null) {
            buf.append("Read group = " + readGroup + "<br>");
        }
        buf.append("----------------------<br>");
        buf.append("Alignment start = " + Globals.DECIMAL_FORMAT.format(this.getAlignmentStart() + 1) + " (" + (this.isNegativeStrand() ? "-" : "+") + ")<br>");
        buf.append("Cigar = " + this.cigarString + "<br>");
        return buf.toString();
    }

    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public int getAlignmentEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public byte getBase(double position) {
        return 0;
    }

    @Override
    public byte getPhred(double position) {
        return 0;
    }

    @Override
    public String getSample() {
        return null;
    }

    @Override
    public String getReadGroup() {
        return null;
    }

    @Override
    public String getLibrary() {
        return null;
    }

    @Override
    public Object getAttribute(String key) {
        return null;
    }

    @Override
    public List<Gap> getGaps() {
        return this.gaps;
    }

    @Override
    public boolean isFirstOfPair() {
        return false;
    }

    @Override
    public boolean isSecondOfPair() {
        return false;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
    }

    @Override
    public Strand getSecondOfPairStrand() {
        return Strand.NONE;
    }

    @Override
    public Strand getReadStrand() {
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public boolean isSupplementary() {
        return false;
    }

    public static class ReducedMemoryAlignmentCounts
    implements AlignmentCounts {
        private int start;
        private int end;
        private int bucketSize;
        private int nBuckets;
        double[] total;
        private int maxCount;

        public ReducedMemoryAlignmentCounts(int start, int end, int bucketSize) {
            this.start = start;
            this.bucketSize = bucketSize;
            this.nBuckets = (end - start) / bucketSize;
            if (this.nBuckets == 0 || (end - start) % bucketSize != 0) {
                ++this.nBuckets;
            }
            this.total = new double[this.nBuckets];
            Arrays.fill(this.total, 0.0);
            this.end = start + this.nBuckets * bucketSize;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        @Override
        public int getBucketSize() {
            return this.bucketSize;
        }

        @Override
        public int getNumberOfPoints() {
            return this.nBuckets;
        }

        @Override
        public int getTotalCount(int pos) {
            int offset = (pos - this.start) / this.bucketSize;
            if (offset < 0 || offset >= this.total.length) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end));
                }
                return 0;
            }
            return (int)Math.round(this.total[offset]);
        }

        @Override
        public void incCounts(Alignment alignment) {
            AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
            if (blocks != null) {
                for (AlignmentBlock b : blocks) {
                    if (b.isSoftClip()) continue;
                    this.incrementBuckets(b.getStart(), b.getEnd());
                }
            } else {
                this.incrementBuckets(alignment.getAlignmentStart(), alignment.getAlignmentEnd());
            }
        }

        private void incrementBuckets(int blockStart, int blockEnd) {
            int startBucket = Math.max(0, (blockStart - this.start) / this.bucketSize);
            int endBucket = Math.min(this.nBuckets - 1, (blockEnd - this.start) / this.bucketSize);
            for (int b = startBucket; b <= endBucket; ++b) {
                int bucketStart = this.start + b * this.bucketSize;
                int bucketEnd = bucketStart + this.bucketSize;
                if (blockEnd < bucketStart || blockStart > bucketEnd) continue;
                double s = Math.max(blockStart, bucketStart);
                double e = Math.min(blockEnd, bucketEnd);
                double f = (e - s) / (double)this.bucketSize;
                int n = b;
                this.total[n] = this.total[n] + f;
                if (!(this.total[b] > (double)this.maxCount)) continue;
                this.maxCount = (int)Math.round(this.total[b]);
            }
        }

        @Override
        public int getMaxCount(int origin, int end) {
            return this.maxCount;
        }

        @Override
        public String getValueStringAt(int pos) {
            int idx = (pos - this.start) / this.bucketSize;
            return idx > 0 && idx < this.total.length ? String.valueOf((int)Math.round(this.total[idx])) : "";
        }

        public String getChr() {
            return null;
        }

        public String getContig() {
            return null;
        }

        @Override
        public int getTotalQuality(int pos) {
            return 0;
        }

        @Override
        public int getCount(int pos, byte b) {
            return 0;
        }

        @Override
        public int getNegCount(int pos, byte b) {
            return 0;
        }

        @Override
        public int getPosCount(int pos, byte b) {
            return 0;
        }

        @Override
        public int getDelCount(int pos) {
            return 0;
        }

        @Override
        public int getInsCount(int pos) {
            return 0;
        }

        @Override
        public int getQuality(int pos, byte b) {
            return 0;
        }

        @Override
        public boolean isConsensusMismatch(int pos, byte ref, String chr, float snpThreshold) {
            return false;
        }

        @Override
        public boolean isConsensusDeletion(int start, int end, float snpThreshold) {
            return false;
        }

        @Override
        public boolean isConsensusInsertion(int pos, float snpThreshold) {
            return false;
        }

        @Override
        public BisulfiteCounts getBisulfiteCounts() {
            return null;
        }

        @Override
        public boolean hasBaseCounts() {
            return false;
        }

        @Override
        public void finish() {
        }
    }

    public static class ReducedMemoryAlignmentBlock
    implements AlignmentBlock {
        private int pixelStart;
        private int pixelEnd;
        private char cigarOperator;
        int start;
        int length;
        boolean softClipped;

        ReducedMemoryAlignmentBlock(int start, int length, boolean softClipped) {
            this.start = start;
            this.length = length;
            this.softClipped = softClipped;
            this.cigarOperator = this.cigarOperator;
        }

        @Override
        public void setPixelRange(int s, int e) {
            this.pixelStart = s;
            this.pixelEnd = e;
        }

        @Override
        public boolean containsPixel(int x) {
            return x >= this.pixelStart && x <= this.pixelEnd;
        }

        @Override
        public char getCigarOperator() {
            return this.cigarOperator;
        }

        @Override
        public boolean contains(int position) {
            int offset = position - this.start;
            return offset >= 0 && offset < this.getLength();
        }

        @Override
        public int getBasesLength() {
            return this.length;
        }

        @Override
        public int getBasesOffset() {
            return 0;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public byte getBase(int offset) {
            return 0;
        }

        @Override
        public ByteSubarray getBases() {
            return null;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public byte getQuality(int offset) {
            return 0;
        }

        @Override
        public ByteSubarray getQualities() {
            return null;
        }

        @Override
        public int getEnd() {
            return this.start + this.length;
        }

        @Override
        public boolean isSoftClip() {
            return this.softClipped;
        }

        @Override
        public boolean hasBases() {
            return false;
        }
    }
}

