/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.perms;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.AlignmentReaderImpl;
import org.campagnelab.goby.alignments.perms.NoOpPermutationReader;
import org.campagnelab.goby.alignments.perms.PermutationReader;
import org.campagnelab.goby.alignments.perms.PermutationReaderInterface;
import org.campagnelab.goby.alignments.perms.QueryIndexPermutation;

public class ConcatenatePermutations
extends QueryIndexPermutation {
    private static final Log LOG = LogFactory.getLog(ConcatenatePermutations.class);
    private PermutationReaderInterface[] permReaders;
    private boolean outputNeedsPermutation;
    private String outputFilename;
    private final boolean[] alignmentHasPermutation;

    public void concatenate(String destinationBasename) {
        if (!this.outputNeedsPermutation) {
            new File(this.outputFilename).delete();
        } else {
            this.close();
            String destinationFilename = destinationBasename + ".perm";
            try {
                FileUtils.moveFile((File)new File(this.outputFilename), (File)new File(destinationFilename));
            }
            catch (IOException e) {
                LOG.error((Object)String.format("Unable to move temporary permutation file %s to destination %s ", this.outputFilename, destinationFilename));
            }
        }
    }

    public ConcatenatePermutations(String[] basenames) throws IOException {
        this(basenames, File.createTempFile("permutation", ".perm").getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcatenatePermutations(String[] basenames, String outputFilename) throws IOException {
        super(outputFilename);
        this.outputFilename = outputFilename;
        int i = 0;
        this.alignmentHasPermutation = new boolean[basenames.length];
        this.permReaders = new PermutationReaderInterface[basenames.length];
        for (String basename : basenames) {
            try (AlignmentReaderImpl reader = null;){
                reader = new AlignmentReaderImpl(basename, false);
                reader.readHeader();
                this.alignmentHasPermutation[i] = reader.getQueryIndicesWerePermuted();
            }
            this.permReaders[i] = this.alignmentHasPermutation[i] ? new PermutationReader(basenames[i]) : new NoOpPermutationReader();
            this.outputNeedsPermutation |= this.alignmentHasPermutation[i];
            ++i;
        }
    }

    public final int combine(int readerIndex, int smallIndex) throws IOException {
        int queryIndex = this.alignmentHasPermutation[readerIndex] ? this.permReaders[readerIndex].getQueryIndex(smallIndex) : smallIndex;
        return this.permutate(queryIndex);
    }

    public boolean needsPermutation() {
        return this.outputNeedsPermutation;
    }
}

