/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTree;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.ZoomDataBlock;
import org.broad.igv.bbfile.ZoomDataRecord;

public class ZoomLevelIterator {
    private static Logger log = Logger.getLogger(ZoomDataBlock.class);
    private boolean empty = false;
    private int zoomLevel;
    private RPChromosomeRegion selectionRegion;
    private boolean isContained;
    private RPChromosomeRegion hitRegion;
    private SeekableStream fis;
    private BPTree chromIDTree;
    private RPTree zoomDataTree;
    private ArrayList<RPTreeLeafNodeItem> leafHitList;
    private Map<Integer, String> chromosomeMap;
    private int leafItemIndex;
    RPTreeLeafNodeItem leafHitItem;
    ZoomDataBlock zoomDataBlock;
    private boolean dataBlockRead;
    ArrayList<ZoomDataRecord> zoomRecordList;
    private int zoomRecordIndex;

    public ZoomLevelIterator() {
    }

    public ZoomLevelIterator(SeekableStream fis, BPTree chromIDTree, RPTree zoomDataTree, int zoomLevel, RPChromosomeRegion selectionRegion, boolean contained) {
        if (selectionRegion == null) {
            throw new RuntimeException("Error: ZoomLevelIterator selection region is null\n");
        }
        this.fis = fis;
        this.chromIDTree = chromIDTree;
        this.zoomDataTree = zoomDataTree;
        this.zoomLevel = zoomLevel;
        this.selectionRegion = selectionRegion;
        this.isContained = contained;
        int hitCount = this.getHitRegion(selectionRegion, contained);
        if (hitCount == 0) {
            this.empty = true;
        }
    }

    public boolean hasNext() {
        if (this.empty) {
            return false;
        }
        if (this.zoomRecordIndex < this.zoomRecordList.size()) {
            return true;
        }
        return this.leafItemIndex < this.leafHitList.size();
    }

    public ZoomDataRecord next() {
        if (this.zoomRecordIndex < this.zoomRecordList.size()) {
            return this.zoomRecordList.get(this.zoomRecordIndex++);
        }
        int nHits = this.getHitRegion(this.selectionRegion, this.isContained);
        if (nHits > 0) {
            return this.zoomRecordList.get(this.zoomRecordIndex++);
        }
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove iterator item is not supported yet.");
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public RPChromosomeRegion getSelectionRegion() {
        return this.selectionRegion;
    }

    public int setSelectionRegion(RPChromosomeRegion selectionRegion, boolean contained) {
        this.selectionRegion = selectionRegion;
        this.isContained = contained;
        this.leafHitList = null;
        int hitCount = this.getHitRegion(selectionRegion, contained);
        if (hitCount == 0) {
            throw new RuntimeException("No wig data found in the selection region");
        }
        return hitCount;
    }

    public boolean isContained() {
        return this.isContained;
    }

    public SeekableStream getBBFis() {
        return this.fis;
    }

    public BPTree getChromosomeIDTree() {
        return this.chromIDTree;
    }

    public RPTree getZoomDataTree() {
        return this.zoomDataTree;
    }

    private int getHitRegion(RPChromosomeRegion hitRegion, boolean contained) {
        int hitCount = 0;
        if (this.leafHitList == null ? (hitCount = this.getHitList(hitRegion, contained)) == 0 : (hitCount = this.leafHitList.size() - this.leafItemIndex) == 0) {
            return 0;
        }
        this.dataBlockRead = this.getDataBlock(this.leafItemIndex++);
        if (!this.dataBlockRead) {
            hitCount = this.getHitRegion(hitRegion, contained);
        }
        return hitCount;
    }

    private int getHitList(RPChromosomeRegion hitRegion, boolean contained) {
        this.leafHitList = this.zoomDataTree.getChromosomeDataHits(hitRegion, contained);
        int nHits = this.leafHitList.size();
        if (nHits == 0) {
            return 0;
        }
        this.leafItemIndex = 0;
        int startChromID = this.leafHitList.get(0).getChromosomeBounds().getStartChromID();
        int startBase = this.leafHitList.get(0).getChromosomeBounds().getStartBase();
        int endChromID = this.leafHitList.get(nHits - 1).getChromosomeBounds().getEndChromID();
        int endBase = this.leafHitList.get(nHits - 1).getChromosomeBounds().getEndBase();
        this.hitRegion = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
        return nHits;
    }

    private boolean getDataBlock(int leafItemIndex) {
        if (this.leafHitList == null || leafItemIndex >= this.leafHitList.size()) {
            return false;
        }
        this.leafHitItem = this.leafHitList.get(leafItemIndex);
        int startChromID = this.leafHitItem.getChromosomeBounds().getStartChromID();
        int endChromID = this.leafHitItem.getChromosomeBounds().getEndChromID();
        this.chromosomeMap = this.chromIDTree.getChromosomeIDMap(startChromID, endChromID);
        boolean isLowToHigh = this.zoomDataTree.isIsLowToHigh();
        int uncompressBufSize = this.zoomDataTree.getUncompressBuffSize();
        this.zoomDataBlock = new ZoomDataBlock(this.zoomLevel, this.fis, this.leafHitItem, this.chromosomeMap, isLowToHigh, uncompressBufSize);
        this.zoomRecordList = this.zoomDataBlock.getZoomData(this.selectionRegion, this.isContained);
        this.zoomRecordIndex = 0;
        return this.zoomRecordList.size() > 0;
    }

    public static class EmptyIterator
    extends ZoomLevelIterator {
        static EmptyIterator theInstance = new EmptyIterator();

        @Override
        public boolean hasNext() {
            return false;
        }
    }
}

