/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.ui.color.PaletteColorTable;

public class BaseModification {
    public String modification;
    char strand;
    public int position;
    public byte likelihood;
    static Map<String, String> codeValues = new HashMap<String, String>();
    static PaletteColorTable modColorPallete;
    static Map<String, Color> modColorMap;

    public BaseModification(String modification, char strand, int position, byte likelihood) {
        this.likelihood = likelihood;
        this.modification = modification;
        this.position = position;
    }

    public String valueString() {
        int l = (int)(100.0 * (double)Byte.toUnsignedInt(this.likelihood) / 255.0);
        return "Base modification: " + (codeValues.containsKey(this.modification) ? codeValues.get(this.modification) : "Uknown") + " (" + l + "%)";
    }

    public static List<BaseModification> getBaseModifications(String mm, byte[] ml, byte[] sequence, boolean isNegativeStrand) {
        byte[] origSequence = sequence;
        if (isNegativeStrand) {
            sequence = AlignmentUtils.reverseComplementCopy(sequence);
        }
        ArrayList<BaseModification> mods = new ArrayList<BaseModification>();
        String[] mmTokens = mm.split(";");
        int mlIdx = 0;
        block2: for (String mmi : mmTokens) {
            String[] tokens = mmi.split(",");
            if (tokens.length <= 1) continue;
            char strand = tokens[0].charAt(1);
            char base = tokens[0].charAt(0);
            String modificationString = tokens[0].substring(2);
            String[] modifications = null;
            if (modificationString.length() > 1) {
                boolean isChEBI = true;
                try {
                    Integer.parseInt(modificationString);
                }
                catch (NumberFormatException e) {
                    isChEBI = false;
                }
                if (isChEBI) {
                    modifications = new String[]{modificationString};
                } else {
                    modifications = new String[modificationString.length()];
                    for (int i = 0; i < modificationString.length(); ++i) {
                        modifications[i] = modificationString.substring(i, i + 1);
                    }
                }
            } else {
                modifications = new String[]{modificationString};
            }
            int idx = 0;
            int s = 0;
            int[] positions = new int[tokens.length - 1];
            int skip = Integer.parseInt(tokens[idx + 1]);
            int matchCount = 0;
            while (idx < positions.length) {
                if (s >= sequence.length) {
                    System.err.println("Ran out of sequence");
                    System.out.println(isNegativeStrand);
                    System.out.println(mm);
                    System.out.println(new String(origSequence));
                    System.out.println(new String(sequence));
                    continue block2;
                }
                if (base == 'N' || sequence[s] == base) {
                    if (matchCount == skip) {
                        int position = isNegativeStrand ? sequence.length - 1 - s : s;
                        for (String modification : modifications) {
                            byte likelihood = ml == null ? (byte)-1 : ml[mlIdx];
                            mods.add(new BaseModification(modification, strand, position, likelihood));
                            ++mlIdx;
                        }
                        if (idx + 1 == positions.length) continue block2;
                        skip = Integer.parseInt(tokens[++idx + 1]);
                        matchCount = 0;
                    } else {
                        ++matchCount;
                    }
                }
                ++s;
            }
        }
        return mods;
    }

    public static Color getModColor(String modification, byte likelihood) {
        if (modColorPallete == null) {
            modColorPallete = new PaletteColorTable(new Color(132, 178, 158));
            modColorPallete.put("m", Color.red);
            modColorPallete.put("h", new Color(11, 132, 165));
            modColorPallete.put("o", new Color(111, 78, 129));
            modColorPallete.put("f", new Color(246, 200, 95));
            modColorPallete.put("c", new Color(157, 216, 102));
            modColorPallete.put("g", new Color(255, 160, 86));
            modColorPallete.put("e", new Color(141, 221, 208));
            modColorPallete.put("b", new Color(202, 71, 47));
        }
        Color baseColor = modColorPallete.get(modification);
        int l = Byte.toUnsignedInt(likelihood);
        if (l > 250) {
            return baseColor;
        }
        String key = modification + "--" + (l = Math.max(25, l));
        if (!modColorMap.containsKey(key)) {
            modColorMap.put(key, new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), l));
        }
        return modColorMap.get(key);
    }

    static {
        codeValues.put("m", "5mC");
        codeValues.put("h", "5hmC");
        codeValues.put("f", "5fC");
        codeValues.put("c", "5caC");
        codeValues.put("g", "5hmU");
        codeValues.put("e", "5fU");
        codeValues.put("b", "5caU");
        codeValues.put("a", "6mA");
        codeValues.put("o", "8xoG");
        codeValues.put("n", "Xao");
        codeValues.put("C", "Unknown C");
        codeValues.put("T", "Unknown T");
        codeValues.put("A", "Unknown A");
        codeValues.put("G", "Unknown G");
        codeValues.put("N", "Unknown");
        modColorMap = new HashMap<String, Color>();
    }

    public static class Mod {
        char base;
        char strand;
        byte likelihood;

        public Mod(char base, char strand, byte likelihood) {
            this.base = base;
            this.strand = strand;
            this.likelihood = likelihood;
        }
    }
}

