/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.Arrays;

public class ByteSubarray {
    public byte[] backingArray;
    public int startOffset;
    public int length;

    public ByteSubarray(byte[] backingArray, int startOffset, int length) {
        this.backingArray = backingArray;
        this.startOffset = startOffset;
        this.length = length;
    }

    public byte getByte(int idx) {
        if (idx < 0 || idx >= this.length) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + idx);
        }
        return this.backingArray[this.startOffset + idx];
    }

    public byte[] copyOfRange(int start, int end) {
        return Arrays.copyOfRange(this.backingArray, this.startOffset + start, this.startOffset + end);
    }

    public String getString() {
        return new String(this.backingArray, this.startOffset, this.length);
    }

    @Deprecated
    public byte[] getBytes() {
        return Arrays.copyOfRange(this.backingArray, this.startOffset, this.startOffset + this.length);
    }
}

