/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.MessageCollection;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.RegionOfInterestTool;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelComponent;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;

public class DataPanelContainer
extends TrackPanelComponent
implements Paintable {
    static final int default_hgap = 6;
    private static Logger log = Logger.getLogger(DataPanelContainer.class);
    TrackPanel parent;

    public DataPanelContainer(TrackPanel trackPanel) {
        super(trackPanel);
        DropTarget target = new DropTarget(this, new FileDropTargetListener(trackPanel));
        this.setDropTarget(target);
        target.setActive(true);
        this.setLayout(new BoxLayout(this, 0));
        this.parent = trackPanel;
        this.createDataPanels();
    }

    public void createDataPanels() {
        this.removeAll();
        int hgap = 6;
        if (FrameManager.getFrames().size() > 10) {
            hgap = 1 + 20 / FrameManager.getFrames().size();
        }
        boolean first = true;
        for (ReferenceFrame f : FrameManager.getFrames()) {
            if (!f.isVisible()) continue;
            if (!first) {
                this.add(Box.createRigidArea(new Dimension(hgap, 0)));
            }
            DataPanel dp = new DataPanel(f, this);
            this.add(dp);
            first = false;
        }
        this.invalidate();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            c.setBackground(color);
        }
    }

    public Collection<TrackGroup> getTrackGroups() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getGroups();
    }

    public int getVisibleHeight() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getVisibleRect().height;
    }

    public void setCurrentTool(RegionOfInterestTool regionOfInterestTool) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            ((DataPanel)c).setCurrentTool(regionOfInterestTool);
        }
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect, boolean batch) {
        Component[] components = this.getComponents();
        Arrays.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component component, Component component1) {
                return component.getX() - component1.getX();
            }
        });
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            Graphics2D g2d = (Graphics2D)g.create();
            Rectangle clipRect = new Rectangle(c.getBounds());
            clipRect.height = rect.height;
            g2d.setClip(clipRect);
            g2d.translate(c.getX(), 0);
            ((DataPanel)c).paintOffscreen(g2d, clipRect, batch);
        }
    }

    @Override
    public int getSnapshotHeight(boolean batch) {
        return this.getHeight();
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (IGV.getInstance().isRulerEnabled()) {
            int start = MouseInfo.getPointerInfo().getLocation().x - this.getLocationOnScreen().x;
            g.setColor(Color.BLACK);
            g.drawLine(start, 0, start, this.getHeight());
            ReferenceFrame frame = FrameManager.getDefaultFrame();
            boolean allChrMode = frame.getChrName().equals("All");
            if (!FrameManager.isGeneListMode() && !allChrMode) {
                int y = MouseInfo.getPointerInfo().getLocation().y - this.getLocationOnScreen().y;
                int pos = (int)frame.getChromosomePosition(start) + 1;
                g.setFont(FontManager.getDefaultFont());
                g.drawString(Globals.DECIMAL_FORMAT.format((double)pos), start + 10, y + 30);
            }
        }
    }

    private class FileDropTargetListener
    implements DropTargetListener {
        private TrackPanel panel;

        public FileDropTargetListener(TrackPanel dataPanel) {
            this.panel = dataPanel;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            block12: {
                if (!this.isDropAcceptable(event)) {
                    event.rejectDrop();
                    return;
                }
                event.acceptDrop(1);
                Transferable transferable = event.getTransferable();
                MessageCollection messages = new MessageCollection();
                try {
                    String obj;
                    List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (files != null && files.size() > 0) {
                        List<ResourceLocator> locators = ResourceLocator.getLocators(files);
                        for (ResourceLocator locator : locators) {
                            try {
                                IGV.getInstance().load(locator, this.panel);
                            }
                            catch (DataLoadException de) {
                                messages.append(de.getMessage());
                            }
                        }
                    }
                    if (HttpUtils.isRemoteURL(obj = transferable.getTransferData(DataFlavor.stringFlavor).toString())) {
                        IGV.getInstance().load(new ResourceLocator(obj), this.panel);
                    }
                    if (messages != null && !messages.isEmpty()) {
                        log.error((Object)messages.getFormattedMessage());
                        MessageUtils.showMessage(messages.getFormattedMessage());
                    }
                }
                catch (Exception e) {
                    String obj = null;
                    try {
                        obj = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                        if (HttpUtils.isRemoteURL(obj)) {
                            IGV.getInstance().load(new ResourceLocator(obj), this.panel);
                        }
                    }
                    catch (Exception e1) {
                        log.error((Object)e1);
                        if (messages == null || messages.isEmpty()) break block12;
                        MessageUtils.showMessage(messages.getFormattedMessage());
                    }
                }
            }
            IGV.getMainFrame().repaint();
            event.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent event) {
            return (event.getDropAction() & 3) != 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent event) {
            return (event.getDropAction() & 3) != 0;
        }
    }
}

