/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.CloseableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.sam.reader.SamReaderPool;
import org.broad.igv.sam.reader.WrappedIterator;
import org.broad.igv.util.ResourceLocator;

public class BAMReader
implements AlignmentReader<SAMAlignment> {
    static Logger log = Logger.getLogger(BAMReader.class);
    private SAMFileHeader header;
    private List<String> sequenceNames;
    private boolean indexed;
    private Map<String, Long> sequenceDictionary;
    private SamReaderPool readerPool;
    static CloseableIterator<SAMAlignment> EMPTY_ITERATOR = new CloseableIterator<SAMAlignment>(){

        public void close() {
        }

        public boolean hasNext() {
            return false;
        }

        public SAMAlignment next() {
            return null;
        }
    };

    public BAMReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        this.indexed = requireIndex;
        this.readerPool = new SamReaderPool(locator, requireIndex);
        SamReader reader = this.readerPool.getReader();
        this.header = reader.getFileHeader();
        this.readerPool.freeReader(reader);
    }

    private SamReader getSamReader() throws IOException {
        return this.readerPool.getReader();
    }

    @Override
    public void close() throws IOException {
        this.readerPool.close();
    }

    @Override
    public synchronized SAMFileHeader getFileHeader() {
        if (this.header == null) {
            try {
                this.header = this.getSamReader().getFileHeader();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.header;
    }

    @Override
    public boolean hasIndex() {
        return this.indexed;
    }

    @Override
    public Set<String> getPlatforms() {
        return AlignmentReaderFactory.getPlatforms(this.getFileHeader());
    }

    @Override
    public List<String> getSequenceNames() {
        if (this.sequenceNames == null) {
            this.loadSequenceDictionary();
        }
        return this.sequenceNames;
    }

    @Override
    public Map<String, Long> getSequenceDictionary() {
        if (this.sequenceDictionary == null) {
            this.loadSequenceDictionary();
        }
        return this.sequenceDictionary;
    }

    private void loadSequenceDictionary() {
        SAMFileHeader header = this.getFileHeader();
        this.sequenceNames = new ArrayList<String>();
        this.sequenceDictionary = new HashMap<String, Long>();
        List records = header.getSequenceDictionary().getSequences();
        if (records.size() > 0) {
            for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                String chr = rec.getSequenceName();
                Long size = new Long(rec.getSequenceLength());
                this.sequenceNames.add(chr);
                this.sequenceDictionary.put(chr, size);
            }
        }
    }

    @Override
    public CloseableIterator<SAMAlignment> iterator() throws IOException {
        return new WrappedIterator((CloseableIterator<SAMRecord>)this.getSamReader().iterator());
    }

    @Override
    public CloseableIterator<SAMAlignment> query(String sequence, int start, int end, boolean contained) {
        if (this.sequenceDictionary != null && !this.sequenceDictionary.containsKey(sequence)) {
            return EMPTY_ITERATOR;
        }
        try {
            SamReader samReader = this.getSamReader();
            return new PicardIterator(samReader, sequence, start + 1, end, contained);
        }
        catch (Exception e) {
            log.error((Object)("Error querying for sequence: " + sequence), (Throwable)e);
            return new EmptyAlignmentIterator();
        }
    }

    class PicardIterator
    implements CloseableIterator<SAMAlignment> {
        private SamReader reader;
        CloseableIterator<SAMRecord> iterator;

        public PicardIterator(SamReader samReader, String sequence, int start, int end, boolean contained) {
            this.reader = samReader;
            this.iterator = samReader.query(sequence, start, end, contained);
        }

        public void close() {
            this.iterator.close();
            BAMReader.this.readerPool.freeReader(this.reader);
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public SAMAlignment next() {
            return new SAMAlignment((SAMRecord)this.iterator.next());
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

