/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.ResourceTree;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class LoadFromServerAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFromServerAction.class);
    IGV mainFrame;
    static HashSet<String> failedURLs = new HashSet();

    public LoadFromServerAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        block20: {
            this.mainFrame.setStatusBarMessage("Loading ...");
            String urlString = PreferenceManager.getInstance().getDataServerURL();
            String genomeId = IGV.getInstance().getGenomeManager().getGenomeId();
            String genomeURL = urlString.replaceAll("\\$\\$", genomeId);
            InputStream is = null;
            LinkedHashSet<String> nodeURLs = null;
            try {
                is = ParsingUtils.openInputStreamGZ(new ResourceLocator(genomeURL));
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
                nodeURLs = this.getResourceUrls(bufferedReader);
            }
            catch (IOException e) {
                MessageUtils.showMessage("Error loading the data registry file: " + e.toString());
                log.error("Error loading genome registry file", e);
                this.mainFrame.showLoadedTrackCount();
                return;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error("Error closing input stream", e);
                    }
                }
            }
            if (nodeURLs == null || nodeURLs.isEmpty()) {
                MessageUtils.showMessage("No datasets are available for the current genome (" + genomeId + ").");
            } else {
                List<ResourceLocator> locators = this.loadNodes(nodeURLs);
                if (locators != null) {
                    this.mainFrame.loadTracks(locators);
                }
            }
            break block20;
            finally {
                this.mainFrame.showLoadedTrackCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceLocator> loadNodes(LinkedHashSet<String> xmlUrls) {
        if (xmlUrls == null || xmlUrls.isEmpty()) {
            log.error("No datasets are available from this server for the current genome (");
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        boolean xmlParsingError = false;
        try {
            buffer.append("<html>The following urls could not be processed due to load failures:<br>");
            Document masterDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootNode = masterDocument.createElement("Global");
            rootNode.setAttribute("name", "Available Datasets");
            rootNode.setAttribute("version", "1");
            masterDocument.appendChild(rootNode);
            for (String url : xmlUrls) {
                if (failedURLs.contains(url)) continue;
                try {
                    InputStream is = null;
                    Document xmlDocument = null;
                    try {
                        is = ParsingUtils.openInputStreamGZ(new ResourceLocator(url));
                        xmlDocument = Utilities.createDOMDocumentFromXmlStream(is);
                    }
                    catch (SocketTimeoutException e) {
                        xmlParsingError = true;
                        buffer.append("Error. Connection time out reading: " + url.toString());
                        continue;
                    }
                    catch (SAXParseException e) {
                        log.error("Invalid XML resource: " + url, e);
                        xmlParsingError = true;
                        buffer.append(url);
                        buffer.append("<br><i>");
                        if (url.toString().contains("iwww.broad")) {
                            buffer.append("File could not be loaded from the Broad Intranet");
                        } else {
                            buffer.append(e.getMessage());
                        }
                        buffer.append("");
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        String message = "Could not find file represented by " + url.toString();
                        log.error(message, e);
                        xmlParsingError = true;
                        buffer.append(url);
                        buffer.append("\t  [");
                        buffer.append(e.getMessage());
                        buffer.append("]\n");
                        continue;
                    }
                    catch (IOException e) {
                        String msg = "Error accessing dataset list: " + e.toString();
                        MessageUtils.showMessage(msg);
                        log.error("Error accessing URL: " + url, e);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                        continue;
                    }
                    if (xmlDocument == null) continue;
                    NodeList elements = xmlDocument.getElementsByTagName("Global");
                    Element global = (Element)elements.item(0);
                    NodeList nodes = global.getChildNodes();
                    Element categoryNode = masterDocument.createElement("Category");
                    categoryNode.setAttribute("name", global.getAttribute("name"));
                    categoryNode.setAttribute("hyperlink", global.getAttribute("hyperlink"));
                    rootNode.appendChild(categoryNode);
                    int size = nodes.getLength();
                    for (int i = 0; i < size; ++i) {
                        categoryNode.appendChild(masterDocument.importNode(nodes.item(i), true));
                    }
                }
                catch (Exception e) {
                    String message = "Cannot create an XML Document from " + url.toString();
                    log.error(message, e);
                }
            }
            if (xmlParsingError) {
                LoadFromServerAction loadFromServerAction = this;
                JOptionPane.showMessageDialog(loadFromServerAction.mainFrame.getMainFrame(), buffer.toString());
            }
            LoadFromServerAction loadFromServerAction = this;
            LinkedHashSet<ResourceLocator> selectedLocators = ResourceTree.getInstance().showResourceTreeDialog(loadFromServerAction.mainFrame.getMainFrame(), masterDocument, "Available Datasets");
            ArrayList<ResourceLocator> newLoadList = new ArrayList<ResourceLocator>();
            if (selectedLocators != null) {
                for (ResourceLocator locator : selectedLocators) {
                    if (IGV.getInstance().getDataResourceLocators().contains(locator)) continue;
                    newLoadList.add(locator);
                }
            }
            ArrayList<ResourceLocator> arrayList = newLoadList;
            return arrayList;
        }
        catch (Exception e) {
            log.error("Could not load information from server", e);
            List<ResourceLocator> list = null;
            return list;
        }
        finally {
            if (xmlParsingError) {
                log.error(buffer.toString());
            }
        }
    }

    private LinkedHashSet<String> getResourceUrls(BufferedReader bufferedReader) throws IOException {
        String xmlFileUrl;
        LinkedHashSet<String> xmlFileUrls = new LinkedHashSet<String>();
        while ((xmlFileUrl = bufferedReader.readLine()) != null && xmlFileUrl.trim().length() != 0) {
            xmlFileUrl = xmlFileUrl.trim();
            xmlFileUrls.add(xmlFileUrl);
        }
        return xmlFileUrls;
    }
}

