/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.affective;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.broad.igv.dev.affective.AffectiveChromosome;
import org.broad.igv.dev.affective.AffectiveUtils;
import org.broad.igv.dev.affective.Annotation;
import org.broad.igv.util.ParsingUtils;

public class AffectiveAnnotationParser {
    static Pattern commaPattern = Pattern.compile(",");
    static Pattern colonPattern = Pattern.compile(":");
    static SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy");
    int dateColumn = 4;
    int startTimeColumn = 6;
    int endTimeColumn = 7;
    int typeColumn = 8;
    int descriptionColumn = 10;
    String[] headings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Annotation>> parse(String file) throws IOException {
        BufferedReader br = null;
        TreeMap<String, List<Annotation>> annotationMap = new TreeMap<String, List<Annotation>>();
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(file);
            String headerLine = br.readLine();
            this.headings = commaPattern.split(headerLine);
            for (int i = 1; i < this.headings.length; ++i) {
                if (this.headings[i].equals("Date")) {
                    this.dateColumn = i;
                    continue;
                }
                if (this.headings[i].equals("Onset Time")) {
                    this.startTimeColumn = i;
                    continue;
                }
                if (this.headings[i].equals("Offset Time")) {
                    this.endTimeColumn = i;
                    continue;
                }
                if (this.headings[i].equals("Type of Annotation")) {
                    this.typeColumn = i;
                    continue;
                }
                if (!this.headings[i].equals("Description")) continue;
                this.descriptionColumn = i;
            }
            while ((nextLine = br.readLine()) != null) {
                String dateString;
                String[] tokens = commaPattern.split(nextLine);
                if (tokens.length != this.headings.length) {
                    System.out.println("Skipping: " + nextLine);
                    continue;
                }
                try {
                    Date date = dateFormat.parse(tokens[this.dateColumn]);
                    dateString = AffectiveChromosome.dateFormat.format(date);
                }
                catch (ParseException e) {
                    System.out.println("Could not parse date: " + tokens[this.dateColumn]);
                    continue;
                }
                int startTime = AffectiveAnnotationParser.toSeconds(tokens[this.startTimeColumn]);
                int endTime = AffectiveAnnotationParser.toSeconds(tokens[this.endTimeColumn]);
                String type = tokens[this.typeColumn];
                String description = tokens[this.descriptionColumn];
                Annotation annotation = new Annotation(dateString, startTime, endTime, type, description, this.headings, tokens);
                List<Annotation> annotList = annotationMap.get(type);
                if (annotList == null) {
                    annotList = new ArrayList<Annotation>();
                    annotationMap.put(type, annotList);
                }
                annotList.add(annotation);
            }
            TreeMap<String, List<Annotation>> treeMap = annotationMap;
            return treeMap;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private static int toSeconds(String timeString) {
        String[] tmp = colonPattern.split(timeString);
        int h = Integer.parseInt(tmp[0]) - AffectiveUtils.START_TIME_HR;
        int m = Integer.parseInt(tmp[1]);
        int s = Integer.parseInt(tmp[2]);
        return (h * 60 + m) * 60 + s;
    }
}

