/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.Tribble;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.util.ParsingUtils;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class AsciiFeatureReader<T extends Feature>
extends AbstractFeatureReader {
    private Index index;

    public AsciiFeatureReader(String featurePath, FeatureCodec codec, boolean requireIndex) throws IOException {
        super(featurePath, codec);
        if (requireIndex) {
            String indexFile = Tribble.indexFile(featurePath);
            if (ParsingUtils.resourceExists(indexFile)) {
                this.index = IndexFactory.loadIndex(indexFile);
            } else if (ParsingUtils.resourceExists(indexFile = indexFile + ".gz")) {
                this.index = IndexFactory.loadIndex(indexFile);
            } else {
                throw new TribbleException("An index is required, but none found.");
            }
        }
        this.readHeader();
    }

    public AsciiFeatureReader(String featureFile, FeatureCodec codec, Index index) throws IOException {
        super(featureFile, codec);
        this.index = index;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<String> getSequenceNames() {
        return this.index == null ? new ArrayList<String>() : new ArrayList<String>(this.index.getSequenceNames());
    }

    private void readHeader() throws IOException {
        InputStream is = null;
        try {
            is = ParsingUtils.openInputStream(this.path);
            InputStream inputStream = this.path.endsWith("gz") ? new GZIPInputStream(new BufferedInputStream(is)) : is;
            AsciiLineReader reader = new AsciiLineReader(inputStream, 64000);
            this.header = this.codec.readHeader(reader);
        }
        catch (Exception e) {
            throw new TribbleException.MalformedFeatureFile("Unable to parse header with error: " + e.getMessage(), this.path, e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public CloseableTribbleIterator query(String chr, int start, int end) throws IOException {
        if (this.index == null) {
            throw new TribbleException("Index not found for: " + this.path);
        }
        if (this.index.containsChromosome(chr)) {
            List<Block> blocks = this.index.getBlocks(chr, start - 1, end);
            return new QueryIterator(chr, start, end, blocks);
        }
        return new AbstractFeatureReader.EmptyIterator();
    }

    @Override
    public CloseableTribbleIterator iterator() throws IOException {
        return new WFIterator();
    }

    static class BlockStreamWrapper
    extends InputStream {
        SeekableStream seekableStream;
        long maxPosition;

        BlockStreamWrapper(SeekableStream seekableStream, Block block) throws IOException {
            this.seekableStream = seekableStream;
            seekableStream.seek(block.getStartPosition());
            this.maxPosition = block.getEndPosition();
        }

        @Override
        public int read() throws IOException {
            return this.seekableStream.position() > this.maxPosition ? -1 : this.seekableStream.read();
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            int maxBytes = (int)(this.maxPosition - this.seekableStream.position());
            if (maxBytes <= 0) {
                return -1;
            }
            int bytesToRead = Math.min(len, maxBytes);
            return this.seekableStream.read(bytes, off, bytesToRead);
        }
    }

    class QueryIterator<T extends Feature>
    implements CloseableTribbleIterator {
        private String chr;
        private String chrAlias;
        int start;
        int end;
        private T currentRecord;
        private LineReader reader;
        private Iterator<Block> blockIterator;
        private SeekableStream seekableStream;

        public QueryIterator(String chr, int start, int end, List<Block> blocks) throws IOException {
            this.seekableStream = SeekableStreamFactory.getStreamFor(AsciiFeatureReader.this.path);
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.blockIterator = blocks.iterator();
            this.advanceBlock();
            this.readNextRecord();
            this.chrAlias = this.currentRecord == null ? chr : this.currentRecord.getChr();
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            T ret = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + ret.getChr() + ":" + ret.getStart() + "-" + ret.getEnd(), e);
            }
            return ret;
        }

        private void advanceBlock() throws IOException {
            while (this.blockIterator != null && this.blockIterator.hasNext()) {
                Block block = this.blockIterator.next();
                if (block.getSize() <= 0) continue;
                this.seekableStream.seek(block.getStartPosition());
                int bufferSize = Math.min(2000000, block.getSize());
                this.reader = new AsciiLineReader(new BlockStreamWrapper(this.seekableStream, block), bufferSize);
                return;
            }
        }

        private void readNextRecord() throws IOException {
            this.currentRecord = null;
            while (true) {
                String nextLine;
                if ((nextLine = this.reader.readLine()) != null) {
                    Feature f = null;
                    try {
                        f = (Feature)AsciiFeatureReader.this.codec.decode(nextLine);
                        if (f == null) continue;
                        if (this.chrAlias != null && !f.getChr().equals(this.chrAlias) || f.getStart() > this.end) {
                            if (this.blockIterator.hasNext()) {
                                this.advanceBlock();
                                continue;
                            }
                            return;
                        }
                        if (f.getEnd() < this.start) continue;
                        this.currentRecord = f;
                        return;
                    }
                    catch (TribbleException e) {
                        e.setSource(AsciiFeatureReader.this.path);
                        throw e;
                    }
                    catch (NumberFormatException e) {
                        String error = "Error parsing line: " + nextLine;
                        throw new TribbleException.MalformedFeatureFile(error, AsciiFeatureReader.this.path, e);
                    }
                }
                if (this.blockIterator == null || !this.blockIterator.hasNext()) break;
                this.advanceBlock();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        public void close() {
            try {
                this.seekableStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }

    class WFIterator<T extends Feature>
    implements CloseableTribbleIterator {
        private T currentRecord;
        private LineReader reader;

        public WFIterator() throws IOException {
            InputStream inputStream = ParsingUtils.openInputStream(AsciiFeatureReader.this.path);
            if (AsciiFeatureReader.this.path.endsWith(".gz")) {
                GZIPInputStream is = new GZIPInputStream(new BufferedInputStream(inputStream, 512000));
                this.reader = new AsciiLineReader(is, 1000);
            } else {
                this.reader = new AsciiLineReader(inputStream, 512000);
            }
            this.readNextRecord();
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            T ret = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + ret.getChr() + ":" + ret.getStart() + "-" + ret.getEnd(), e);
            }
            return ret;
        }

        private void readNextRecord() throws IOException {
            String nextLine;
            this.currentRecord = null;
            while ((nextLine = this.reader.readLine()) != null) {
                Object f = null;
                try {
                    f = AsciiFeatureReader.this.codec.decode(nextLine);
                    if (f == null) continue;
                    this.currentRecord = f;
                    return;
                }
                catch (TribbleException e) {
                    e.setSource(AsciiFeatureReader.this.path);
                    throw e;
                }
                catch (NumberFormatException e) {
                    String error = "Error parsing line: " + nextLine;
                    throw new TribbleException.MalformedFeatureFile(error, AsciiFeatureReader.this.path, e);
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        public void close() {
            this.reader.close();
        }

        @Override
        public WFIterator<T> iterator() {
            return this;
        }
    }
}

