/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.tools.AlignmentPair;
import org.broad.igv.hic.tools.AsciiPairIterator;
import org.broad.tribble.util.LittleEndianOutputStream;

public class AsciiToBinConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String inputPath, String outputFile, List<Chromosome> chromosomes) throws IOException {
        HashMap<String, Integer> chromosomeOrdinals = new HashMap<String, Integer>();
        for (Chromosome c : chromosomes) {
            chromosomeOrdinals.put(c.getName(), c.getIndex());
        }
        AsciiPairIterator iter = null;
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(outputFile));
            LittleEndianOutputStream les = new LittleEndianOutputStream(bos);
            iter = new AsciiPairIterator(inputPath, chromosomeOrdinals);
            while (iter.hasNext()) {
                AlignmentPair pair = iter.next();
                les.writeInt(pair.getChr1());
                les.writeInt(pair.getPos1());
                les.writeInt(pair.getChr2());
                les.writeInt(pair.getPos2());
            }
            les.flush();
            bos.flush();
        }
        finally {
            if (iter != null) {
                iter.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }
}

