/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedRange
implements Range<Double> {
    private Double positiveSum;
    private int positiveCount;
    private Double negativeSum;
    private int negativeCount;
    private List<Positionable> positions;

    public AggregatedRange() {
        this(null);
    }

    public AggregatedRange(Collection<Positionable> collection) {
        this.positions = collection == null ? new ArrayList<Positionable>() : new ArrayList<Positionable>(collection);
        Collections.sort(this.positions);
    }

    @Override
    public Double lower() {
        return this.minimum();
    }

    @Override
    public Double upper() {
        return this.maximum();
    }

    public double getPositiveSum() {
        if (this.positiveSum == null) {
            this.updatePositives();
        }
        return this.positiveSum;
    }

    public int getPositiveCount() {
        if (this.positiveSum == null) {
            this.updatePositives();
        }
        return this.positiveCount;
    }

    private void updatePositives() {
        double d = 0.0;
        this.positiveCount = 0;
        if (this.positions != null) {
            for (Positionable positionable : this.positions) {
                if (!(positionable.position() >= 0.0)) continue;
                d += positionable.position();
                ++this.positiveCount;
            }
        }
        this.positiveSum = d;
    }

    public double getNegativeSum() {
        if (this.negativeSum == null) {
            this.updateNegatives();
        }
        return this.negativeSum;
    }

    public int getNegativeCount() {
        if (this.negativeSum == null) {
            this.updateNegatives();
        }
        return this.negativeCount;
    }

    private void updateNegatives() {
        double d = 0.0;
        this.negativeCount = 0;
        if (this.positions != null) {
            for (Positionable positionable : this.positions) {
                if (!(positionable.position() < 0.0)) continue;
                d += positionable.position();
                ++this.negativeCount;
            }
        }
        this.negativeSum = d;
    }

    @Override
    public double minimum() {
        if (this.positions == null || this.positions.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        Positionable positionable = this.positions.get(0);
        return positionable.position();
    }

    @Override
    public double maximum() {
        if (this.positions == null || this.positions.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        Positionable positionable = this.positions.get(this.positions.size() - 1);
        return positionable.position();
    }

    @Override
    public double size() {
        return this.maximum() - this.minimum();
    }

    @Override
    public boolean contains(Double d) {
        return d != null && d >= this.minimum() && d <= this.maximum();
    }

    @Override
    public void adjust(Double d, Double d2) {
        throw new UnsupportedOperationException("An aggregated range is immutable");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("An aggregated range is immutable");
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("An aggregated range is immutable");
    }
}

