/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;

public class SpliceJunctionHelper {
    static Logger log = Logger.getLogger(SpliceJunctionHelper.class);
    List<SpliceJunctionFeature> spliceJunctionFeatures = new ArrayList<SpliceJunctionFeature>();
    Map<Integer, Map<Integer, SpliceJunctionFeature>> posStartEndJunctionsMap = new HashMap<Integer, Map<Integer, SpliceJunctionFeature>>();
    Map<Integer, Map<Integer, SpliceJunctionFeature>> negStartEndJunctionsMap = new HashMap<Integer, Map<Integer, SpliceJunctionFeature>>();
    PreferenceManager prefs = PreferenceManager.getInstance();
    int minJunctionCoverage = this.prefs.getAsInt("SAM.JUNCTION_MIN_COVERAGE");
    int minReadFlankingWidth = this.prefs.getAsInt("SAM.JUNCTION_MIN_FLANKING_WIDTH");

    public List<SpliceJunctionFeature> getFeatures() {
        return this.spliceJunctionFeatures;
    }

    public void addAlignment(Alignment alignment) {
        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
        if (blocks == null || blocks.length < 2) {
            return;
        }
        Object strandAttr = alignment.getAttribute("XS");
        boolean isNegativeStrand = strandAttr != null ? strandAttr.toString().charAt(0) == '-' : alignment.isNegativeStrand();
        Map<Integer, Map<Integer, SpliceJunctionFeature>> startEndJunctionsMapThisStrand = isNegativeStrand ? this.negStartEndJunctionsMap : this.posStartEndJunctionsMap;
        int flankingStart = -1;
        int junctionStart = -1;
        int gapCount = -1;
        char[] gapTypes = alignment.getGapTypes();
        for (AlignmentBlock block : blocks) {
            int flankingEnd = block.getEnd();
            int junctionEnd = block.getStart();
            if (junctionStart != -1 && gapCount < gapTypes.length && gapTypes[gapCount] == 'N' && (this.minReadFlankingWidth == 0 || junctionStart - flankingStart >= this.minReadFlankingWidth && flankingEnd - junctionEnd >= this.minReadFlankingWidth)) {
                SpliceJunctionFeature junction;
                Map<Integer, SpliceJunctionFeature> endJunctionsMap = startEndJunctionsMapThisStrand.get(junctionStart);
                if (endJunctionsMap == null) {
                    endJunctionsMap = new HashMap<Integer, SpliceJunctionFeature>();
                    startEndJunctionsMapThisStrand.put(junctionStart, endJunctionsMap);
                }
                if ((junction = endJunctionsMap.get(junctionEnd)) == null) {
                    junction = new SpliceJunctionFeature(alignment.getChr(), junctionStart, junctionEnd, isNegativeStrand ? Strand.NEGATIVE : Strand.POSITIVE);
                    endJunctionsMap.put(junctionEnd, junction);
                    this.spliceJunctionFeatures.add(junction);
                }
                junction.addRead(flankingStart, flankingEnd);
            }
            flankingStart = junctionEnd;
            junctionStart = flankingEnd;
            ++gapCount;
        }
    }

    public void finish() {
        if (this.minJunctionCoverage > 1) {
            ArrayList<SpliceJunctionFeature> coveredFeatures = new ArrayList<SpliceJunctionFeature>(this.spliceJunctionFeatures.size());
            for (SpliceJunctionFeature feature : this.spliceJunctionFeatures) {
                if (feature.getJunctionDepth() < this.minJunctionCoverage) continue;
                coveredFeatures.add(feature);
            }
            this.spliceJunctionFeatures = coveredFeatures;
        }
        Collections.sort(this.spliceJunctionFeatures, new Comparator<IGVFeature>(){

            @Override
            public int compare(IGVFeature o1, IGVFeature o2) {
                return o1.getStart() - o2.getStart();
            }
        });
    }
}

